#ifndef	_PIC18_H
#define	_PIC18_H

#if	defined(_18C242) || defined(_18C252) || defined(_18C442) || defined(_18C452) 
#include	<pic18xx2.h>
#endif

#if	defined(_18C658) || defined(_18C858) || defined(_18C958)
#include	<pic18xx8.h>
#endif

#if	defined(_18C601) || defined(_18C801)
#include	<pic18xx1.h>
#endif

#if	defined(_18F010) || defined(_18F020)
#include	<pic18f0x0.h>
#endif

#if	defined(_18F242) || defined(_18F252) || defined(_18F442) || defined(_18F452)
#include	<pic18fxx2.h>
#endif

#if	defined(_18F248) || defined(_18F258) || defined(_18F448) || defined(_18F458)
#include	<pic18fxx8.h>
#endif

#if	defined(_18F6520) || defined(_18F6620) || defined(_18F6720) || \
	defined(_18F8520) || defined(_18F8620) || defined(_18F8720)
#include	<pic18fxx20.h>
#endif

#if	defined(_18F1220) || defined(_18F1320)
#include	<pic18f1220.h>
#endif

#if	defined(_18F2220) || defined(_18F2320) || defined(_18F4220) || defined(_18F4320)
#include	<pic18f2320.h>
#endif

#if	defined(_18F2439) || defined(_18F2539) || defined(_18F4439) || defined(_18F4539)
#include	<pic18fxx39.h>
#endif

#if	defined(_18F6585) || defined(_18F6680) || defined(_18F8585) || defined(_18F8680)
#include	<pic18fxx8x.h>
#endif

#if	defined(_18F6525) || defined(_18F6621) || defined(_18F8525) || defined(_18F8621)
#include	<pic18f6x2x.h>
#endif

#define	CLRWDT()	asm(" clrwdt")
#define	NOP()		asm(" nop")
#define	RESET()		asm(" reset")
#define SLEEP()		asm(" sleep")


#define	___mkstr1(x)	#x
#define	___mkstr(x)	___mkstr1(x)
#define	__CONFIG(n, x)	asm("\tpsect config,class=CONFIG");\
			asm("global config_word" ___mkstr(n)); \
			asm("config_word" ___mkstr(n)":"); \
			asm("\torg ("___mkstr(n)"-1)*2"); \
			asm("\tdw "___mkstr(x))

#define __IDLOC(w)       asm("\tpsect idloc,class=IDLOC");\
			 asm("\tglobal\tidloc_word"); \
			 asm("idloc_word:"); \
			 asm("\tirpc\t__arg," ___mkstr(w)); \
			 asm("\tdb 0f&__arg&h"); \
			 asm("\tendm")
   	                 

#if defined(EEPROM_SIZE)
#define __EEPROM_DATA(a, b, c, d, e, f, g, h) \
			 asm("\tpsect eeprom_data,class=EEDATA"); \
			 asm("\tdb\t" ___mkstr(a) "," ___mkstr(b) "," ___mkstr(c) "," ___mkstr(d) "," \
				      ___mkstr(e) "," ___mkstr(f) "," ___mkstr(g) "," ___mkstr(h))

// MACROS for EEPROM Access
/* macro versions of EEPROM read and write */
#if	EEPROM_SIZE > 256
#define	EEPROM_READ(addr) \
	(EEADRH=(((addr)>>8)&0xFF),EEADR=((addr)&0xFF), \
	CARRY=GIE,GIE=0, \
	DC=PEIE,PEIE=0, \
	EECON1&=0x3F,RD=1, \
	(EEDATA)); \
	GIE=CARRY,PEIE=DC
#elif defined(_18F242) || defined(_18F252) || defined(_18F442) || defined(_18F452) || \
	defined(_18F4320) || defined(_18F1220) || defined(_18F1320)
#define EEPROM_READ(addr) \
	(EEADR=(addr),\
	CARRY=GIE,GIE=0,\
	DC=PEIE,PEIE=0,\
	EECON1&=0x3F,RD=1, \
	PRODH=EEDATA,(PRODH)); \
	GIE=CARRY;PEIE=DC
#else
#define EEPROM_READ(addr) \
	(EEADR=(addr),\
	CARRY=GIE,GIE=0,\
	DC=PEIE,PEIE=0,\
	EECON1&=0x3F,RD=1, \
	(EEDATA)); \
	GIE=CARRY;PEIE=DC
#endif
	
#if	EEPROM_SIZE > 256
#define	EEPROM_WRITE(addr, value) \
	while(WR)continue;EEADRH=(((addr)>>8)&0xFF);EEADR=((addr)&0xFF); \
	EEDATA=(value); \
	EECON1&=0x3F; \
	CARRY=0;if(GIE)CARRY=1;GIE=0; \
	DC=0;if(PEIE)DC=1;PEIE=0; \
	WREN=1;EECON2=0x55;EECON2=0xAA;WR=1; \
	while(!WR)continue;EEIF=0;WREN=0; \
	if(CARRY)GIE=1;if(DC)PEIE=1
#else
#define	EEPROM_WRITE(addr, value) \
	while(WR)continue;EEADR=((addr)&0xFF); \
	EEDATA=(value); \
	EECON1&=0x3F; \
	CARRY=0;if(GIE)CARRY=1;GIE=0; \
	DC=0;if(PEIE)DC=1;PEIE=0; \
	WREN=1;EECON2=0x55;EECON2=0xAA;WR=1; \
	while(WR)continue;EEIF=0;WREN=0; \
	if(CARRY)GIE=1;if(DC)PEIE=1
#endif
	
/* macro Flash operations*/
/* erasing a flash program memory row*/	
#if defined(SMALL_DATA)
#define FLASH_ERASE(addr) \
	TBLPTRU=0;\
	TBLPTR=(far unsigned char *)addr; \
	EECON1|=0x94;EECON1&=0xBF; \
	CARRY=0;if(GIE)CARRY=1;GIE=0;\
	DC=0;if(PEIE)DC=1;PEIE=0; \
	EECON2=0x55;EECON2=0xAA;WR=1; \
	asm("\tNOP"); \
	if(CARRY)GIE=1; \
	if(DC)PEIE=1
#else
#define FLASH_ERASE(addr) \
	TBLPTR=(far unsigned char *)addr; \
	EECON1|=0x94;EECON1&=0xBF; \
	CARRY=0;if(GIE)CARRY=1;GIE=0;\
	DC=0;if(PEIE)DC=1;PEIE=0; \
	EECON2=0x55;EECON2=0xAA;WR=1; \
	asm("\tNOP"); \
	if(CARRY)GIE=1; \
	if(DC)PEIE=1
#endif

extern unsigned char eeprom_read(unsigned int address);
extern void eeprom_write(unsigned int address,unsigned char data);

extern unsigned char flash_read(unsigned long addr);
extern void flash_write(far unsigned char *,unsigned char,far unsigned char *);
extern void flash_erase(unsigned long addr);

#endif

/* Accurate read/write macros for 16-Bit timers */
/*** please note, the timer needs to be enabled ***
 *** to handle 16-Bit read/write operations for ***
 *** these routines to be of benefit ***/
#define T1RD16ON  T1CON|=0x80
#define T3RD16ON  T3CON|=0x80
#define WRITETIMER0(x) TMR0H=(x>>8);TMR0L=(x&0xFF)
#define WRITETIMER1(x) TMR1H=(x>>8);TMR1L=(x&0xFF)
#define WRITETIMER3(x) TMR3H=(x>>8);TMR3L=(x&0xFF)
#define READTIMER0 (TMR0)
#define READTIMER1 (TMR1)
#define READTIMER3 (TMR3)

/* Global Interrupt Enable */
#ifndef	ei
#define	ei()	((GIE = 1),(GIEL = 1)) 	// Interrupts of Hi/Lo Priority or Peripheral interrupts 
#endif  ei

/* Global Interrupt Disable */
#ifndef	di
#define	di()	((GIE = 0),(GIEL = 0))	// Interrupts of Hi/Lo Priority or Peripheral interrupts 
#endif  di


#endif	/* _PIC18_H */
