#include <p18f4520.h>
#include<stdio.h>
#include<stdlib.h>
#include<delays.h>
#include<string.h>
#include<xlcd.h>

#pragma config OSC = INTIO67	// Internal Oscillator @ 8Mhz with OSC2 at RA6 & OSC1 at RA7
#pragma config FCMEN = OFF		// Fail Safe Clock Monitor : Disabled.
#pragma config IESO = OFF		// Internal External Osc. Switch Over : Disabled.
#pragma config PWRT = OFF		// Power Up Timer : Disabled.
#pragma config BOREN = OFF 		// Brown Out Reset : Disabled.
#pragma config WDT = OFF		// Watch Dog Timer : Disabled.
#pragma config MCLRE = OFF		// MCLRE : Disabled.
#pragma config PBADEN = OFF		// Port B A/D Enable : Disabled. => sortie numrique sur RESET.
#pragma config STVREN = OFF		// Stack oVerflow Reset : Disabled.
#pragma config LVP = OFF		// Low voltage ICSP : Disabled.

#define D_LCD PORTB
#define D4 PORTBbits.RB4
#define D5 PORTBbits.RB5
#define D6 PORTBbits.RB6
#define D7 PORTBbits.RB7
#define RS PORTBbits.RB1
#define RW PORTBbits.RB2
#define E PORTBbits.RB3

void DelayFor18TCY(void);
void DelayPORXLCD(void);
void DelayXLCD(void);

void main(void)
{
	TRISB = 0b11110000;// Toutes les broches du port B sont en sortie.
	D_LCD = 0b11110000; // Initialisation des variables, mise  zro des 4 broches de poid faible du PORTB.
	ADCON1=7;
	OpenXLCD(FOUR_BIT & LINES_5X7 );	//Initialisation du LCD en 4 bits, 2x16
	DelayXLCD();						//Temporisation pour LCD


	SetDDRamAddr(0x00);	// positionne le curseur en x,y (1re ligne-1er caractre
	putrsXLCD("BONJOUR");   
	DelayXLCD();			//Temporisation de 20 ms
	SetDDRamAddr(0x40);	  // positionne le curseur en x,y (Dbut 2me ligne)
	putrsXLCD("TARELEC");
	while(1);
}

void DelayFor18TCY(void)
{
    Delay10TCYx(2);
}
void DelayPORXLCD(void)
{
 	Delay1KTCYx(15);     //Delai de 15 ms
}
void DelayXLCD(void)
{
 	Delay1KTCYx(20);     //Delai de 20 ms
}