/*
 * Project name:
     StepperMotorControl
 * Copyright:
     MBL
 * Description:
     Commande pas--pas
     frquence de pas commande par entres
               RA0 en A/N; sinus [0,Pi/2]. sortie PORTC.F0
               RA1 en A/N; sinus [0,Pi/2]; sortie PORTC.F1

 * Test configuration:
     MCU:             PIC18F252
     Dev.Board:       EasyPIC5
     Oscillator:      HS, 20.0000 MHz  valTimer0 = 216
     Oscillator:      HS, 35.46895 MHz  valTimer0 = 185
     Ext. Modules:    Entres ana sur PORTA.F0 et F1 (F2 et F3 as Vref)
                      LCD 16x2 sur PORTB
                      Sorties sur PORTC
     SW:              mikroC v8.0
 * NOTES:
     None.
 */

//Dclaration varibles
int sens[6]; //sens rotation moteurs
double JoyDZ[6][2]; //Limites des zones mortes
double JoyBd[6][2]; //Mini et Maxi des joysticks
unsigned int cnt[6]; //compteur moteurs
double ANval[6]; //Val num sur RA0 et RA1
double periode[6]; //Priode lie  RA0
double periode2[6]; //Priode lie  RA0
double tmp;
unsigned int i; //var de boucle pour procdure autres que void
unsigned int j; //var de boucle pour main
const int valTimer0 = 216;
const double Pi = 3.1416;
const double demiPi = 1.570796;

unsigned int counter; //var de boucle pour main

#include "HeaderJoyboard.h"

char text[13];


void interrupt() {
  ++counter;
  // Increment value of cnt on every interrupt
  if (!(sens[0]==0)) {++cnt[0];}
  if (!(sens[1]==0)) {++cnt[1];}
  if (!(sens[2]==0)) {++cnt[2];}
  if (!(sens[3]==0)) {++cnt[3];}
  if (!(sens[4]==0)) {++cnt[4];}
  if (!(sens[5]==0)) {++cnt[5];}

  //Front montant sortie si priode atteint
  if (cnt[0] >= periode[0]) {PORTD.F0 = 1; cnt[0] = 0;}
  if (cnt[1] >= periode[1]) {PORTD.F1 = 1; cnt[1] = 0;}
  if (cnt[2] >= periode[2]) {PORTD.F2 = 1; cnt[2] = 0;}
  if (cnt[3] >= periode[3]) {PORTD.F3 = 1; cnt[3] = 0;}
  if (cnt[4] >= periode[4]) {PORTD.F4 = 1; cnt[4] = 0;}
  if (cnt[5] >= periode[5]) {PORTD.F5 = 1; cnt[5] = 0;}

  //Remise  0 sortie sur interruption suivante
  if (cnt[0] >= periode2[0]) {PORTD.F0 = 0;}
  if (cnt[1] >= periode2[1]) {PORTD.F1 = 0;}
  if (cnt[2] >= periode2[2]) {PORTD.F2 = 0;}
  if (cnt[3] >= periode2[3]) {PORTD.F3 = 0;}
  if (cnt[4] >= periode2[4]) {PORTD.F4 = 0;}
  if (cnt[5] >= periode2[5]) {PORTD.F5 = 0;}
  
  //Rinitialiser le Timer0
  TMR0L   = valTimer0; //Dlai=(256-PRC)*4*PRD*1/FH
  INTCON = 0xA0; // Set T0IE, clear T0IF   0x20
}


void main() {
  initIO();
  //initLCD();
  initVarss();
  initTimer0();

  do {
    //conversions AN
    counter=0;
    for (j=0; j<3; ++j) {
      //LCD_Out(1,j*5 + 1,text);
      if (j==0) {PORTC.F0=1;}
      if (j==1) {PORTC.F1=1;}
      if (j==2) {PORTC.F2=1;}

      //delay_ms(10); //pour analyser le fonctionnement
      ANval[j*2] = Adc_Read(1) + 1;
      ANval[j*2+1] = Adc_Read(0) + 1;
      PORTC=0x00;
      WordToStr(counter, text);
    }
    calcPeriodes();
//    PrintANval();
//    Print();
  } while(1);
}

//Calcul priodes avec rapport cyclique  50%
void calcPeriodes() {
  for (i=0; i<6; ++i) {
    if (ANval[i] > JoyDZ[i][1]) {
      tmp = (ANval[i] - JoyDZ[i][1]) / (JoyBd[i][1] - JoyDZ[i][1]) * demiPi ;
      periode[i] = 1 / (0.03 * sin(tmp));   //tmp = sin(tmp);
      periode2[i] = periode[i]/2;
      sens[i] = 1;
    }
    else if (ANval[i] < JoyDZ[i][0]) {
      tmp = (ANval[i] - JoyBd[i][0]) / (JoyDZ[i][0] - JoyBd[i][0]) * demiPi + demiPi;
      periode[i] = 1 / (0.03 * sin(tmp));   //tmp = sin(tmp);
      periode2[i] = periode[i]/2;
      sens[i] = -1;
    }
    else {
      sens[i] = 0;
    }
  }
}

void initIO() {
  //initialisation RA0 et convertion A/N
  ADCON1 = 0b00111101; //0x80; //OxC0 RA0 et RA1 as A/N   ou Ob00111011
  TRISA = 0b00001111; //PORTA = INPUT or OUTPUT
  TRISD = 0x00;
  PORTD = 0x00;
  TRISC = 0x00;
  PORTC = 0x00;
  TRISB = 0x00;
  PORTB = 0x00;
  UCON.USBEN = 0; // dsactive l'USB sur port C4 et C5
  UCFG.UTRDIS = 1; // dsactive le transmetteur USB sur port C4 et C5
}

//Init du timer0 interruption unique
void initTimer0() {
  T0CON = 0b11000000; // PORTB pull-ups disabled, prescaler TMR0=1:2
  TMR0L  = valTimer0;      // Valeur de dpart du timer
  INTCON = 0xA0;    // Enable TMRO interrupt
}

void initVarss() {
  for (i=0; i<6; ++i) {
    JoyBd[i][1]=1024; //1024 maxi
    JoyDZ[i][1]=640; //maxi de la zone morte
    JoyDZ[i][0]=570; //mini de la zone morte
    JoyBd[i][0]=1; //au moins 0
    sens[i]=0;
    cnt[i]=0;
    periode[i]=2;
    periode2[i]=1;
  }
}