#include <p18f4520.h>
#include<stdio.h>
#include<stdlib.h>
#include<delays.h>
#include<string.h>
#include <xlcd.h>

#pragma config OSC = INTIO67	// Internal Oscillator @ 8Mhz with OSC2 at RA6 & OSC1 at RA7
#pragma config FCMEN = OFF		// Fail Safe Clock Monitor : Disabled.
#pragma config IESO = OFF		// Internal External Osc. Switch Over : Disabled.
#pragma config PWRT = OFF		// Power Up Timer : Disabled.
#pragma config BOREN = OFF 		// Brown Out Reset : Disabled.
#pragma config WDT = OFF		// Watch Dog Timer : Disabled.
//#pragma config MCLRE = OFF		// MCLRE : Disabled.
#pragma config PBADEN = OFF		// Port B A/D Enable : Disabled. => sortie numrique sur RESET.
#pragma config STVREN = OFF		// Stack oVerflow Reset : Disabled.
#pragma config LVP = OFF		// Low voltage ICSP : Disabled.

#define D_LCD PORTB
#define D4 PORTBbits.RB0
#define D5 PORTBbits.RB1
#define D6 PORTBbits.RB2
#define D7 PORTBbits.RB3
#define LED PORTBbits.RB7

#define BOUTONS PORTD
#define BOUTON PORTDbits.RD0
#define INCREMENTE PORTDbits.RD1
#define DECREMENTE PORTDbits.RD2
#define GAUCHE PORTDbits.RD3
#define DROITE PORTDbits.RD4
#define VALIDE PORTDbits.RD5

void DelayFor18TCY(void);
void DelayPORXLCD(void);
void DelayXLCD(void);
void AnneeBissextile(void);

unsigned char text1[]= "Initialisation";        //14 caractres
unsigned char text2[]= "En cours....";          //11 caractres

unsigned char LCDmenu1[] = "Reglage heures:";
unsigned char LCDmenu2[] = "Reglage minutes:";
unsigned char LCDmenu3[] = "Reglage secondes:";
unsigned char LCDmenu4[] = "Reglage date:";
unsigned char LCDmenu5[] = "Reglage mois:";
unsigned char LCDmenu6[] = "Reglage annee:";
unsigned char mess[17];
unsigned char mot[]="NOMBRE";

int heures;
int minutes;
int secondes;
int jours;
int mois;
int annees;
int Bissextile;

void main(void)
{
	//Dclaration,Initialisation des variables
	heures=0;
	minutes=0;
	secondes=0;
	jours=0;
	mois=0;
	annees=2010;
	
	//Configuration des PORTS
	
	//PORTA
	//....................
	
	//PORTB:Interface LCD-C
	TRISB = 0b00000000;// Toutes les broches du port B sont en sortie.
	D_LCD = 0b00000000; // Initialisation des variables, mise  zro des 4 broches de poid faible du PORTB.
	
	//PORTC
	//....................
	
	//PORTD:Iinterface Utilisateur-C
	TRISD=0b00111111;	// 3 bits de poids faible configures en entre
	BOUTONS=0b00000000;	//Initialisation du PORTD
	
	
	//Initialisation LCD
//	ADCON1=7;
//	Delay10KTCYx(10);
	OpenXLCD(FOUR_BIT & LINES_5X7);	//Initialisation du LCD en 4 bits, 2x16
//	DelayXLCD();						//Temporisation pour LCD
//	Delay10KTCYx(10);
	while(BusyXLCD());
	LED = 1;
	WriteCmdXLCD(0x80);
	while(BusyXLCD());
	WriteCmdXLCD(DOFF & CURSOR_OFF & BLINK_OFF);
	while(BusyXLCD());
	WriteCmdXLCD( 0x01);
	while(BusyXLCD());
	WriteCmdXLCD(DON);
	while(BusyXLCD());
	
	SetDDRamAddr(0x00);
	putsXLCD(text1);
	Delay1KTCYx(200);
//	WriteCmdXLCD(0x01); //Efface l'cran
/*	sprintf(mess,"%s:%.2d:%.2d:%.2d\n",mot,heures,minutes,secondes);
	SetDDRamAddr(64); 
	putsXLCD(mess);*/
	while(1)
	{
/*		WriteCmdXLCD(0x01); //Efface l'cran
		sprintf(mess,"%.2d:%.2d:%.2d\n",heures,minutes,secondes);
		SetDDRamAddr(0x40); 
		putsXLCD(mess);*/
		
		while(BOUTON==1)
		{
			//Saisie de l'Heure
			WriteCmdXLCD(0x01); //Efface l'cran
			sprintf(mess,"%.2d:%.2d:%.2d",heures,minutes,secondes);
			SetDDRamAddr(0);
			putsXLCD(LCDmenu1);
			SetDDRamAddr(68); 
			putsXLCD(mess);
		
			while(VALIDE==0)
			{
				if(INCREMENTE==1)
				{
					if(heures<23)heures++;
					WriteCmdXLCD(0x01); //Efface l'cran
					sprintf(mess,"%.2d:%.2d:%.2d",heures,minutes,secondes);
					SetDDRamAddr(0);
					putsXLCD(LCDmenu1);
					SetDDRamAddr(68); 
					putsXLCD(mess);
				}
				if(DECREMENTE==1)
				{
					if(heures>0)heures--;
					WriteCmdXLCD(0x01); //Efface l'cran
					sprintf(mess,"%.2d:%.2d:%.2d",heures,minutes,secondes);
					SetDDRamAddr(0);
					putsXLCD(LCDmenu1);
					SetDDRamAddr(68); 
					putsXLCD(mess);
				}
				Delay1KTCYx(50);
			}
			Delay1KTCYx(100);
			
			
			//Saisie des Minutes
			WriteCmdXLCD(0x01); //Efface l'cran
			sprintf(mess,"%.2d:%.2d:%.2d\n",heures,minutes,secondes);
			SetDDRamAddr(0);
			putsXLCD(LCDmenu2);
			SetDDRamAddr(68); 
			putsXLCD(mess);
			
			while(VALIDE==0)
			{
				if(INCREMENTE==1)
				{
					if(minutes<59)minutes++;
					WriteCmdXLCD(0x01); //Efface l'cran
					sprintf(mess,"%.2d:%.2d:%.2d\n",heures,minutes,secondes);
					SetDDRamAddr(0);
					putsXLCD(LCDmenu2);
					SetDDRamAddr(68); 
					putsXLCD(mess);
				}
				if(DECREMENTE==1)
				{
					if(minutes>0)minutes--;
					WriteCmdXLCD(0x01); //Efface l'cran
					sprintf(mess,"%.2d:%.2d:%.2d\n",heures,minutes,secondes);
					SetDDRamAddr(0);
					putsXLCD(LCDmenu2);
					SetDDRamAddr(68); 
					putsXLCD(mess);
				}
				Delay1KTCYx(50);
			}
			Delay1KTCYx(100);
			
			
			//Saisie des Secondes
			WriteCmdXLCD(0x01); //Efface l'cran
			sprintf(mess,"%.2d:%.2d:%.2d\n",heures,minutes,secondes);
			SetDDRamAddr(0);
			putsXLCD(LCDmenu3);
			SetDDRamAddr(68); 
			putsXLCD(mess);
			
			while(VALIDE==0)
			{
				if(INCREMENTE==1)
				{
					if(secondes<59)secondes++;
					WriteCmdXLCD(0x01); //Efface l'cran
					sprintf(mess,"%.2d:%.2d:%.2d\n",heures,minutes,secondes);
					SetDDRamAddr(0);
					putsXLCD(LCDmenu3);
					SetDDRamAddr(68); 
					putsXLCD(mess);
				}
				if(DECREMENTE==1)
				{
					if(secondes>0)secondes--;
					WriteCmdXLCD(0x01); //Efface l'cran
					sprintf(mess,"%.2d:%.2d:%.2d\n",heures,minutes,secondes);
					SetDDRamAddr(0);
					putsXLCD(LCDmenu3);
					SetDDRamAddr(68); 
					putsXLCD(mess);
				}
				Delay1KTCYx(50);
			}
			Delay1KTCYx(100);
			
			
			//Saisie de l'Anne
			WriteCmdXLCD(0x01); //Efface l'cran
			sprintf(mess,"%.2d/%.2d/%.4d\n",jours,mois,annees);
			SetDDRamAddr(2);
			putsXLCD(LCDmenu6);
			SetDDRamAddr(68); 
			putsXLCD(mess);
			
			while(VALIDE==0)
			{
				if(INCREMENTE==1)
				{
					if(annees<2100)annees++;
					WriteCmdXLCD(0x01); //Efface l'cran
					sprintf(mess,"%.2d/%.2d/%.4d\n",jours,mois,annees);
					SetDDRamAddr(2);
					putsXLCD(LCDmenu6);
					SetDDRamAddr(68); 
					putsXLCD(mess);
				}
				if(DECREMENTE==1)
				{
					if(annees>0)annees--;
					WriteCmdXLCD(0x01); //Efface l'cran
					sprintf(mess,"%.2d/%.2d/%.4d\n",jours,mois,annees);
					SetDDRamAddr(2);
					putsXLCD(LCDmenu6);
					SetDDRamAddr(68); 
					putsXLCD(mess);
				}
				Delay1KTCYx(50);
			}
			Delay1KTCYx(100);
			
			
			//Saisie du Mois
			WriteCmdXLCD(0x01); //Efface l'cran
			sprintf(mess,"%.2d/%.2d/%.2d\n",jours,mois,annees);
			SetDDRamAddr(2);
			putsXLCD(LCDmenu5);
			SetDDRamAddr(68); 
			putsXLCD(mess);
			
			while(VALIDE==0)
			{
				if(INCREMENTE==1)
				{
					if(mois<11)mois++;
					WriteCmdXLCD(0x01); //Efface l'cran
					sprintf(mess,"%.2d/%.2d/%.2d\n",jours,mois,annees);
					SetDDRamAddr(2);
					putsXLCD(LCDmenu5);
					SetDDRamAddr(68); 
					putsXLCD(mess);
				}
				if(DECREMENTE==1)
				{
					if(mois>0)mois--;
					WriteCmdXLCD(0x01); //Efface l'cran
					sprintf(mess,"%.2d/%.2d/%.2d\n",jours,mois,annees);
					SetDDRamAddr(2);
					putsXLCD(LCDmenu5);
					SetDDRamAddr(68); 
					putsXLCD(mess);
				}
				Delay1KTCYx(50);
			}	
			
			
			//Saisie du Jour
			WriteCmdXLCD(0x01); //Efface l'cran
			sprintf(mess,"%.2d/%.2d/%.2d\n",jours,mois,annees);
			SetDDRamAddr(2);
			putsXLCD(LCDmenu4);
			SetDDRamAddr(68); 
			putsXLCD(mess);
			
			while(VALIDE==0)
			{
				if(INCREMENTE==1)
				{
					if(mois==2)		//Mois de fvrier
					{
						AnneeBissextile();
						if(Bissextile==1)
						{
							if(jours<29)jours++;
							WriteCmdXLCD(0x01); //Efface l'cran
							sprintf(mess,"%.2d/%.2d/%.2d\n",jours,mois,annees);
							SetDDRamAddr(2);
							putsXLCD(LCDmenu4);
							SetDDRamAddr(68); 
							putsXLCD(mess);
						}
						else
						{
							if(jours<28)jours++;
							WriteCmdXLCD(0x01); //Efface l'cran
							sprintf(mess,"%.2d/%.2d/%.2d\n",jours,mois,annees);
							SetDDRamAddr(2);
							putsXLCD(LCDmenu4);
							SetDDRamAddr(68); 
							putsXLCD(mess);
						}
					}
					else
					{
						if((mois==4)||(mois==6)||(mois==9)||(mois==11))
						{
							if(jours<30)jours++;
							WriteCmdXLCD(0x01); //Efface l'cran
							sprintf(mess,"%.2d/%.2d/%.2d\n",jours,mois,annees);
							SetDDRamAddr(2);
							putsXLCD(LCDmenu4);
							SetDDRamAddr(68); 
							putsXLCD(mess);
						}
						else
						{
							if(jours<31)jours++;
							WriteCmdXLCD(0x01); //Efface l'cran
							sprintf(mess,"%.2d/%.2d/%.2d\n",jours,mois,annees);
							SetDDRamAddr(2);
							putsXLCD(LCDmenu4);
							SetDDRamAddr(68); 
							putsXLCD(mess);
						}
					}
				}
				if(DECREMENTE==1)
				{
					if(jours>0)jours--;
					WriteCmdXLCD(0x01); //Efface l'cran
					sprintf(mess,"%.2d/%.2d/%.2d\n",jours,mois,annees);
					SetDDRamAddr(2);
					putsXLCD(LCDmenu4);
					SetDDRamAddr(68); 
					putsXLCD(mess);
				}
				Delay1KTCYx(50);
			}
			Delay1KTCYx(100);
		}
	}
}

void DelayFor18TCY(void)
{
    Delay10TCYx(2);
}
void DelayPORXLCD(void)
{
 	Delay1KTCYx(15);     //Delai de 15 ms
}
void DelayXLCD(void)
{
 	Delay1KTCYx(20);     //Delai de 20 ms
}

void AnneeBissextile(void)
{
	int ResDiv4;
    int ResDiv100;
    int ResDiv400;
    
    ResDiv4=annees%4;
    ResDiv100=annees%100;
    ResDiv400=annees%400;
    
    if(((ResDiv4==0)&&(ResDiv100!=0))||(ResDiv400==0))
    {
        Bissextile=1;
    }
    else
    {
        Bissextile=0;
    }
}