#include "stm32f10x_conf.h"
#include "systick.h"

#define MISO GPIOB->IDR&1<<8
#define IRQ  GPIOB->IDR&1<<1
 
#define CE_BIT  	(1<<7)
#define CSN_BIT  	(1<<6)
#define SCK_BIT   	(1<<5)
#define MOSI_BIT   	(1<<9)

#define CE(x) 		GPIOB->ODR=(GPIOB->ODR&~CE_BIT)|(x ? CE_BIT:0)
#define CSN(x) 		GPIOB->ODR=(GPIOB->ODR&~CSN_BIT)|(x ? CSN_BIT:0)
#define SCK(x)  	GPIOB->ODR=(GPIOB->ODR&~SCK_BIT)|(x ? SCK_BIT:0)
#define MOSI(x)  	GPIOB->ODR=(GPIOB->ODR&~MOSI_BIT)|(x ? MOSI_BIT:0)


//****************************************************************//
// SPI(nRF24L01) commands
#define READ_REG        0x00  // Define read command to register
#define WRITE_REG       0x20  // Define write command to register
#define RD_RX_PLOAD     0x61  // Define RX payload register address
#define WR_TX_PLOAD     0xA0  // Define TX payload register address
#define FLUSH_TX        0xE1  // Define flush TX register command
#define FLUSH_RX        0xE2  // Define flush RX register command
#define REUSE_TX_PL     0xE3  // Define reuse TX payload register command
#define ACTIVATE	0X50//active or disable the follow three commonds,with 0x73
#define R_RX_PL_WID	0X60	//read the wideth of RX payload ,which is in zhe top of FIFO
#define W_ACK_PAYLOAD	0XA8	//write ack_payload to pipe u by the form of (W_ACK_PAYLOAD|u)
#define W_TX_PAYLOAD_NOACK 0XB0	//disable autoack of the following packet in TX FIFO
#define NOP             0xFF  // Define No Operation, might be used to read status register

//***************************************************//
// SPI(nRF24L01) registers(addresses)
#define CONFIG          0x00  // 'Config' register address
#define EN_AA           0x01  // 'Enable Auto Acknowledgment' register address
#define EN_RXADDR       0x02  // 'Enabled RX addresses' register address
#define SETUP_AW        0x03  // 'Setup address width' register address
#define SETUP_RETR      0x04  // 'Setup Auto. Retrans' register address
#define RF_CH           0x05  // 'RF channel' register address
#define RF_SETUP        0x06  // 'RF setup' register address
#define STATUS          0x07  // 'Status' register address
#define OBSERVE_TX      0x08  // 'Observe TX' register address
#define CD              0x09  // 'Carrier Detect' register address
#define RX_ADDR_P0      0x0A  // 'RX address pipe0' register address
#define RX_ADDR_P1      0x0B  // 'RX address pipe1' register address
#define RX_ADDR_P2      0x0C  // 'RX address pipe2' register address
#define RX_ADDR_P3      0x0D  // 'RX address pipe3' register address
#define RX_ADDR_P4      0x0E  // 'RX address pipe4' register address
#define RX_ADDR_P5      0x0F  // 'RX address pipe5' register address
#define TX_ADDR         0x10  // 'TX address' register address
#define RX_PW_P0        0x11  // 'RX payload width, pipe0' register address
#define RX_PW_P1        0x12  // 'RX payload width, pipe1' register address
#define RX_PW_P2        0x13  // 'RX payload width, pipe2' register address
#define RX_PW_P3        0x14  // 'RX payload width, pipe3' register address
#define RX_PW_P4        0x15  // 'RX payload width, pipe4' register address
#define RX_PW_P5        0x16  // 'RX payload width, pipe5' register address
#define FIFO_STATUS     0x17  // 'FIFO Status Register' register address
#define DYNPD		0x1C  	// 'Enable dynamic payload length' register address
#define FEATURE		0x1D	// 'Feature' register address
//***************************************************************//
//                   FUNCTION's PROTOTYPES  //

#define TX_ADR_WIDTH    5	// 5 bytes TX(RX) address width
#define TX_PLOAD_WIDTH  1  	// 1 byte TX payload

void init_io(void);
unsigned char SPI_RW(unsigned char byte);
unsigned char SPI_RW_Reg(unsigned char reg, unsigned char value);
unsigned char SPI_Read(unsigned char reg);
unsigned char SPI_Read_Buf(unsigned char reg, unsigned char *pBuf, unsigned char bytes);
unsigned char SPI_Write_Buf(unsigned char reg, unsigned char *pBuf, unsigned char bytes);
void RX_Mode(void);
void TX_Mode(void);
unsigned char check_ACK(void);



