------------------------------------------------------------------
--	Programmierung des PLL IC's. (Ldt die Register des PLLIC's,
--	damit das Teilerverhltniss und andere einstellungen stimmen.)
--	M.Bachmann
--	16.11.09
------------------------------------------------------------------


library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity programm_pll is
  port(
    pll_clk_out	:	out std_logic;
    pll_enable 	:	out std_logic;
	pll_data	:   out std_logic;
	ref_clk   	:	in std_logic
  );
end programm_pll;



architecture behaviour of programm_pll is

SIGNAL clk_div_folge		: unsigned(3 downto 0);
SIGNAL clk_div_geg			: unsigned(3 downto 0):=to_unsigned(0,4);
SIGNAL pll_clk				: std_logic;
SIGNAL npll_clk				: std_logic;
SIGNAL shift_enable			: std_logic:='0';
SIGNAL pll_data_cnt_folge	: unsigned(7 downto 0);
SIGNAL pll_data_cnt_geg		: unsigned(7 downto 0):=to_unsigned(0,8);
SIGNAL pll_reg0_folge		: unsigned(23 downto 0);
SIGNAL pll_reg0_geg			: unsigned(23 downto 0):="000001110000000000000000"; --Erstes Register
SIGNAL pll_reg3_folge		: unsigned(23 downto 0);
SIGNAL pll_reg3_geg			: unsigned(23 downto 0):="000100000000000000110111"; --Zweites Register
SIGNAL pll_reg4_folge		: unsigned(23 downto 0);
SIGNAL pll_reg4_geg			: unsigned(23 downto 0):="001000000100011111111001"; --Drittes Register

begin

-- Sequenzieller Prozess zum Schieben der Daten Register
shiftreg_c:	PROCESS (shift_enable,npll_clk)
			BEGIN
			IF shift_enable='1' THEN
				IF npll_clk'EVENT AND npll_clk='1' THEN
					pll_reg0_geg <= pll_reg0_folge;
					pll_reg3_geg <= pll_reg3_folge;
					pll_reg4_geg <= pll_reg4_folge;
				END IF;
			END IF;
			END PROCESS shiftreg_c;

-- Kombinatorischer Prozess zum Schieben der Daten Register
shiftreg_l:	PROCESS (pll_reg0_geg,pll_reg3_geg,pll_reg4_geg)
			BEGIN
				pll_reg0_folge(23 downto 1) <= pll_reg0_geg(22 downto 0);
				pll_reg0_folge(0) <= pll_reg3_geg(23);
				pll_reg3_folge(23 downto 1) <= pll_reg3_geg(22 downto 0);
				pll_reg3_folge(0) <= pll_reg4_geg(23);
				pll_reg4_folge(23 downto 1) <= pll_reg4_geg(22 downto 0);
				pll_reg4_folge(0) <= '0'; --Mit nullen auffllen
			END PROCESS shiftreg_l;

-- Sequenzieller Prozess zum Zhlen wieviele bits gesendet wurden
shiftcnt_c:	PROCESS (npll_clk, pll_data_cnt_folge,pll_data_cnt_geg)
			BEGIN
				IF npll_clk'EVENT AND npll_clk='1' THEN
					pll_data_cnt_geg <= pll_data_cnt_folge;
				END IF;
			END PROCESS shiftcnt_c;

-- Kombinatorischer Prozess zum Zhlen wieviele bits gesendet wurden
shiftcnt_l:	PROCESS (pll_data_cnt_folge,pll_data_cnt_geg)
			BEGIN
				IF pll_data_cnt_geg(7)='0' THEN --Zuerst werden 4*32 bit nichts gemacht um das aufstarten des Anderen IC's abzuwarten.
					pll_data_cnt_folge <= pll_data_cnt_geg + 1;
					shift_enable <= '0';
				ELSIF pll_data_cnt_geg(6 downto 2)="11111" THEN  --Danach werden 4*32 Bit Daten gesendet und zulezt wird gestoppt bis zum Neustart.
					shift_enable <= '0';
					pll_data_cnt_folge <= pll_data_cnt_geg;
				ELSE
					pll_data_cnt_folge <= pll_data_cnt_geg + 1;
					shift_enable <= not (pll_data_cnt_geg(3) and pll_data_cnt_geg(4));
				END IF;
			END PROCESS shiftcnt_l;

--Ausgabe des Microwire Clocks
clk_out:	PROCESS (shift_enable, pll_clk)
			BEGIN
				pll_clk_out <=shift_enable and pll_clk;
			END PROCESS clk_out;
			
--Ausgeben jeweils nach 24 gltigen Datenbits eines Enable Inpulses
pll_ena_l:	PROCESS (pll_data_cnt_geg)
			BEGIN
				IF pll_data_cnt_geg(4 downto 0) ="11000"  THEN
					pll_enable <= '1';
				ELSE
					pll_enable <= '0';
				END IF;
			END PROCESS pll_ena_l;

-- Ausgabe der Daten in den Schieberegistern an die Microwire Schnittstelle
-- Das Lezte daten Register ist etwas unschn gelsst aber wird auch hier ausgegeben wegen Speicherplatz mangel auf Chip.
pll_data_l:	PROCESS (shift_enable, pll_reg0_geg, pll_data_cnt_geg)
			BEGIN
				IF pll_data_cnt_geg(6 downto 2) ="11101"  THEN  --Speziell fr Ausgabe vom 4.Register
					pll_data <= pll_data_cnt_geg(1);
				ELSE
					pll_data <=shift_enable and pll_reg0_geg(23);
				END IF;
			END PROCESS pll_data_l;
			
--Sequenzielle Logik zum Herunterteilen des Clock Signales
clk_div_c:	PROCESS (ref_clk)
			BEGIN
				IF ref_clk'EVENT AND ref_clk='1' THEN
					clk_div_geg <= clk_div_folge;
				END IF;
			END PROCESS clk_div_c;

--Kobinatorische Logik zum Herunterteilen des Clock Signales
clk_div_l:	PROCESS (clk_div_geg)
			BEGIN
				clk_div_folge <= clk_div_geg+1;
			END PROCESS clk_div_l;

--Auskoppeln der beiden Clock Signale des PLL Programmierteil aus dem Clock Teiler.
pll_clk_l:	PROCESS (clk_div_geg)
			BEGIN
				pll_clk <= clk_div_geg(3);
				npll_clk <= not clk_div_geg(3);
			END PROCESS pll_clk_l;
			
end behaviour;