------------------------------------------------------------------
--	Testbench
--	Programmierung des PLL IC's. (Ldt die Register des PLLIC's,
--	damit das Teilerverhltniss und andere einstellungen stimmen.
--	M.Bachmann
--	16.11.09
------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;


entity tb_programm_pll is

end tb_programm_pll;

architecture testbench of tb_programm_pll is

	component programm_pll
	port(
		pll_clk_out	:	out std_logic;
		pll_enable 	:	out std_logic;
		pll_data	:   out std_logic;
		ref_clk   	:	in std_logic
	);
	end component;

	SIGNAL clk_half		: time := 1 ns;		
	signal ref_clk 		: std_logic :='0';	
	signal pll_clk_out	: std_logic;
	signal pll_enable   : std_logic;
	signal pll_data 	: std_logic;
	
begin

	dut: programm_pll
    port map(
		pll_clk_out		=>  pll_clk_out	,
		ref_clk   		=>  ref_clk,
		pll_enable		=> 	pll_enable,
		pll_data		=>	pll_data
    );
	

		
clkgen:	process
		begin
		wait for clk_half;
		ref_clk <= '0';
		wait for clk_half;
		ref_clk <= '1';  
		end process clkgen;

end testbench;


