
;**********************************************************************


	LIST      p=16F84a            ; Dfinition de processeur
	#include <p16F84a.inc>        ; Dfinitions des constantes

	__CONFIG   _CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC



; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation du processeur. Les dfinitions sont dans le fichier include.
; Voici les valeurs et leurs dfinitions :
;	_CP_ON		Code protection ON : impossible de relire
;	_CP_OFF		Code protection OFF
;	_PWRTE_ON	Timer reset sur power on en service
;	_PWRTE_OFF	Timer reset hors-service
;	_WDT_ON		Watch-dog en service
;	_WDT_OFF	Watch-dog hors service
;	_LP_OSC		Oscillateur quartz basse vitesse
;	_XT_OSC		Oscillateur quartz moyenne vitesse
;	_HS_OSC		Oscillateur quartz grande vitesse
;	_RC_OSC		Oscillateur  rseau RC



;*********************************************************************
;                             DEFINE                                 *
;*********************************************************************



; entrees / sorties


#DEFINE  SCL	PORTA,0		; SCL i2c sur RA0
#DEFINE  SDA	PORTA,1		; SDA i2c sur RA1

#DEFINE  LedR	PORTB,4 	; 
#DEFINE  LedV	PORTB,5		; led fin prog corect





N	equ     0C          ; i2c
OCTET	equ     0D          ; i2c

count1  equ     0E         ; 1er compteur
count2  equ     0F         ; 2e compteur pour la tempo



;**********************************************************************
;                      DEMARRAGE SUR RESET                            *
;**********************************************************************


	org 0x000 		; Adresse de dpart aprs reset
  	call    init		; initialiser
	goto	start		; Debut du prog principal



;*********************************************************************
;                       INITIALISATIONS                              *
;*********************************************************************

init
	bsf	STATUS,RP0	; aller en bank1
	movlw	b'0000000'	;
	movwf	TRISB		; port B en sortie
	movlw	b'00000000'
	movwf	TRISA		; port A en sortie
	bcf	STATUS,RP0	; aller en bank0	
	clrf	PORTA
	clrf	PORTB		; mettre ttes les sorties a 0

init_i2c
	bsf	SDA		; SDA a 1
	bsf	SCL		; SCL a 1 = etat de repos du bus i2c

	return



;*********************************************************************
;                      PROGRAMME PRINCIPAL                           *
;*********************************************************************


start			; le prog qui met l'heure ( date et heure ) dans la RTC
	  

	bcf	LedR		; led rouge eteinte ( erreur sur bus I2C )
	bcf	LedV		; led verte eteinte ' tout est OK )

	call	tempo500ms	; tempo stabiliser alim et bus i2c

	call	I2C_START	    ; condition de start du bus I2C

	movlw B'11010000' 	    ; adresse RTC est 1101000 en mode ecriture ( 0 )
	call 	I2C_EMISSION
	call	I2C_SLAVE_ACK

	movlw b'00000000' 	    ; on va a l'adresse ram 0 du RTC
	call 	I2C_EMISSION	 ; 
	call	I2C_SLAVE_ACK

	movlw b'00000000' 	    ; criture dans le registre d'adresse 0
	call 	I2C_EMISSION   	    ; on met 0 dans le registre des SECONDES 
	call	I2C_SLAVE_ACK

	movlw b'00000000' 	    ; criture dans le registre d'adresse 1 
	call 	I2C_EMISSION  	    ; on met 0 dans le registre des MINUTES 
	call	I2C_SLAVE_ACK

	movlw b'00001001' 	    ; criture dans le registre d'adresse 2
	call 	I2C_EMISSION  	    ; ici on met les HEURES 
	call	I2C_SLAVE_ACK

	movlw b'00000110' 	    ; criture dans le registre d'adresse 3 
	call 	I2C_EMISSION  	    ; ici on met les JOURS ( 1 lundi 2 mardi .... 7 dimanche ) 
	call	I2C_SLAVE_ACK

	movlw b'00010000' 	    ; criture dans le registre d'adresse 4
	call 	I2C_EMISSION  	    ; ici on met la DATE 
	call	I2C_SLAVE_ACK

	movlw b'00000011' 	    ; criture dans le registre d'adresse 5
	call 	I2C_EMISSION 	    ; ici on met le MOIS
	call	I2C_SLAVE_ACK

	movlw b'00010010' 	    ; criture dans le registre d'adresse 6
	call 	I2C_EMISSION  	    ; ici on met l' ANNEE
	call	I2C_SLAVE_ACK

	movlw b'10010000'           ; criture du contenu du registre 
	call 	I2C_EMISSION  	    ; de contrle du DS1307  --> F SQWOUT = 1Hz
	call	I2C_SLAVE_ACK

	call 	I2C_STOP	    ; bit de stop de I2C


	bsf	LedV		; fin prog OK allumer Led verte

	sleep			; 



;************     SOUS PROGRAMMES  I2C    *****************************

I2C_START		; ss prog condition de start
	bsf	SCL
	bsf	SDA		; au repos SDA et SCL a 1
	call	tempo_5us
	bcf	SDA 		; SDA passe a 0
	call	tempo_5us
	bcf	SCL		; SCL passe a 0	
	call	tempo_5us
	BSF     SDA 		; >> bus I2C occup
        return


I2C_STOP		; ss prog condition de fin		
	bcf	SCL		
	bcf	SDA
	call	tempo_5us
	bsf	SCL		; SCL passe a 1
	call	tempo_5us
	bsf	SDA		; SDA passe a 1 >> bus I2C au repos
	call	tempo_5us
	return


I2C_SLAVE_ACK		; attend acknowledge de l'esclave
	bsf	SDA		; on s assure que SDA est a 1
	bcf	SCL		; SCL a 0
	call	SDA_IN		; SDA en entree
	call	tempo_5us	; tempo de 5 us
	bsf	SCL		; SCL a 1
	call	tempo_5us	; tempo de 5 us	
	btfsc	SDA		; test si sda a 0 ?
	call	NO_ACK		; NON ( sda tjrs a 1 ) >> NO_ack
	bcf	SCL		; OUI >>>  SCL a 0
	call	tempo_5us	; tempo de 5 us
	call	SDA_OUT		; SDA en sortie
	return


I2C_PIC_ACK		; envoye l'acknowledge du pic vers esclave
	call	SDA_OUT		; SDA en sortie
	bcf	SCL		; SCL a 0
	bcf	SDA		; SDA a 0
	call	tempo_5us	; tempo de 5 us
	bsf	SCL		; SCL a 1
	call	tempo_5us	; tempo de 5 us
	bcf	SCL		; SCL a 0
	bsf	SDA		; SDA a 1
	return


I2C_PIC_NACK		; Nack du pic vers esclave
 	call	SDA_OUT		; SDA en sortie
	bcf	SCL		; SCL a 0
	bsf	SDA		; SDA a 1 ( pas acknowledge )
	call	tempo_5us	; tempo de 5 us	
	bsf	SCL		; SCL a 1
	call	tempo_5us	; tempo de 5 us
	bcf	SCL		; SCL a 0
	return


I2C_EMISSION		; envoye donnee du pic vers esclave
	movwf	OCTET		; les donnees w -->> OCTET
	movlw	d'8'
	movwf	N		; un octet = 8 bits a envoyer
	call	SDA_OUT		; SDA en sortie

envoi
	bcf	SCL		; SCL a 0		
	rlf	OCTET,0		; rotation a gauche dans la carry 
	call	tempo_5us	; tempo de 5 us

	btfsc	C,1		; si carry = 1
	bsf	SDA		; SDA a 1            met SDA a 1 ou a 0
	btfss	C,1		; si carry = 0         suivant etat de
 	bcf	SDA		; SDA a 0                  la carry

	call	tempo_5us	; tempo de 5 us	
	bsf	SCL		; SCL a 1
	call	tempo_5us	; tempo de 5 us

	decfsz	N,f		; decremente N ( si > 0 )
	goto	envoi		; donnees suivante en bouclant

	bcf	SCL		; si I=0  >> SCL a 0
	call	tempo_5us	; tempo de 5 us
	bsf	SDA		; on remet SDA a 1

	return


I2C_RECEPTION		; recois donnees de l esclave vers le pic
	movlw	d'8'
	movwf	N		; la donnees sur 8 bits
	clrf	OCTET
	call	SDA_IN		; SDA en entree

recoi

	bcf	SCL		; SCL a 0
	bsf	SDA		; on met SDA  a 1 pou etre lisible 		
	call	tempo_5us	; tempo de 5 us	

	bsf	SCL		; SCL a 1
	call	tempo_5us	; tempo de 5 us

	btfsc	SDA		; si SDA a 1	 	 met la carry a 1 ou a 0
	bsf	C,1		;			  suivant etat de SDA
	btfss	SDA		; si SDA a 0
	bcf	C,1
	rlf	OCTET,1		; decallage a gauche 

	decfsz	N,f		; si N = 0
	goto	recoi	        ; donnees suivante en bouclant
	bcf	SCL		; SCL a 0
	call	tempo_5us	; tempo de 5 us
	movf	OCTET,w		; met octet recu dans w	

	return


NO_ACK		; si Nack de rtc alors stop i2c
	call	tempo_5us	
	bsf	LedR		; Led rouge allume	
	call	I2C_STOP	; si nack  alors  fin transmition i2c	
	sleep			; et sleep du uc



SDA_IN		; mettre SDA ( RA1 ) en entree

	bsf	STATUS,RP0	; aller en bank1
	movlw	b'00000010'
	movwf	TRISA		; port A en sortie
	bcf	STATUS,RP0	; aller en bank0
	return


SDA_OUT		; mettre SDA ( RA1 ) en sortie

	bsf	STATUS,RP0	; aller en bank1
	movlw	b'00000000'
	movwf	TRISA		; port A en sortie
	bcf	STATUS,RP0	; aller en bank0
	return


tempo_5us	; tempo de 5 us pour l' i2c
	nop
	return




tempo500ms		; temporisation de 500 ms
 	call 	 wait0
	call 	 wait0	  
	call 	 wait0
 	call 	 wait0
 	return

wait0                    ; Boucles ralisant une tempo lmentaire
 	movlw  	.200      ; Charge count1 avec valeur dcimale 200
	movwf  	count1
d1 	movlw   .200      ; Charge count2 avec valeur dcimale 200
   	movwf   count2 	
d2 	decfsz  count2,1  ; dcremente et saute ligne suiv. si zero
   	goto    d2        ; si diffrent de zero           
  	decfsz 	count1,1  ; dcremente count1 si count2 == zero
	goto    d1        ; boucle interne si count2 <> zero
	return




	END 			;  fin de programme



