;	routines de gestion RS232C pour Pic 16F84
;	(C)2001 Offset : HTTP://WWW.multimania.com/offset
;
;	commandes :
;
;	RSinit  : initialisation du port srie
;	RSsend  : envoi un caractere ( contenu dans w ) sur le port srie
;	RSrec   : attend et recois un caractre du port srie ( caractre reu dans RS_buff )
;
;	variables a definir dans le programme principal:
;
;	RS_buff			; RS232 : buffer ( 1 octet ) pour l'envoi ou la reception
;	RS_count		; RS232 : Nbr de bits de donnes de la liaison srie
;	RS_tmp			; RS232 : variable temporaire pour boucle de tempo
;
;	constantes a definir dans le programme principal:
;
;	RS_port	equ	PORTA				; RS232 : port A ou B
;	RS_tx	equ	1				; RS232 : Tx
;	RS_rx	equ	0				; RS232 : RX
;	RS_qtz	equ	.4000000			; Vitesse du quartz ( ici 4 MHz )
;	RS_delay	equ (((RS_qtz/4)/.9600)/3-2)	; 9600 est la vitesse dsire ( ou 4800 )
;
;	NOTA :	la reception d'un octet depuis le port srie se fait avec une boucle.
;		Dans ces conditions , le pic est bloqu sur l'attente de la reception d'un octet.
;		Si vous utilisez une interruption , vous pouvez appeler RSreci au lieu de RSrec pour
;		recevoir les donnes ( NDLA : je n'ai pas test cette methode )
;

RSinit	bsf	RS_port,RS_tx	; initialisation de Tx ( ligne  1 au repos )
	return

RSsend	movwf	RS_buff		; rs_octet = octet  envoyer
	movlw	8		; 8 bits
	movwf	RS_count	; compteur de bits envoys
	bcf	RS_port,RS_tx	; bit de start
	call	RSdelai		; tempo
	rrf	RS_buff,f	; on recupere dans C le bit  envoyer
	btfsc	STATUS,C	; bit  envoyer = 1 ?
	goto	$+3		; oui
	bcf	RS_port,RS_tx	; sinon 0
	goto	$+2		; on continue sur la tempo
	bsf	RS_port,RS_tx	; bit  1
	call	RSdelai		; tempo
	decfsz	RS_count,f	; on decremente le compteur de bits envoys
	goto	$-8		; on continue sur les bits suivants
	bsf	RS_port,RS_tx	; bit de stop
	call	RSdelai		; tempo pour bit de stop
	call	RSdelai		; tempo de scurit
	return			; les 8 bits sont envoys

RSrec	btfsc	RS_port,RS_rx	; bit de start ?
	goto	$-1		; non , on boucle
RSreci	call	RSdelai		; tempo
	movlw	8		; 8 bits
	movwf	RS_count	; compteur de bits envoys
	clrf	RS_buff		; raz du buffer
	bcf	STATUS,C	; on efface le carry
	btfsc	RS_port,RS_rx	; bit  1 ?
	bsf	STATUS,C	; bit recu = 1
	rrf	RS_buff,f	; on stoque dans le buffer
	call	RSdelai		; tempo
	decfsz	RS_count,f	; on decremente le compteur de bits recus
	goto	$-6		; on continue sur les bits suivants
;	btfss	RS_port,RS_rx	; bit de stop ?
;	goto	$-1		; non , on boucle
	return			; les 8 bits sont recus

RSdelai movlw	RS_delay	; temporisation de la dure d'un bit
	movwf	RS_tmp
	decfsz	RS_tmp,f
	goto	$-1
	return


