//----------------------------------------------------------------------------
// Branche 				:	Travail de Bachelor 2012
// Nom du projet 		:	Capteur Anmomtrique  US
// Nom du fichier 		:   main.c
// Date de cration 	:   08.09.2012
// Date de modification : 	22.10.2012
// 
// Auteur 				: 	Philippe Bovey
// Infos : 
// http://www.microchip.com/wwwproducts/Devices.aspx?dDocName=en546064
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------//
//--- fichiers d'enttes ---//
// pour chemin pour inclure le header file du composant : 
// C:\Program Files\Microchip\MPLAB C30\support\dsPIC33F\h
//----------------------------------------------------------------------------//
#include <stdlib.h>
#include <p33FJ256GP710A.h>
#include "lcd.h"


//----------------------------------------------------------------------------//
//--- Configuration des fusibles ---//
//----------------------------------------------------------------------------//
//--- Choix du type d'oscillateur ---//
_FOSCSEL(FNOSC_PRIPLL); 						// choix oscillateur  quartz 							

//--- Configuration de l'oscillateur ---// 	
// Pas d'acivation au niveau contrle du l'oscilateur 
// Ne pas activer la PIN OSC2 en mode IN/OUT 
// Choix de l'oscillateur XT --> < 20MHz 
_FOSC(FCKSM_CSDCMD & OSCIOFNC_OFF & POSCMD_XT); 

//--- Configuration du Watchdog ---//
_FWDT(FWDTEN_OFF); 


//----------------------------------------------------------------------------//
//--- Consantes ---//
//----------------------------------------------------------------------------//


//----------------------------------------------------------------------------//
//--- fonction : init_oscillateur ---//
//--- entres : -
//--- sorties : - 
//--- description : configuration de l'oscillateur pour une frquence de cycle
//                  (Fcy) de 40MHz  avec une horloge externe de 8MHz   
//----------------------------------------------------------------------------//
void init_oscillateur(void)
{
	//--- configuration de l'oscillateur interne  40Mhz ---//
	// utilisation fomrules du datasheet du DSPic33FJ256GP710A --> page 146
	// Fcy = Fosc / 2 ; Fosc = Fin(M/(N1 N2))
	// Fin = 8Mhz --> Fosc = 80Mhz --> Fcy = 40Mhz 
	OSCCONbits.COSC 	= 0x03;		// slection de l'oscillateur XT 
	OSCCONbits.CLKLOCK	= 0;		// l'horloge et la PLL peuvent tre modifi 	
	
	CLKDIVbits.ROI		= 0; 		// pas d'effet si il y a interruption 
	CLKDIVbits.DOZE		= 0; 		// pas de rduction sur l'horloge Fcy /1
	CLKDIVbits.DOZEN	= 0; 		
	CLKDIVbits.PLLPRE 	= 0x00; 	// N1 = 2	
    CLKDIVbits.PLLPOST 	= 0x00; 	// N2 = 2 	
	
	PLLFBDbits.PLLDIV 	= 0x28;		// M = 40  
}

//----------------------------------------------------------------------------//
//--- fonction : init_IN_OUT() ---//
//--- entres : -
//--- sorties : - 
//--- description : initialisation des entres - sorties  
//----------------------------------------------------------------------------//
void init_IN_OUT(void)
{
	//--- configuration des PINs en entre ---//
	TRISBbits.TRISB4 = 1; 		// PIN RB4/AN4 pour lire le capteur de temprature	

	//--- configuration des PINs en sortie ---//
	TRISAbits.TRISA0 = 0; 		// configuration des leds
	TRISAbits.TRISA1 = 0;
	TRISAbits.TRISA2 = 0;
	TRISAbits.TRISA3 = 0;
	TRISAbits.TRISA4 = 0;
	TRISAbits.TRISA5 = 0;
	TRISAbits.TRISA6 = 0;
	TRISAbits.TRISA7 = 0;
}


//----------------------------------------------------------------------------//
//--- fonction : init_convAD() ---//
//--- entres : -
//--- sorties : - 
//--- description : initialisation des convertisseurs AD  
//----------------------------------------------------------------------------//
void init_convAD(void)
{
	AD1PCFGLbits.PCFG4 = 0; 		// choix de la pin RB4 --> AN4
	
	AD1CON1bits.ADON = 1; 			// activation de l'AD
	AD1CON1bits.FORM = 0; 			// choix de la forme de conversion limite 0  1023
	AD1CON1bits.SSRC = 0b111; 		// slection de l'horloge pour l'chantillonage 		
	
	AD1CON2bits.VCFG = 0; 			// configuration de la tension de rfrence 
									// AVdd - AVss
	AD1CON2bits.CHPS = 0b10; 		// Slection du canal - utilistion des 4 canaux
	AD1CON2bits.BUFM = 0; 			// Remplissage du Buffer 
	AD1CON2bits.ALTS = 0; 			// slection du MUXA
	
	AD1CON3bits.SAMC = 0b01010; 	// permet de dfinir le temps d'chantillonage 
	AD1CON3bits.ADCS = 0x27; 		// choix de l'horloge de conversion 
									// TAD = x * Tcy => TAD = 1us et Tcy = 25ns 
									// x = TAD/Tcy = 40 --> 40 - 1 = 39 --> soit 0x27

	IFS0bits.AD1IF = 0; 			// Reset du drapeau d'interruption 
	IEC0bits.AD1IE = 1; 			// activation des interruption li aux ADC

}

int main(void)
{
	//--- dfinition de variables utiliss dans le programme ---// 
	char msg1[] = "Demo Prog HEIG";			// message 1 
	char msg2[] = "TDP 2012"; 				// message 2 

	int val_adc_port_RB4; 

	//--- Initialisation de l'oscillateur --> fonction : init_oscillateur ---// 
	init_oscillateur(); 

	//--- Initialisation des entres-sorties --> fonction : init_IN_OUT() ---// 
	init_IN_OUT(); 

	//--- test pour allumer les leds au dbut du programme ---//
	LATAbits.LATA0  = 1;
	LATAbits.LATA1  = 1;
	LATAbits.LATA2  = 1; 
	LATAbits.LATA3  = 1;    
	LATAbits.LATA4  = 1;  
	LATAbits.LATA5  = 1;  
	LATAbits.LATA6  = 1; 
	LATAbits.LATA7  = 1;   

	//--- Initialisation de l'oscillateur --> fonction : init_convAD ---// 
	init_convAD(); 

	val_adc_port_RB4 = PORTBbits.RB4; 

	//--- Initialisation de l'affichage --> lcd.h ---// 
	Init_LCD(); 



	//--- message de bienvenu ---//
	home_clr(); 									// efface le display 
	puts_lcd((char*) &msg1[0], sizeof(msg1) - 1);
	line_2(); 
	puts_lcd((char*) &msg2[0], sizeof(msg2) - 1);


}