#include "msp430.h"
#include "msp430g2452.h"
#include "math.h"

void main(void)
{
  WDTCTL = WDTPW + WDTHOLD;   															// Désactivation du chien de garde
  
  ADC10CTL0 = REFON + ADC10SHT_2 + SREF_1 + ADC10ON + ADC10IE; 							// Ref interne du convertisseur + Démarrage du convertisseur analogique-numérique (ADC10ON), interrupt enable (ADC10IE) et Nombre de cycle horloge par conversion = /16
                                    
  ADC10CTL1 = INCH_0;																	// input channel A0 branchée au potentiometre
  ADC10AE0 |= 0x01;  																	//  P1.0 est définie comme entrée analogique
  
  P1DIR |= 0x02+0x04+0x08+0x10;   													 	// P1.1, 1.2, 1.3, 1.4  définis en sorties
  P1SEL |= 0x02+0x04+0x08+0x10;															// Pour utiliser en sorties PWM TA0.0, TA0.1, TA0.2, TA0.3 
  P1IE |= 0x20;																			// Le bit 6 (port P1.5 est vecteur d'interruptions)
  __enable_interrupt();																	// Interruptions autorisées
  
  TA0CCR0 = 1000;	 																		// PWM Period
  TA0CCTL1 = OUTMOD_7; 																		// CCR1 reset/set
  TA0CCR1 = 0; 																				// CCR1 PWM duty cycle initial (0%)  
  TA0CTL = TASSEL_2 + MC_1; 																// Chooses SMCLK, and Up Mode.
  
  TA1CCR0 = 1000;	 																		
  TA1CCTL1 = OUTMOD_7; 																		
  TA1CCR1 = 0; 																			
  TA1CTL = TASSEL_2 + MC_1; 
  
  TA2CCR0 = 1000;	 																		
  TA2CCTL1 = OUTMOD_7; 																		
  TA2CCR1 = 0; 																			
  TA2CTL = TASSEL_2 + MC_1; 
  
  TA3CCR0 = 1000;	 																		
  TA3CCTL1 = OUTMOD_7; 																		
  TA3CCR1 = 0; 																			
  TA3CTL = TASSEL_2 + MC_1; 
  
  for (;;)
  {
  
    ADC10CTL0 |= ENC + ADC10SC;     	 // Début de l'échantillonnage et de la conversion. ENC:  enable conversion. SC:  start conversion
	
    __bis_SR_register(CPUOFF + GIE);    // Low power mode, en attendant le résultat + autorise les interruptions
	
	result = ADC10MEM;					// Conversion du résultat hexa en décimal (avec la fonction du début)
	
	if (ancienresult <> result)			// Changement uniquement si modification de la valeur du potentiomètre
	{
	
	ancienresult = result;
	
	if (result < 256)					// Si valeur du potentiometre strictement inf à 256
		{
		rouge = 1000;
		jaune = round(result*(1000/255));
		vert = 0;
		bleu = 0;
		}
		
	else if ((result > 255) AND (result < 512))
		{
		rouge = round(1000 - (1000/255)*(result - 255));
		jaune = 1000;
		vert = round((result - 255)*(1000/255));
		bleu = 0;
		}
		
	else if ((result > 511) AND (result < 768))
		{
		rouge = 0;
		jaune = round(1000 - (1000/255)*(result - 511));
		vert = 1000;
		bleu = round((valeur - 511)*(1000/255));
		}
		
	else if ((result > 767) AND (result <1023)
		{
		rouge = 0;
		jaune = 0;
		vert = 10*round(100 - (100/255)*(result - 767));
		bleu = 1000;
		}
	
	TA0CCR1 = rouge;
	TA1CCR1 = jaune;
	TA2CCR1 = vert;
	TA3CCR1 = bleu;
	
	}
	
	}
	
	#pragma vector = PORT1_VECTOR
__interrupt void PORT_1(void)
	{
	P1OUT = 0x00;
	P1IES ^= 0x20;
	P1IFG &= 0x20;
	return;
	}
		