#ifndef __I2C_H
#define __I2C_H
#include "p18f4550.h"
#include "types.h"

/* SSPCON1 REGISTER */
#define   SSPENB    0x20  /* Enable serial port and configures SCK, SDO, SDI*/
#define   MASTER    8     /* I2C Master mode                    */

/* SSPSTAT REGISTER */
#define   SLEW_OFF  0xC0  /* Slew rate disabled for 100kHz mode */
#define   SLEW_ON   0x00  /* Slew rate enabled for 400kHz mode  */

//#define COLERROR 
typedef enum E_error_mess{I2C_RESULT_OK, I2C_ACK_ERROR} error_mess;

//*********** Function Prototypes ***************************//
void I2Cm_Init(void);
void I2Cm_Start(void);
void I2Cm_Stop(void);
void I2Cm_Idle(void);
uint8_t I2Cm_DataRdy(void);
void I2Cm_Ack(void);
void I2Cm_NotAck(void);

/*********** Functions needed for emission/reception ******************/
uint8_t I2Cm_WriteByte(uint8_t byte);
int8_t  I2Cm_WriteString (uint8_t *buffer);
uint8_t I2Cm_ReadByte(void);
uint8_t I2Cm_ReadString(uint8_t *buffer, uint8_t length);

/********************************* Transmission Functions ******************************************/
error_mess I2Cm_TransByte8( uint8_t dev_addr, uint8_t data );
error_mess I2Cm_TransByte16( uint8_t dev_addr, uint8_t mem_addr, uint8_t data);

error_mess I2Cm_TransString8(uint8_t dev_addr, uint8_t length, uint8_t* string);
error_mess I2Cm_TransString16(uint8_t dev_addr, uint8_t mem_addr, uint8_t length, uint8_t* string);

/********************************* Receive Functions******************************************/
uint8_t I2Cm_ReceptByte8(uint8_t dev_addr);
uint8_t I2Cm_ReceptByte16(uint8_t dev_addr, uint8_t mem_addr);

error_mess I2Cm_ReceptString8(uint8_t dev_addr, uint8_t *buffer, uint8_t length);
error_mess I2Cm_ReceptString16(uint8_t dev_addr,uint8_t mem_addr, uint8_t *buffer, uint8_t length);
/********************************************************************************************/

void I2Cm_Restart(void);

#endif
