clear all
close all
clc
S=load('UUUUU50.txt');
level=6;
N=1024; %nombre des points
beta=3.5e6;        %amortissement 
f0=3e6; %freq de sortie du transducteur
Fe=10*f0;  %frquence d'chantionnage
Te=1/Fe;  %periode d'chantionnage
t=(0:N-1)'.*Te; %L'intervalle du temps
f=(0:N-1).*Fe/N;  %L'intervalle de frquence

   dywt = FWT_ATrou(S,level);
    

figure,
for m=1:level;
    subplot(level+1,1,m);
    
    plot(dywt(m,:));grid on;ylabel(strcat('j=',num2str(m))),axis tight;
end