
 -----------------------------------------declaration des variables et constantes ----------------------------------------------*/
#include <UpdateLCD>
#include <lecteur>
#include <Wire.h>  
#include <LiquidCrystal_I2C.h>     // I2C LCD library
const int LCD_I2C_ADDR = 0x27;     // LCD (SainSmart 1602)
const int DataL = 0x20;            // IDE DD0-DD7
const int DataH = 0x21;            // IDE DD8-DD15
const int RegSel = 0x22;           // IDE register
const byte BACKLIGHT_PIN = 3;
const byte En_pin = 2;
const byte Rw_pin = 1;
const byte Rs_pin = 0;
const byte D4_pin = 4;
const byte D5_pin = 5;
const byte D6_pin = 6;
const byte D7_pin = 7;

LiquidCrystal_I2C lcd(LCD_I2C_ADDR,En_pin,Rw_pin,Rs_pin,D4_pin,D5_pin,D6_pin,D7_pin);

//__________________________________definitions des entrees et sorties__________________________
const int selec=3;
const int ok=4;
const int led=5;
const byte LED = 13;
const byte NEXT = 12;                   // NEXT button
const byte EJCT = 11;                   // EJECT button, open/close CD-ROM tray
const byte STOP = 10;                   // STOP button
const byte PLAY = 9;                    // PLAY button
const byte PREV = 8;                    // PREV button
//___________________________________definitions des memoires__________________________
// Button States
/////////////////////////////////////////////
int etat_bouton = 0;         
int lastetat_bouton = 0; 
int Menu;

void setup() {
  // set up the LCD's number of columns and rows:
  
  pinMode(selec,INPUT);
  digitalWrite(selec,HIGH);
  pinMode(ok,INPUT);
  digitalWrite(selec,HIGH);
  pinMode(led,OUTPUT);
  digitalWrite(led,HIGH);
  ////////////////////////////////////////lecteur definition////////////////////////////////////////
  // LCD Part
  // ########
  lcd.begin (16,2);                                // init LCD interface
  // Switch on the backlight
  lcd.setBacklightPin(BACKLIGHT_PIN,POSITIVE);
  lcd.setBacklight(HIGH);
  lcd.home ();                                     // set cursor to home position

  // Arduino Part
  // #############

  // start I2C interface as Master
  Wire.begin();

  // Set all pins of all PCF8574 to high impedance inputs.
  highZ();

  // Start Serial Interface
  //  Serial.begin(9600);

  // initialize the push button pins as inputs with pullup:
  pinMode(NEXT, INPUT);
  pinMode(PREV, INPUT);
  pinMode(EJCT, INPUT);
  pinMode(STOP, INPUT);
  pinMode(PLAY, INPUT);
  pinMode(LED, OUTPUT);

  digitalWrite((byte)NEXT, HIGH);
  digitalWrite((byte)PREV, HIGH);  
  digitalWrite((byte)EJCT, HIGH);
  digitalWrite((byte)STOP, HIGH);
  digitalWrite((byte)PLAY, HIGH);
  digitalWrite((byte)LED, LOW);


  ////////////////////////////////////////////////////////////////////////////////////////////////////

  lcd.begin(16, 2);
  // Print a message to the LCD.
  lcd.print("audio/franck");
  delay(1000);
  lcd.clear();

}



void loop()

{
  BSelect();
  
}

void BSelect()
{



  etat_bouton = digitalRead(selec);
  // compare the buttonState to its previous state
  if (etat_bouton != lastetat_bouton)  {
    // if the state has changed, increment the counter

    if (etat_bouton == LOW)

    {     
      Menu++;
      if (Menu > 5)

        Menu = 0;
    } 
    lastetat_bouton = etat_bouton;
    UpdateLCD();


  }
}









