
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <util/delay.h>
#include <avr/interrupt.h>

#define BIT_SET(a,b) ((a) |= (1<<(b)))
#define BIT_CLEAR(a,b) ((a) &= ~(1<<(b)))
#define BIT_FLIP(a,b) ((a) ^= (1<<(b)))
#define BIT_CHECK(a,b) ((a) & (1<<(b)))

//dfinition des segments "abcdefg"
#define ZERO  	0b01111110
#define UN 		0b00110000
#define DEUX 	0b01101101
#define TROIS	0b01111001
#define QUATRE	0b00110011
#define CINQ	0b01011011
#define SIX		0b01011111
#define SEPT	0b01110000
#define HUIT	0b01111111
#define NEUF	0b01111011
#define ERROR 	0b01001111

void init_timer1(void);
void init_timer0(void);

void affiche_digit(uint8_t n,uint8_t digit);
void inc_time(void);
void dec_time(uint8_t n);

volatile uint8_t f_1hz,f_start,min,sec=0;

void main(void)
{
	
	uint8_t x=0;
	DDRB=0xFF;
	DDRD=0xFF;

	init_timer1();
	init_timer0();
	
	sei();
	min=20;
	f_start=1;
	
	while(1)
	{
		if (f_1hz)
		{
			f_1hz=0;
			
			if (f_start)
			{
				
				if((min>0)||(sec>0)) dec_time(1);
				else
				{
					f_start=0;
				}
			}			
		}
		if (f_start) BIT_CLEAR(PORTD,7);
		else BIT_SET(PORTD,7);
	

	}
}




ISR(TIMER1_COMPA_vect)
{
	f_1hz=1;
}
ISR(TIMER0_COMPA_vect)
{
	static uint8_t i=0;
	switch (i)
	{
		case 0: affiche_digit(min/10,0);	break;//dizaine de minute
		case 1: affiche_digit(min%10,1);	break;//unit des minutes
		case 2: affiche_digit(sec/10,2);	break;//dizaine de sec
		case 3: affiche_digit(sec%10,3);	break;//unit des sec
		default: affiche_digit(100,3);
	}
	i++;
	if (i==4) i=0;
}

	


void init_timer1(void)
{
	TCCR1B|=(1<<WGM12)|(1<<CS11)|(1<<CS10); //clock div 64 +mode ctc
	OCR1A=15624;
	TIMSK1|=(1<<OCIE1A);
}
void init_timer0(void)
{
	TCCR0B|=(1<<WGM02)|(1<<CS01); //clock div 8 +mode ctc
	OCR0A=125;
	TIMSK0|=(1<<OCIE0A);
}




void affiche_digit(uint8_t n,uint8_t digit)
{
	PORTD|=0x0F;
	BIT_CLEAR(PORTD,digit);
	switch(n)
	{
		case 0: PORTB=ZERO; 	break;
		case 1: PORTB=UN; 		break;
		case 2: PORTB=DEUX;		break;
		case 3: PORTB=TROIS; 	break;
		case 4: PORTB=QUATRE; 	break;
		case 5: PORTB=CINQ; 	break;
		case 6: PORTB=SIX; 		break;
		case 7: PORTB=SEPT; 	break;
		case 8: PORTB=HUIT; 	break;
		case 9: PORTB=NEUF; 	break;
		default: PORTB=ERROR;
	}
}

void inc_time(void)
{
	sec+=5;
	if (sec==60)
	{
		sec=0;
		min++;
		if (min==100) min=99;
	}
		
}

void dec_time(uint8_t n)
{
	if ((sec>0)||(min>0))
	{
		sec-=n;
		if (sec>245)
		{
			if (min>0)
			{
			sec=60-n;
			min--;
			}
			else sec=0;
		}
		
	}
}

