/*
28/12/2012 changement version :MikroC pro v 5.80
06/11/2012
   pas assez de ram pour buffer de 124 bytes = longueur de trame
  05/11/2012
  Rajout Teleinfo EDF                   Trame du  compteur Siemens
  Mesure temperature Ambiante du garage    LM335
  Etat de chauffe de la chaudiere Gaz     voyant cvert chauffage allum ?
  Envoi de ces infos via bluetooth
  
  CONFIG1   :$8007 : 0x0984
  CONFIG2   :$8008 : 0x3413

25/7/2012
 Rajout mesure de temperature interne   
  voir Temperature Indicator Module  page 125  fig 15.1

23/07/2012
  clock 8  Mhz  en mode interne INTOSC
  Test ADC avec ref 2,048 ..OK
  Lecture msg en EEPROM pour afichage
  
  PB rencontre :
  La Tempo timer 0 suit bien les clock  8Mhz -> 4sec  32 Mhz -> 1sec
  La vitesse UART 1200
   IL FAUT CHANGER la valeur de "Oscillateor Frequency: Mhz" dans la fenetre de config du Projet
  et dans ce cas la vitesse en baud correspond !!!

 * Projet :  12F1840_teleinfo.mcppi
   SW:       mikroC PRO for PIC   V 5.61
   MCU :         PIC12F1840  ehanced type
   Directory :   C:\_MickroC\_MesProjets_MickroC\_12F1840
   Source :      12F1840_Teleinfo_8Mhz_121105.c
   EEPROM :      12F1840_Teleinfo_8Mhz_121105.ihex     ou .eed
   Programmateur tools : PicKit2 V2.61 (choose 1,8V family!)
   config bits:     P18F1840_teleinfo.cfgsch
   CONFIG1   :$8007 : 0x0984
   CONFIG2   :$8008 : 0x3413
   config vu par Pickit2 :  0984 3413 <- OK
   nota : pas besoin de faire un export pour que l' Hex soit  jour !
          ce qui n'est pas le cas sous MPLAB !
   VDD    : 5,0V    ( from 2,3 to 5,5V)
   horloge  :  interne  8 MHz ... pas de quartz
   Librairies utilisees :
   - built_in.h
   - UART
   - C_String
   - Conversions
   - ADC
   
   pinout :     ac:Pinout_12f1840
   device ID =  01 1011 100
   Calibrations words 8009h & 800Ah
   hex file au format : INHX32   LSB puis MSB
   docu :
    ac:Schema_de_principe
   
   Trame typique  :
   ADCO 049801282083 D
   OPTARIF BASE 0
   ISOUSC 30 9
   BASE 039229704 /
   PTEC TH.. $
   IINST 003 Z
   IMAX 023 D
   MOTDETAT 000000 B
   
 */

 // last update  06/11/2012
  /* Hardware
  12F1840
  pin 1     VDD Alim +5V    ATTENTION !!!!!!!!!!!!!!
  pin 2     RA5  input  <--  detection chauffage chaudiere
  pin 3     RA4  output1 >-- R1K-- Led Blanche  -- +5V
  pin 4     RA3/MCLR/VPP -- ICSP Reset
  pin 5     RA2  Analog input  <--  capteur LM335
  pin 6     RA1  ICSP Clock  &  input TX -------  TX bluetooth
  pin 7     RAO  ICSPDAT  &     output RX --   -- RX bluetooth
  pin 8     VSS alim 0V
  */

#include "built_in.h"     // for  Hi  Lo ..etc

// ATTENTION  modifier aussi Oscillator Clock dans l'editeur de Projet !!!
// #define AVECPLL   //8 Mhz  sans PLL
//#define ref2048   // ADC 1023 points pour 2,048V .. test OK   !
  
#define TAB 9
#define CLS 12
#define CR 13
#define LF 10
#define STX 2
#define ETX 3

#define Etat_Chaudiere PORTA.F5      // RA5
//#define Led_Rouge LATA.F5          // RA5
#define Led_Blanche LATA.F4          // RA4


  // responses to parse
const BT_CMD  = 1;
const BT_AOK  = 2;
const BT_CONN = 3;
const BT_END  = 4;


const code char mesg0[]="Mikroc pro 5.80 28/12/2012\n\r";

const code char mesg1[]="...";
const code char * Messages[]={mesg0,mesg1};

 // timer0
unsigned char  NbCycles_T0 = 0;     //     255-0=255  prescaler=1/256 => 16.384 mS
 // timer1
unsigned long  NbCycles_T1= 3035 ; //65535-62500=3035 @16Mhz et prescaler=8 => 125mS


 
unsigned short error;
volatile unsigned int CptErr;
volatile unsigned int  CptFE,CptOV;
volatile unsigned int Count1;
volatile  volatile unsigned int Count0;
volatile int Flag_Timer1;
volatile int Flag_Timer0;
volatile int Flag_Buffer;
volatile int Index;
volatile  unsigned char c1;
volatile int j;
unsigned int i,k;
unsigned long clk;
unsigned M;
long ADCO;
char buffer[60];        // besoin de 165 car !
char *txt;
char Texte[40];

char BT_state;
char response_rcvd;
char responseID, response = 0;


void strConstRamCpy(char *dest, const char *source);
void Write_String(char * texte);
void CRLF(void);
void Tempo(unsigned long L);
void interrupt(void) ;
void Init_Timer0(void);
//void Init_Timer1(void);
unsigned int TraiteBuffer(void);
void Msg_Eeprom(int depuis);
void Temperature_Module(void);
char BT_Get_Response(void) ;
void  BT_Configure(void);



void interrupt(void)  org 0x04
{
 if (PIR1.RCIF==1)
  {
   // traitement separe des erreurs de COM
   if (RCSTA.OERR==1)    // voir parag 16.1.26 p273
   {
      c1=RCREG;           // efface drapeau OVERRUN
       RCSTA.CREN = 0 ;
       RCSTA.CREN = 1 ;
       CptOV++;
       }
    if(RCSTA.FERR==1 )
    {
     RCSTA.SPEN = 0 ;
     CptFE++;
     RCSTA.SPEN= 1 ;
     }
    c1 = RCREG;
    if (c1==STX)
     {
      Index=0;
      Flag_Buffer=1 ;
      c1=0;
     }
     if (c1==ETX)
     {
     Flag_Buffer=2;
     PIE1.RCIE=0 ; //interdit IT Reception UART
     c1=0;
     }
     else
     {
        buffer[Index]=c1;
        Index++;
      }
   PIR1.RCIF=0   ;
  }
  #ifdef Led_Rouge
   // ---- timer 0  --
  if( INTCON.TMR0IF==1)
  {
        TMR0=NbCycles_T0;
        Count0++;
       if (Count0 >32)   // 1 secondes @8MHz
       {
        Led_Rouge=!Led_Rouge; // blink RA4
          Count0=0;
          TMR0=NbCycles_T0;
          Flag_Timer0=1;
        }
      INTCON.TMR0IF=0;
   }
   #endif
 }




 void  BT_Configure() {

  do {
    UART1_Write_Text("$$$");                  // Enter command mode
    //UART1_Write(13);
    Delay_ms(1000);
  } while (BT_Get_Response() != BT_CMD);

  do {
    UART1_Write_Text("SN,BlueTooth-Click");   // Name of device
    UART1_Write(13);                          // CR
     Delay_ms(1000);
  } while (BT_Get_Response() != BT_AOK);

  do {
    UART1_Write_Text("SO,Slave");             // Extended status string
    UART1_Write(13);                          // CR
     Delay_ms(1000);
  } while (BT_Get_Response() != BT_AOK);

  do {
    UART1_Write_Text("SM,0");                 // was 0 Set mode (0 = slave, 1 = master, 2 = trigger, 3 = auto, 4 = DTR, 5 = ANY)
    UART1_Write(13);                          // CR
     Delay_ms(1000);
 } while (BT_Get_Response() != BT_AOK);

 do {
    UART1_Write_Text("SA,1");                 // Authentication (1 to enable, 0 to disable)
    UART1_Write(13);                          // CR
     Delay_ms(1000);
  } while (BT_Get_Response() != BT_AOK);
   do {
    UART1_Write_Text("SU,19.2");              //  UART speed 38400 bauds
    UART1_Write(13);                          // CR
    Delay_ms(1000);
  } while (BT_Get_Response() != BT_AOK);

 do {
    UART1_Write_Text("SP,1234");              // Security pin code (mikroe)
    UART1_Write(13);                          // CR
     Delay_ms(1000);
  } while (BT_Get_Response() != BT_AOK);

  do {
    UART1_Write_Text("---");                  // Security pin code (mikroe)
    UART1_Write(13);                          // CR
     Delay_ms(1000);
  } while (BT_Get_Response() != BT_END);
}

 // Get BlueTooth response, if there is any
char BT_Get_Response() {
  if (response_rcvd) {
    response_rcvd = 0;
    return responseID;
  }
  else
    return 0;
}

void Write_String(char * texte)
{
while (* texte)
 {
  UART_Write(* texte++);
 }
}

// --- Copie le texte depuis ROM vers RAM
void strConstRamCpy(char *dest, const char *source) {
  while(*source) *dest++ = *source++ ;
  *dest = 0 ;    // terminateur
}

void CRLF()
{
 UART1_Write(CR);
 UART1_Write(LF);
}

 void Tempo(unsigned long L)
 {
 while (L>0) L--;
 }

void Msg_Eeprom(int debut)
{   int i1 ,i;
  i1=debut;
  do
  {
  i = EEPROM_Read(i1);
  if ( i==0) break;
  UART1_Write(i);
  Tempo(100);
  i1++;
   }
  while (i!=0)  ;
 }

#ifdef Led_Rouge
 void Init_Timer0(void)    // 1 seconde
 {
 
 OPTION_REG.PS2=1;   // prescaler 1/256
 OPTION_REG.PS1=1;
 OPTION_REG.PS0=1;
 OPTION_REG.PSA=0; // prescaler sur Timer0
 OPTION_REG.TMR0CS=0; // source FOSC/4
 INTCON.TMR0IF=0;
 INTCON.TMR0IE=0;    // disable interrupt Timer0
 TMR0= NbCycles_T0 ; //  255-0=255  prescaler=1/256 => 16.384 mS
 CPSCON0=0;
 }
#endif

void Separateur(void)
{
         UART_Write(32);  UART_Write(';');    UART_Write(32);
}

unsigned int TraiteBuffer(void)
{
unsigned int Nbc,res,i;
    RCSTA.CREN=0;
//  Wait to flag buffer ended by car=ETX
    Nbc=0;
    // valeur de I instantanee
   // if (Index >125)
  //  {
  //  for (i=50;i<Index;i++)
      for (i=0;i<Index;i++)
      {
       // totalisateur conso en Wh
       if((buffer[i]=='B') && (buffer[i+1]=='A') && (buffer[i+3]=='E'))
       {
        buffer[i+15]=0;
        UART1_Write_Text(buffer+i);
        i=i+15;
        }
        if((buffer[i]=='I') && (buffer[i+1]=='I') && (buffer[i+4]=='T'))
        {
         Separateur() ;
         buffer[i+9]=0;
         UART1_Write_Text(buffer+i);
         }
       } // for i
   //  }
   //  else
   //  {
   //   Msg_Eeprom(0x0080);
   //  }
     Flag_Buffer=0;
     c1=0;
     Nbc=Index;
     CptOV=0;
     CptFE=0;
     CptErr=0;
     Index=0;
   return Nbc;
   }


void Temperature_Module()
{
// voir  datasheet DS41441B-page 125  fig 15.1

}

void main()
{

                         // voir page 61
  // 0=4xPLL OFF, 1111=IOFS=16Mhz  0=0  00=SCS=config via Conf1 word FOSC<2:0>
  // 0=4xPLL OFF, 1110=IOFS=8Mhz  0=0  00=SCS=config via Conf1 word FOSC<2:0>
  OSCCON=0b01110000;    // choix 8Mhz
  ANSELA=0;             // no analog
  ANSELA.ANSA2=1;       // RA2= Analog input
  WPUA=0b00000011;      // weak pull up on RX & TX
  CM1CON0=0;       // disable comparators
  CM1CON1=0;
  CCP1CON=0;       // indispensable pour UART sur RA0


  APFCON=0;
  APFCON.P1BSEL=1;    // pour deconnecter de RA0 mais connecte sur RA4 ???!!
  APFCON.RXDTSEL=0;   // RX sur RA1
  APFCON.TXCKSEL=0;   // TX sur RA0


  FVRCON.FVREN=1;       // fixed voltage reference     (voir page 124)
  FVRCON.TSEN=0;        // temperature enable=0;
  FVRCON.TSRNG=1;       // temperature range high   car VDD>3,6V
  FVRCON.CDAFVR1=0;     // Comparator & DAC OFF
  FVRCON.CDAFVR0=0;
  FVRCON.ADFVR1=1;     // ref=4.096V
  FVRCON.ADFVR0=1;
  

  RCSTA=0;
  RCSTA.CREN=1;  //enable receiver
  RCSTA.SPEN=1;  // serial port Pins Enable
  RCSTA.SREN=1;  // single bit receive
  c1 = RCREG;   // RAZ errors

   INTCON=0;
   PIR1=0;
   PIR2=0;
   INTCON.PEIE=0;  // disable IT des peripherique voir fig  8.1 p 77
   INTCON.GIE=0;

   txt=&Texte[0];
   UART1_Init(19200);
   Tempo(10000);
 
     // vide tampon fifo
   while (UART1_Data_Ready()==1)   c1=RCREG;
   Tempo(100000);


   UART1_Write(CLS);
   Tempo(200000);       // Wait for cleaning


     // RA0 as  as output for TX , RA1  as input for RX
  // RA4 et RA5 en sorties  pour leds
   TRISA=0b0000110;
   Led_Blanche=1;

   // BT_Configure();

   Flag_Buffer=0;
   Index=0;

  txt=&Texte[0];
  strConstRamCpy(txt, mesg0);
   UART1_Write_Text(txt);
   Tempo(100000);
   
   
   Msg_Eeprom(0x0000);
   txt=&Texte[0];
    Tempo(50000);
   
   Msg_Eeprom(0x00E0);
   txt=&Texte[0];
    Tempo(50000);
    
    
   Count0=0;
   Flag_Timer0=0;
   
 #ifdef Led_Rouge
     Init_Timer0();   // but not started!
   TMR0=0;          // timer0 8 bits => 0  255  sur 8 bits !
   #endif

   CRLF();
   Count0=0;
   CptErr=0;
    CptOV=0;
   CptFE=0;
   c1=0;
    //


  CRLF();
   
   Msg_Eeprom(0x0020);
   j=Clock_MHz();    
   WordToStr(j,txt);   UART_Write_Text(txt);   CRLF();
   

   ADC_Init();
   ADCON1.ADPREF1= 1;  // Vref sur FVR 4.096V
   ADCON1.ADPREF0= 1;
   Msg_Eeprom(0x0040);  CRLF();

  
     #ifdef Led_Rouge
      Msg_Eeprom(0x0030);
     // arme Timer0 et Reception UART
    INTCON.TMR0IE=1; // enable IT par Timer0
    INTCON.TMR0IF=0;
    #endif



  j=0;
  k=0;
  CptOV=0;
  CptFE=0;
  CptErr=0;
  Flag_Buffer=0;
  Flag_Timer0=0;


 /*forcage de la vitesse  1200bds    si Quartz config different
  SPBRG=103;
  TXSTA.BRGH=0;
  BAUDCON.BRG16=0;
 */
 
  PIE1.RCIE=1;
  INTCON.PEIE=1;  // autorise IT des peripherique voir fig  8.1 p 77
  INTCON.GIE=1;   // Enable all interrupts (timer1 & UART)
  
  j=0;
  while(1)
  {
  Flag_Buffer=0;
  RCSTA.CREN=1;  //enable receiver
  Index=0;
  PIE1.RCIE=1 ; // autorise IT Reception UART
  while (Flag_Buffer!=1); // attente debut de trame STX
  Flag_Buffer=0;
  while (Flag_Buffer!=2); // attente fin de trame ETX
  Flag_Buffer=0;
  RCSTA.CREN=0;
  // recupere Base Wh et IINST Intensite
  j= TraiteBuffer() ;       // j=46  pour ce test    extrait valeur de I Instantane
  Separateur() ;
 
  //WordToStr(j,txt);
  //UART1_Write_Text(txt);
  //CRLF();
   

  M=ADC_Get_Sample(2);  // lecture sur RA2
  Msg_Eeprom(0x0050); 
  UART1_Write(32);
  WordToStr(M, txt) ;
  UART1_Write_Text(txt);
  CRLF();
  } // while (1)
 }
 /*
Mikroc pro 5.80 28/12/2012
Teleinfo EDF 1200,7,N,1
12F1840  + BlueTooth-Click


Clock int 8MHz    8
ref ADC 4,096V
BASE 039229704  ; IINST 000 ; Temp_Garage :   1023
BASE 039229704  ; IINST 001 ; Temp_Garage :   1023
BASE 039229704  ; IINST 002 ; Temp_Garage :   1023
BASE 039229704  ; IINST 003 ; Temp_Garage :   1023
BASE 039229704  ; IINST 004 ; Temp_Garage :   1023
BASE 039229704  ; IINST 005 ; Temp_Garage :   1023
BASE 039229704  ; IINST 006 ; Temp_Garage :   1023
BASE 039229704  ; IINST 007 ; Temp_Garage :   1023
BASE 039229704  ; IINST 008 ; Temp_Garage :   1023
BASE 039229704  ; IINST 009 ; Temp_Garage :   1023
BASE 039229704  ; IINST 000 ; Temp_Garage :   1023
BASE 039229704  ; IINST 001 ; Temp_Garage :    911
BASE 039229704  ; IINST 002 ; Temp_Garage :    904
BASE 039229704  ; IINST 003 ; Temp_Garage :    867
BASE 039229704  ; IINST 004 ; Temp_Garage :    769
BASE 039229704  ; IINST 005 ; Temp_Garage :    771
BASE 039229704  ; IINST 006 ; Temp_Garage :    771
 */

/*    Trame reelle:
ADCO 049801282083 D
OPTARIF BASE 0
ISOUSC 30 9
BASE 039229704 /
PTEC TH.. $
IINST 001X
IMAX 023 D
MOTDETAT 000000 B

*/
/*     
// script TErminal Vbray
program teleinfo;
// voir Telefinfo_log_trame_hexadecimal.jpg
// space et checksum deja inclus dans la chaine ascii
var datum: string;
var i: integer;
var k: integer;
var str: string;
var checksum : char ;
//
begin
 datum:='121112';
  writeln('Teleinfo : envoi trame typique');
  writeln('Date: ' + datum);
  writeln('*');
  ComSendChr(13);
begin
  i:=0;
  while (i<10) do
   begin
        // checksum pour 000 => 87
     checksum :=chr(i+87);
     str:= 'IINST 00' + chr(i+48) + chr(32) + checksum;
        ComSendChr(2);        //STX
        ComSendChr(10); // LF
      // ComSendChr(10);ComSendStr('DCO XXXXXX088671 K');ComSendChr(13);
      //  ComSendChr(10);ComSendStr('OPTARIF BASE 0');ComSendChr(13);
        //ComSendChr(10);ComSendStr('ISOUSC 30 9');ComSendChr(13);
        //ComSendChr(10);ComSendStr('BASE 039229704 /');ComSendChr(13);
        //ComSendChr(10);ComSendStr('PTEC TH.. $');ComSendChr(13);
        //ComSendStr('IINST 003 Z');ComSendChr(13);
        ComSendChr(10);ComSendStr(str);ComSendChr(13);
        ComSendChr(10);ComSendStr('IMAX 023 D');ComSendChr(13);
        ComSendChr(10);ComSendStr('MOTDETAT 000000 B');ComSendChr(13);
      ComSendChr(3);
     i:= i+1;
     if (i>9) then i:=0;
  Delay(995);
  end;
end.

*/