#include "i2c.h"

void initI2C(I2C_MODULE id){
    UINT32 actualClock;
    // Set the I2C baudrate
    actualClock = I2CSetFrequency(id, GetPeripheralClock(), I2C_CLOCK_FREQ);
    if ( abs(actualClock-I2C_CLOCK_FREQ) > I2C_CLOCK_FREQ/10 )
        writeString(UART1,"error : init i2c\r\n");
    else
        writeString(UART1,"init i2c\r\n");
    // Enable the I2C bus
    I2CEnable(id, TRUE);
}

BOOL startTransferI2C(I2C_MODULE id, BOOL restart){
    I2C_STATUS status;
    // Send the Start (or Restart) signal
    if(restart)
        I2CRepeatStart(id);
    else{
        // Wait for the bus to be idle, then start the transfer
        while( !I2CBusIsIdle(id) )writeString(UART1,"here\r\n");

        if(I2CStart(id) != I2C_SUCCESS){
            writeString(UART1,"Error: Bus collision during transfer Start\r\n");
            return FALSE;
        }
    }
    // Wait for the signal to complete
    do{
        status = I2CGetStatus(id);
    }while ( !(status & I2C_START) );

    return TRUE;
}

void stopTransferI2C(I2C_MODULE id){
    I2C_STATUS  status;
    // Send the Stop signal
    I2CStop(id);
    // Wait for the signal to complete
    do{
        status = I2CGetStatus(id);
    } while ( !(status & I2C_STOP) );
}

BOOL transmitOneByteI2C(I2C_MODULE id, UINT8 data){
    // Wait for the transmitter to be ready
    while(!I2CTransmitterIsReady(id));

    // Transmit the byte
    if(I2CSendByte(id, data) == I2C_MASTER_BUS_COLLISION){
        writeString(UART1,"Error: I2C Master Bus Collision\n");
        return FALSE;
    }
    // Wait for the transmission to finish
    while(!I2CTransmissionHasCompleted(id));

    return TRUE;
}

BOOL startTransmitSlaveAddressWRI2C(I2C_MODULE id, UINT8 slaveAddress7bit, BOOL I2C_WR){
    BOOL success = TRUE;
    I2C_7_BIT_ADDRESS slaveAddress;

    I2C_FORMAT_7_BIT_ADDRESS(slaveAddress, slaveAddress7bit, I2C_WR);
    //start and send the internal address
    if (!startTransferI2C(id,FALSE))
        while(1);
    // transmit byte : slaveAddress
    if (transmitOneByteI2C(id,slaveAddress.byte)){
        // verify that the byte was acknowledged
        if (!I2CByteWasAcknowledged(id)){
            writeString(UART1,"Error: Sent byte was not acknowledged\r\n");
            success = FALSE;
        }
    } else
        success = FALSE;
        return success;
}

BOOL transmitDataToWriteI2C(I2C_MODULE id, UINT8 i2cData){
    BOOL success = TRUE;
    //transmit a byte
    if (transmitOneByteI2C(id,i2cData)){
        // verify that the byte was acknowledged
        if (!I2CByteWasAcknowledged(id)){
            writeString(UART1,"Error: Sent byte was not acknowledged\r\n");
            success = FALSE;
        }
    } else
        success = FALSE;   
    return success;
}

BOOL readDataByteI2C(I2C_MODULE id, UINT8 *i2cByte, BOOL ack){
    BOOL success = TRUE;

    if (I2CReceiverEnable(id, TRUE) == I2C_RECEIVER_OVERFLOW){
        writeString(UART1,"Error : I2C Receive Overflow\r\n");
        success = FALSE;
    } else {
        while(!I2CReceivedDataIsAvailable(id));
        I2CAcknowledgeByte(id, ack);
        *i2cByte = I2CGetByte(id);
        while( !I2CAcknowledgeHasCompleted(id));
    }

    return success;
}
