/* 
 * File:   i2c.h
 * Author: pierre
 *
 * Created on 17 janvier 2014, 16:21
 */

#ifndef I2C_H
#define	I2C_H

#include <plib.h>
#include "system.h"

#define I2C_CLOCK_FREQ             400000

void initI2C(I2C_MODULE id);
BOOL startTransferI2C(I2C_MODULE id, BOOL restart);
void stopTransferI2C(I2C_MODULE id);
BOOL transmitOneByteI2C(I2C_MODULE id, UINT8 data);

/*
 * Function which begin communication whith slave module I2C
 * id : I2C1 (it's the principal I2C used)
 * slaveAddress7bit : address only on 7 bits of the slave module
 * I2C_WR : I2C_WRITE or I2C_READ -> configure the communication in read or write mode
 */
BOOL startTransmitSlaveAddressWRI2C(I2C_MODULE id, UINT8 slaveAddress7bit, BOOL I2C_WR);

/*
 * Function which write data on I2C
 * id : I2C1 (it's the principal I2C used)
 * i2cData : byte to write on I2C
 */
BOOL transmitDataToWriteI2C(I2C_MODULE id, UINT8 i2cData);

/*
 * Function which read data on I2C
 * id : I2C1 (it's the principal I2C used)
 * *i2cByte : point on the variable that we registre the value read
 * ack : TRUE (validate the reception) or FALSE (must be enter for the last value read)
 */
BOOL readDataByteI2C(I2C_MODULE id, UINT8 *i2cByte, BOOL ack);

#endif	/* I2C_H */

