#include "modRTC.h"

unsigned char char_to_bcd(unsigned char a){
	return ((a/10)<<4) | (a%10);
}

/****************************************************************************
 * Gestion RTCC                                                             *
 ****************************************************************************/
BOOL setTimeDate(unsigned int sec, unsigned int mint, unsigned int hr , unsigned int day, unsigned int wd , unsigned int month, unsigned int year ){
    BOOL success = TRUE;
    int index = 0;

    if(sec>59) sec = 0;
    if(mint>59) mint = 0;
    if(hr>23 ) hr = 0;
    if(wd>6)   wd = 0;
    if(month>12 || month == 0) month = 1;
    if(year>99) year = 0;

    UINT8 i2cData[8] = {0x02,char_to_bcd(sec),char_to_bcd(mint),char_to_bcd(hr),char_to_bcd(day),char_to_bcd(wd),char_to_bcd(month),char_to_bcd(year)};
    int dataSz = 8;
    success = startTransmitSlaveAddressWRI2C(I2C1, ADDRESS_MOD_RTC, I2C_WRITE);
    while (success & index<dataSz){
        success = transmitDataToWriteI2C(I2C1, i2cData[index]);
        index++;
    }
    stopTransferI2C(I2C1);

    return success;
}

BOOL getTimeDate( unsigned char *sec, unsigned char *mint, unsigned char *hr , unsigned char *day, unsigned char *wd , unsigned char *month, unsigned char *year ){
    BOOL success = TRUE;

    //start and send the internal address
    success = startTransmitSlaveAddressWRI2C(I2C1, ADDRESS_MOD_RTC, I2C_WRITE);
    if (success){
        success = transmitDataToWriteI2C(I2C1, 0x02);
        stopTransferI2C(I2C1);
    }
    if (success)
        success = startTransmitSlaveAddressWRI2C(I2C1, ADDRESS_MOD_RTC, I2C_READ);
    // Read the data from the desired address
    if (success)
        success = readDataByteI2C(I2C1, sec, TRUE);
    if (success)
        success = readDataByteI2C(I2C1, mint, TRUE);
    if (success)
        success = readDataByteI2C(I2C1, hr, TRUE);
    if (success)
        success = readDataByteI2C(I2C1, day, TRUE);
    if (success)
        success = readDataByteI2C(I2C1, wd, TRUE);
    if (success)
        success = readDataByteI2C(I2C1, month, TRUE);
    if (success)
        success = readDataByteI2C(I2C1, year, FALSE);

    // End the transfer (stop here if an error occured)
    stopTransferI2C(I2C1);

    // Converting raw BCD data to decimal values
    *sec   =  ((  (*sec)&0x70)>>4)*10    +   ((*sec)&UNIT);
    *mint  =  (( (*mint)&0x70)>>4)*10    +  ((*mint)&UNIT);
    *hr    =  ((   (*hr)&0x30)>>4)*10    +   ( (*hr)&UNIT);
    *day   =  ((  (*day)&0x30)>>4)*10    +   ((*day)&UNIT);
    *wd    =       (*wd)&0x07;
    *month =  (((*month)&0x10)>>4)*10    + ((*month)&UNIT);
    *year  =  (( (*year)&0xF0)>>4)*10    +  ((*year)&UNIT);

    return success;
}
