#ifndef PRAGMACONFIG_H
#define	PRAGMACONFIG_H

/*
 *
 * This work is licensed under the Creative Commons Paternité - Partage à l'Identique 3.0 non transposé License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/ or
 * send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 *
 * Auteur : Dominique JUNK : http://www.abcpic.fr/
 * Rev 1.0 le 01/02/2012
 *
 * 				##### Configuration des fusibles du PIC 32MX440F256H #####
 *
 */

/**********************************************************
 * MUL_15:15x Multiplier
 * MUL_16:16x Multiplier
 * MUL_17:17x Multiplier
 * MUL_18:18x Multiplier
 * MUL_19:19x Multiplier
 * MUL_20:20x Multiplier
 * MUL_21:21x Multiplier
 * MUL_24:24x Multiplier
 */
#pragma config FPLLMUL  = MUL_20        // PLL Multiplier

/**********************************************************
 * DIV_1:1x Divider
 * DIV_2:2x Divider
 * DIV_3:3x Divider
 * DIV_4:4x Divider
 * DIV_5:5x Divider
 * DIV_6:6x Divider
 * DIV_10:10x Divider
 * DIV_12:12x Divider
 */
#pragma config FPLLIDIV = DIV_2         // PLL Input Divider

/**********************************************************
 * DIV_1:1x Divider
 * DIV_2:2x Divider
 * DIV_3:3x Divider
 * DIV_4:4x Divider
 * DIV_5:5x Divider
 * DIV_6:6x Divider
 * DIV_10:10x Divider
 * DIV_12:12x Divider
 */
#pragma config UPLLIDIV = DIV_2         // USB PLL Input Divider

/**********************************************************
 * ON:Enabled
 * OFF:Disabled and Bypassed
*/
#pragma config UPLLEN = ON         // USB PLL Enable

/**********************************************************
 * DIV_1:PLL Divide by 1
 * DIV_2:PLL Divide by 2
 * DIV_4:PLL Divide by 4
 * DIV_8:PLL Divide by 8
 * DIV_16:PLL Divide by 16
 * DIV_32:PLL Divide by 32
 * DIV_64:PLL Divide by 64
 * DIV_256:PLL Divide by 256
 */
#pragma config FPLLODIV = DIV_1         // PLL Output Divider

/**********************************************************
 * DIV_1:Pb_Clk is Sys_Clk/1
 * DIV_2:Pb_Clk is Sys_Clk/2
 * DIV_4:Pb_Clk is Sys_Clk/4
 * DIV_8:Pb_Clk is Sys_Clk/8
 */
#pragma config FPBDIV   = DIV_1         // Peripheral Clock divisor

/**********************************************************
 * OFF:WDT Disabled (SWDTEN Bit Controls)
 * ON:WDT Enabled
 *
 */
#pragma config FWDTEN   = OFF            // Watchdog Timer

/**********************************************************
 * PS1:1:1
 * PS2:1:2
 * PS4:1:4
 * PS8:1:8
 * PS16:1:16
 * PS32:1:32
 * PS64:1:64
 * PS128:1:128
 * PS256:1:256
 * PS512:1:512
 * PS1024:1:1024
 * PS2048:1:2048
 * PS4096:1:4096
 * PS8192:1:8192
 * PS16384:1:16384
 * PS32768:1:32768
 * PS65536:1:65536
 * PS131072:1:131072
 * PS262144:1:262144
 * PS524288:1:524288
 * PS1048576:1:1048576
 */
#pragma config WDTPS    = PS32768        // Watchdog Timer Postscale (32,768 sec.)

/**********************************************************
 * CSECME:Clock Switch Enable, FSCM Enabled
 * CSECMD:Clock Switch Enable, FSCM Disabled
 * CSDCMD:Clock Switch Disable, FSCM Disabled
 */
#pragma config FCKSM    = CSECME        // Clock Switching & Fail Safe Clock Monitor

/**********************************************************
 * OFF:Disabled
 * ON:Enabled
 */
#pragma config OSCIOFNC = OFF           // CLKO Output Signal Active on the OSCO Pin

/**********************************************************
 * EC:External clock mode
 * XT:XT osc mode
 * HS:HS osc mode
 * OFF:Primary osc disabled
 */
#pragma config POSCMOD  = HS            // Primary Oscillator

/**********************************************************
 * OFF:Disabled
 * ON:Enabled
 */
// ATTENTION à laisser à ON, permet d'éviter un reset au retour d'un sleep
// permet au core de démarrer sur l'horloge interne en attendant la
// stabilisation de l'horloge quartz principale
#pragma config IESO     = ON            // Internal/External Switch-over

/**********************************************************
 * OFF:Disabled
 * ON:Enabled
 */
#pragma config FSOSCEN  = ON            // Secondary Oscillator Enable (KLO was off)

/**********************************************************
 * FRC:Fast RC Osc (FRC)
 * FRCPLL:Fast RC Osc with PLL
 * Primary Osc (XT,HS,EC)
 * Primary Osc w/PLL (XT+,HS+,EC+PLL)
 * Low Power Secondary Osc (SOSC)
 * Low Power RC Osc (LPRC)
 * Fast RC Osc w/Div-by-16 (FRC/16)
 * Fast RC Osc w/Div-by-N (FRCDIV)
 */
#pragma config FNOSC    = PRIPLL        // Oscillator Selection



/**********************************************************
 * ON:Protection Enabled
 * OFF:Protection Disabled
 */
#pragma config CP       = OFF           // Code Protect

/**********************************************************
 * ON:Protection Enabled
 * OFF:Protection Disabled
 */
#pragma config BWP      = OFF           // Boot Flash Write Protect

/**********************************************************
 * PWP512K:First 512K
 * PWP508K:First 508K
 * PWP504K:First 504K
 * PWP500K:First 500K
 * PWP496K:First 496K
 * PWP492K:First 492K
 * PWP488K:First 488K
 * PWP484K:First 484K
 * PWP480K:First 480K
 * PWP476K:First 476K
 * PWP472K:First 472K
 * PWP468K:First 468K
 * PWP464K:First 464K
 * PWP460K:First 460K
 * PWP456K:First 456K
 * PWP452K:First 452K
 * PWP448K:First 448K
 * PWP444K:First 444K
 * PWP440K:First 440K
 * PWP436K:First 436K
 * PWP432K:First 432K
 * PWP428K:First 428K
 * PWP424K:First 424K
 * PWP420K:First 420K
 * PWP416K:First 416K
 * PWP412K:First 412K
 * PWP408K:First 408K
 * PWP404K:First 404K
 * PWP400K:First 400K
 * PWP396K:First 396K
 * PWP392K:First 392K
 * PWP388K:First 388K
 * PWP384K:First 384K
 * PWP380K:First 380K
 * PWP376K:First 376K
 * PWP372K:First 372K
 * PWP368K:First 368K
 * PWP364K:First 364K
 * PWP360K:First 360K
 * PWP356K:First 356K
 * PWP352K:First 352K
 * PWP348K:First 348K
 * PWP344K:First 344K
 * PWP340K:First 340K
 * PWP336K:First 336K
 * PWP332K:First 332K
 * PWP328K:First 328K
 * PWP324K:First 324K
 * PWP320K:First 320K
 * PWP316K:First 316K
 * PWP312K:First 312K
 * PWP308K:First 308K
 * PWP304K:First 304K
 * PWP300K:First 300K
 * PWP296K:First 296K
 * PWP292K:First 292K
 * PWP288K:First 288K
 * PWP284K:First 284K
 * PWP280K:First 280K
 * PWP276K:First 276K
 * PWP272K:First 272K
 * PWP268K:First 268K
 * PWP264K:First 264K
 * PWP260K:First 260K
 * PWP256K:First 256K
 * PWP252K:First 252K
 * PWP248K:First 248K
 * PWP244K:First 244K
 * PWP240K:First 240K
 * PWP236K:First 236K
 * PWP232K:First 232K
 * PWP228K:First 228K
 * PWP224K:First 224K
 * PWP220K:First 220K
 * PWP216K:First 216K
 * PWP212K:First 212K
 * PWP208K:First 208K
 * PWP204K:First 204K
 * PWP200K:First 200K
 * PWP196K:First 196K
 * PWP192K:First 192K
 * PWP188K:First 188K
 * PWP184K:First 184K
 * PWP180K:First 180K
 * PWP176K:First 176K
 * PWP172K:First 172K
 * PWP168K:First 168K
 * PWP164K:First 164K
 * PWP160K:First 160K
 * PWP156K:First 156K
 * PWP152K:First 152K
 * PWP148K:First 148K
 * PWP144K:First 144K
 * PWP140K:First 140K
 * PWP136K:First 136K
 * PWP132K:First 132K
 * PWP128K:First 128K
 * PWP124K:First 124K
 * PWP120K:First 120K
 * PWP116K:First 116K
 * PWP112K:First 112K
 * PWP108K:First 108K
 * PWP104K:First 104K
 * PWP100K:First 100K
 * PWP96K:First 96K
 * PWP92K:First 92K
 * PWP88K:First 88K
 * PWP84K:First 84K
 * PWP80K:First 80K
 * PWP76K:First 76K
 * PWP72K:First 72K
 * PWP68K:First 68K
 * PWP64K:First 64K
 * PWP60K:First 60K
 * PWP56K:First 56K
 * PWP52K:First 52K
 * PWP48K:First 48K
 * PWP44K:First 44K
 * PWP40K:First 40K
 * PWP36K:First 36K
 * PWP32K:First 32K
 * PWP28K:First 28K
 * PWP24K:First 24K
 * PWP20K:First 20K
 * PWP16K:First 16K
 * PWP12K:First 12K
 * PWP8K:First 8K
 * PWP4K:First 4K
 * OFF:Disable
 */
#pragma config PWP      = OFF           // Program Flash Write Protect

/**********************************************************
 * ICS_PGx1:ICE EMUC1/EMUD1 pins shared with PGC1/PGD1
 * ICS_PGx2:ICE EMUC2/EMUD2 pins shared with PGC2/PGD2
 */
#pragma config ICESEL   = ICS_PGx2      // ICE/ICD Comm Channel Select

/**********************************************************
 * ON:Debugger is enabled
 * OFF:Debugger is disabled
 */
#pragma config DEBUG    = OFF            // Background Debugger Enable

#endif	/* PRAGMACONFIG_H */

