#include "system.h"

/*----------------------------------------------------------------------------
	GetCP0Count()
--------------------------------------------------------------------------*/
uint32_t getCP0Count(){
	//u32 count;
	//asm("di"); // Disable all interrupts
	//count = _CP0_GET_COUNT();
	//asm("ei"); // Enable all interrupts
	//return count;
	return _CP0_GET_COUNT();
}

/*	----------------------------------------------------------------------------
	Wait us microseconds
	Use CP0 Count register which counts at half the CPU rate
	--------------------------------------------------------------------------*/
void delayus(uint16_t us){
    // CP0Count counts at half the CPU rate
    uint8_t Fcp0 = SYS_FREQ / 1000000 / 2;		// max = 40 for 80MHz

    // get start ticks
    uint32_t start = getCP0Count();

    // calculate last tick number for the given number of microseconds
    uint32_t stop = start + us * Fcp0;

    // wait till count reaches the stop value
    if (stop > start)
        while (getCP0Count() < stop);
    else
        while (getCP0Count() > start || getCP0Count() < stop);
}

/*	----------------------------------------------------------------------------
	wait ms milliseconds
	--------------------------------------------------------------------------*/
void delayms(uint16_t ms){
    do{
        delayus(1000); // 1 ms
    }while(--ms);
}

int micros(void){
    // CP0Count counts at half the CPU rate
    uint8_t Fcp0 = SYS_FREQ / 1000000 / 2;		// max = 40 for 80MHz
    // get start ticks
    uint32_t start = getCP0Count();
    // calculate last tick number for the given 1 microseconds
    uint32_t stop = start + Fcp0;

}