#ifndef SYSTEM_H
#define	SYSTEM_H

#include <plib.h>
#include <stdint.h>

/* Microcontroller MIPs (FCY) */
#define SYS_FREQ     80000000UL
#define FCY          SYS_FREQ

/******************************************************************************/
/* User Functions                                                             */
/******************************************************************************/
#define	GetPeripheralClock()		(SYS_FREQ/(1 << OSCCONbits.PBDIV))
#define GetSystemFreq()                   (SYS_FREQ)

uint32_t getCP0Count();
void delayus(uint16_t us);
void delayms(uint16_t ms);

#endif	/* SYSTEM_H */

