#include "timer.h"

/****************************************************************************
Gestion des timers (avec l'activation de l'interruption)
 ****************************************************************************/
void initTimer(void){
    /* Pour calculer les PR : (Freq_Systeme/FrequenceINT/Prediviseur)-1
     * avec prediviseur de 256, on a :
     * 1Hz      : 31249
     * 10Hz     : 6249
     * 100Hz    : 3124
     * 500Hz    : 624
     * 1kHz     : 312
     * 5kHz     : 62
     * 10kHz    : 30     */

    /* Configuration du timer 2*/
    OpenTimer2(T2_ON | T2_SOURCE_INT | T2_PS_1_256, 312);
    ConfigIntTimer2(T2_INT_ON | T2_INT_PRIOR_3 | T2_INT_SUB_PRIOR_1);
    _millis = 0;

    writeString(UART1,"init timer\r\n");
}

unsigned int millis(void){
    return(_millis);
}

/******************************************************************************
Exemple Interrupt Routines

void __ISR(_TIMER_2_VECTOR, ipl3) Timer2Handler(void){
    mT2ClearIntFlag();
}
 ******************************************************************************/
void __ISR(_TIMER_2_VECTOR, ipl3) Timer2Handler(void){
    _millis++;
    mT2ClearIntFlag();
}