#include "uart.h"

void initUART(void){
    /* UART 1 */
    // Configure UART1 TX
    UARTConfigure(UART1, UART_ENABLE_PINS_TX_RX_ONLY);
    UARTSetFifoMode(UART1, UART_INTERRUPT_ON_TX_NOT_FULL | UART_INTERRUPT_ON_RX_NOT_EMPTY);
    UARTSetLineControl(UART1, UART_DATA_SIZE_8_BITS | UART_PARITY_NONE | UART_STOP_BITS_1);
    UARTSetDataRate(UART1, GetPeripheralClock(), 57600);
    UARTEnable(UART1, UART_ENABLE_FLAGS(UART_PERIPHERAL | UART_RX | UART_TX));
    // Configure UART1 RX Interrupt
    INTEnable(INT_SOURCE_UART_RX(UART1), INT_ENABLED);
    INTSetVectorPriority(INT_VECTOR_UART(UART1), INT_PRIORITY_LEVEL_2);
    INTSetVectorSubPriority(INT_VECTOR_UART(UART1), INT_SUB_PRIORITY_LEVEL_0);
    writeString(UART1,"init UART\r\n");
}

void writeString(const int uartX, const char *string){
    while(*string != '\0'){
        while(!UARTTransmitterIsReady(uartX))
            ;

        UARTSendDataByte(uartX, *string);

        string++;

        while(!UARTTransmissionHasCompleted(uartX))
            ;
    }
}

/* renvoi le charactere qu'il recoit*/
void putCharacter(const int uartX, const char character){
        while(!UARTTransmitterIsReady(uartX))
            ;

        UARTSendDataByte(uartX, character);


        while(!UARTTransmissionHasCompleted(uartX))
            ;
}

/******************************************************************************
Interrupt Routines
 ******************************************************************************/

// UART 1 interrupt handler
// it is set at priority level 2
void __ISR(_UART_1_VECTOR, ipl2) intUart1Handler(void){
    // Is this an RX interrupt?
    if(INTGetFlag(INT_SOURCE_UART_RX(UART1))){
        // Clear the RX interrupt Flag
        INTClearFlag(INT_SOURCE_UART_RX(UART1));
// TODO mettre l'action a faire ici
        putCharacter(UART1,UARTGetDataByte(UART1));
    }
    // We don't care about TX interrupt
    if ( INTGetFlag(INT_SOURCE_UART_TX(UART1)) ){
            INTClearFlag(INT_SOURCE_UART_TX(UART1));
    }
}