/*

rev 16/04/2013
augment tous les delais car usage PLLx4 x10Mhz => 40Mhz 
et donc cycle horloge =100 nS   ( 1 NOP=100nS)

 Hardware li:
 PORTB pour DATA & CTRL
 PORTB Upper B4..B7 pour LCD Data D4..D7   
            avec D0..D3 relies au Gnd (0V)
 PortB B3 pour EN LCD 6
 PORTB B2 pour RS LCD    
 B0 et B1 sont dispo!
 */

 
//DATA_PORT defines the port to which the LCD data lines are connected 
#define LCD_DATAPORT       PORTB
#define LCD_DATAPORT_TRIS  TRISB
//CTRL_PORT defines the port where the control lines are connected.
//ReadWrite Pin
#define LCD_RWPIN       PORTBbits.RB1           // pin 5 LCD Grounded
#define LCD_RWPIN_TRIS  TRISBbits.TRISB1
//RS Pin
#define LCD_RSPIN       PORTBbits.RB2           // pin 4 LCD    
#define LCD_RSPIN_TRIS  TRISBbits.TRISB2
//Enable Pin
#define LCD_ENPIN       PORTBbits.RB3           // pin 6 LCD
#define LCD_ENPIN_TRIS  TRISBbits.TRISB3



void LCD_Init(void);                            //to initialise the LCD
void LCD_Put(char data);                        //to put dtat to be displayed
void LCD_PutRamString(char *string);            //to display data string in RAM
void LCD_PutRomString(rom char *string);        //to display data stringin ROM
//char LCDIsBusy(void);                         //to check Busy flag
void LCD_Cde(unsigned char cmd);                //to send commands to LCD
//unsigned char LCDGetAddr(void);
//char LCDGet(void);

void Pulse_E (void);
void LCD_Pos(char L,char posX);
void LCD_Erase_Ligne(char L1);

#define LCD_L1home()    LCD_Cde(0x80)
#define LCD_L2home()    LCD_Cde(0xC0)
#define LCD_Clear()     LCD_Cde(0x01)
#define LCD_ReturnHome() LCD_Cde(0x02)

void LCD_Delay15ms(void);
void LCD_Delay4ms(void);
void LCD_Delay100us(void);
void LCD_Delay500ns(void);
void LCD_Delay(void);
void SetCGRamAddr(unsigned char CGaddr);

/*********************************************************************
 * Function      : void LCDInit(void)
 * PreCondition  : None
 * Input         : None
 * Output        : None
 * Side Effects  : None
 * Overview      : LCD is intialized
 * Note          : This function will work with Hitachi HD447780 LCD controller.
 ********************************************************************/

void LCD_Init(void)
{

//PORT initialization
//4bit mode
//Upper 4-bits of the DATAPORT as output
LCD_DATAPORT_TRIS  &= 0x0f;
LCD_DATAPORT &= 0x0f;
LCD_Delay15ms();
//control port initialization
LCD_RSPIN_TRIS =0;                         //make control ports output
LCD_ENPIN_TRIS =0;
LCD_RSPIN  =0;                             //clear control ports
LCD_ENPIN  =0;

//initialization by instruction
//  envoi 3 fois de suite 0x30 (03 sur le quarter MSB du PORTB)
LCD_Delay15ms();
// Upper nibble interface
LCD_DATAPORT   =LCD_DATAPORT & 0x0f;        // 1ere init
LCD_DATAPORT   =LCD_DATAPORT| 0b00110000;	 // 0x30
Pulse_E() ;
LCD_Delay15ms();


// Upper nibble interface
LCD_DATAPORT   &= 0x0f;        // 2em ini
LCD_DATAPORT   |= 0b00110000;
Pulse_E() ;
LCD_Delay15ms();


// Upper nibble interface
LCD_DATAPORT   &= 0x0f;        // 3em init
LCD_DATAPORT   |= 0b00110000;
LCD_Delay();
Pulse_E() ;
LCD_Delay4ms();


//Force le mode 4 Bits    0x02H sur quartet MSB du PortB
//Function SET Commande 0 0 1 DL N F X X  avec RS=0 RW=0
// Upper nibble interface
LCD_DATAPORT   &= 0x0f;        // Clear upper port
LCD_Delay();
LCD_DATAPORT   |= 0b00100000;
LCD_Delay();
Pulse_E() ;

//Function SET Commande 0 0 1 DL N F X X  avec RS=0 RW=0
//Definit la taille de l'interface (DL=0 pour mode 4 bits, DL=1 pour mode 8 bits),
// le nombre de lignes (NL=0 pour 1 ligne, N=1 pour 2 ou 4 lignes),
// et la taille des fontes (F=0 pour des cars 5x7, F=1 pour des cars 5x10).
LCD_Cde(0b00101000);    // 0x28     2Line 5x8

//Display on/off control  0 0 0 0 1 D C B
// affichage (D), curseur (C), clignotement du curseur (B).
LCD_Cde(0b00001000);    //display off
LCD_Cde(0b00000001);    //display clear  was 0b00000001); 

//Entry mode setting
//Entry mode command " 0 0 0 0 0 1 ID S "
//ID =0 no cursor increment during read and write
//ID =1 cursor increment during read and write
//S =0 no display during read and write
//S =1 display shift

 LCD_Cde(0b00000110);    //0x06 if cursor inc and no display shift

//Display on off ,Blink ,cursor command set
//"0 0 0 0 1 D C B "
//D=1 dislay on, C=1 cursor off, B=1 blink off
LCD_Cde(0b00001100);    //0x0F 0b00001111 =display ON, cursor on, blink ON
LCD_Delay();

// end of initialization
  return;
}


void  Pulse_E (void)
{
LCD_ENPIN = 1;
LCD_Delay();
LCD_ENPIN = 0;
LCD_Delay500ns();
 }


/**********************************************************
 * Function         : void LCD_Cde(unsigned char cmd)
 * PreCondition     : None
 * Input            : cmd - Command to be set to LCD.
 * Output           : None
 *********************************************************/
void LCD_Cde(unsigned char cmd)
{
LCD_Delay();
LCD_RSPIN=0;
LCD_ENPIN=0;
LCD_DATAPORT &=0x0f;               //clear port
LCD_DATAPORT |= cmd&0xf0;          //write upper nibble of cmd to UPPERT port
LCD_Delay();
Pulse_E();
LCD_DATAPORT &= 0x0f;              //clear port and shift left 4 times
LCD_DATAPORT |= (cmd<<4)&0xf0;	    //write lower nibble of cmd  to UPPERT port
LCD_Delay();
Pulse_E ();
return;
}
/******************************************************
 * Function         :LCDPut()
 * PreCondition     :None
 * Input            :data - donnee a transmettre au LCD.
 * Output           :None
 *****************************************************/
void LCD_Put(char data)
{
LCD_Delay();
LCD_RSPIN=1;
LCD_ENPIN=0;
LCD_DATAPORT &=0x0f;               //clear port
LCD_DATAPORT |= data&0xf0;         //write upper nibble to port
LCD_ENPIN = 1;                     // Clock the cmd in
LCD_Delay();
LCD_ENPIN = 0;

LCD_DATAPORT &= 0x0f;              //clear port
LCD_DATAPORT |= (data<<4)&0xf0;	//shift left 4 times
LCD_ENPIN = 1;
LCD_Delay();
LCD_ENPIN = 0;
return;
}


/***************************************************
 * Function         :LCDPutRomString(rom char *string)
 * PreCondition     :None
 * Input            :None
 * Output           :Displays string in Program memory
 * Note             :is lways blocking till the string is written fully
 *****************************************************/

void LCD_PutRomString(rom char *string)
{
     while(*string)                         // Write data to LCD up to null
    {
        LCD_Put(*string);                   // Write character to LCD
        string++;                           // Increment buffer
    }
    return;
}
/****************************************************
 * Function         :LCDPutRomString(ram char *string)
 * PreCondition     :None
 * Input            :None
 * Output           :Displays string in Ram memory
 * Note             :is Allways blocking till the string is written fully
 ******************************************************/
void LCD_PutRamString(char *string)
{
    while(*string)                          // Write data to LCD up to null
    {
        LCD_Put(*string);                   // Write character to LCD
        string++;                           // Increment buffer
    }
    return;
}

void LCD_Pos(char L,char posX)
{
 char x;
 if (L==1) x=0x80+posX;     // D7=1 + adresse D6..D0 = 0 a 15
 if (L==2) x=0xC0+posX;	    // D7=1 + offset 40H 2nd line + adress D6..D0 = 0 a 15
 LCD_Cde(x);
}

void LCD_Erase_Ligne(char L1)
{
 int x;
 LCD_Pos(L1,0); //  retour en debut de ligne
 for (x=0;x<16;x++) LCD_Put(' ');
 LCD_Pos(L1,0);
}

void LCD_Delay15ms (void)
{
    int i;
    for(i=0;i<10000;i++)
    {
    Nop();
    }
    return;
}

void LCD_Delay4ms(void)
{
    int i;
    for(i=0;i<2500;i++)
    {
    Nop();
    }
    return;
}

void LCD_Delay500ns(void)
{
    Nop();
    Nop();
    Nop();
    Nop();
    Nop();
}

void LCD_Delay(void)
    {
    int i;
    for(i=0;i<1000;i++)
        {
        Nop();
        }
    return;
    }

void SetCGRamAddr(unsigned char CGaddr)
{
  LCD_RSPIN  =0;

  LCD_DATAPORT  &= 0x0f;                      // Write upper nibble
  LCD_DATAPORT  |= ((CGaddr | 0b01000000) & 0xf0);
  LCD_Delay500ns();
  Pulse_E();
  // Upper nibble interface
  LCD_DATAPORT  &= 0x0f;                      // Write lower nibble
  LCD_DATAPORT  |= ((CGaddr<<4)&0xf0);
  LCD_Delay500ns();
  Pulse_E();
  return;
}

void DelayFor18TCY( void )
{
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	
}

#define LCD_CursorOnBlinkOn        LCD_Cde(0x0F)	//the user may refer the LCD data sheet
#define LCD_CursorOnBlinkOff       LCD_Cde(0x0E)	//and generate commands like this
#define LCD_DisplayOnCursorOff     LCD_Cde(0x0C)
#define LCD_DisplayOff             LCD_Cde(0x08)
#define LCD_CursorMoveLeft         LCD_Cde(0x10)
#define LCD_CursorMoveRight        LCD_Cde(0x14)
#define LCD_DisplayMoveLeft        LCD_Cde(0x18)
#define LCD_DisplayMoveRight       LCD_Cde(0x1C)

#ifndef BarresH
#define BarresH

unsigned char rom Barres[8][8] = 
{
// Gauche1
  {
  0b00000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b00000000
  },
// Gauche2
  {
  0b00000000,
  0b11000000,
  0b11000000,
  0b11000000,
  0b11000000,
  0b11000000,
  0b11000000,
  0b00000000
  },
  // Gauche3
  {
  0b00000000,
  0b11100000,
  0b11100000,
  0b11100000,
  0b11100000,
  0b11100000,
  0b11100000,
  0b00000000
  },
  // Gauche4
  {
  0b00000000,
  0b11110000,
  0b11110000,
  0b11110000,
  0b11110000,
  0b11110000,
  0b11110000,
  0b00000000
  },
  // Gauche5
  {
  0b00000000,
  0b11111000,
  0b11111000,
  0b11111000,
  0b11111000,
  0b11111000,
  0b11111000,
  0b00000000
  },
   // Gauche6
  {
  0b00000000,
  0b11111100,
  0b11111100,
  0b11111100,
  0b11111100,
  0b11111100,
  0b11111100,
  0b00000000
  },
    // Gauche7
  {
  0b00000000,
  0b11111110,
  0b11111110,
  0b11111110,
  0b11111110,
  0b11111110,
  0b11111110,
  0b00000000
  },
     // Gauche8
  {
  0b00000000,
  0b11111111,
  0b11111111,
  0b11111111,
  0b11111111,
  0b11111111,
  0b11111111,
  0b00000000
  }
};
#endif

#ifndef FONTS_H
#define FONTS_H


//-----------------------------------------
// Definition des nouveaux caracteres
// redefinissables par l'utilisateur
//----------------------------------------

unsigned char rom ncarac[8][8] = {
// fleche droite
  {
  0b00000,
  0b10000,
  0b11000,
  0b11100,
  0b11110,
  0b11100,
  0b11000,
  0b10000
  },
//fleche gauche
  {
  0b00000,
  0b00001,
  0b00011,
  0b00111,
  0b01111,
  0b00111,
  0b00011,
  0b00001
  },
// fleche haut
  {
  0b00100,
  0b01110,
  0b11111,
  0b01110,
  0b01110,
  0b01110,
  0b01110,
  0b01110
  },
// fleche bas
  {
  0b01110,
  0b01110,
  0b01110,
  0b01110,
  0b01110,
  0b11111,
  0b01110,
  0b00100
  },
// e accent aigu
  {
  0b00010,
  0b00100,
  0b01110,
  0b10001,
  0b11111,
  0b10000,
  0b01110,
  0b00000
  },
// e accent grave
  {
  0b01000,
  0b00100,
  0b01110,
  0b10001,
  0b11111,
  0b10000,
  0b01110,
  0b00000
  },
// a accent grave
  {
  0b01000,
  0b00100,
  0b01110,
  0b00001,
  0b01111,
  0b10001,
  0b01111,
  0b00000
  },
//degree
   {
  0b00010,
  0b00101,
  0b00010,
  0b00000,
  0b00000,
  0b00000,
  0b00000,
  0b00000
  }
};
#endif

/* quelques caracteres supplementaires
pouvant remplacer les precedant

// un sourire
  {
  0b01110,
  0b11111,
  0b01010,
  0b00000,
  0b10101,
  0b10001,
  0b01110,
  0b00000
  },
//rectangle vide
  {
  0b11111,
  0b10001,
  0b10001,
  0b10001,
  0b10001,
  0b10001,
  0b10001,
  0b11111
  },
//rectangle plein
  {
  0b11111,
  0b11111,
  0b11111,
  0b11111,
  0b11111,
  0b11111,
  0b11111,
  0b11111
  };

*/

















