
/*
=========== HARDWARE ====================
PIC 18F252  microchip  avec Bootoader install en fond de memoire
27 pf  Q=20Mhz 27pF
Interface 2T pour liaison UART TTL <-> RS232 38400 bauds
// LCD GDM 1602 :  2 lignes de 16 cars
// Ligne 1 addresses de 00h  0Fh
// Ligne 2 addresses de 40h  4Fh

PortB
B0  21
B1  22
B2  23  RS_PIN  LCD
B3  24  E_PIN   LCD
B4  25  DATA    LCD
B5  26  DATA    LCD
B6  27  DATA    LCD
B7  28  DATA    LCD

PORTA
A0   2
A1   3
A2   4  input <= BP start
A3   5  output => Armement Monostable
A4   6  output => Relais de gamme
A5   7

PORTC
C0   11
C1   12
C2   13  <- CCP1 input  <- sortie monostable 74123
C3   14
C4   15
C5   16  NC
C6   17  TX  RS232   UART Harware
C7   18  RX  RS232   UART Hardware
====================================================
*/

#include"p18f252.h"
#define p18f252

//  dans MPLAB configure bits set est coche!
//config du PIC
#pragma config OSC = HS
#pragma config PWRT = ON
#pragma config WDT = OFF
#pragma config BOR = OFF
#pragma config BORV = 42
#pragma config LVP = OFF


#include <stdlib.h>
#include <stdio.h>
#include <delays.h>
#include <string.h>
#include <usart.h>   // pour fonctions UART
#include <adc.h>
#include <ctype.h>
#include <portb.h>
#include <timers.h>
#include <math.h>

#include "../_common/LCD2x16.h"
#include "../_common/Rs232.h"


#define LCD_CursorOnBlinkOn()        LCD_Cde(0x0F)	//the user may refer the LCD data sheet
#define LCD_CursorOnBlinkOff()       LCD_Cde(0x0E)	//and generate commands like this
#define LCD_DisplayOnCursorOff()     LCD_Cde(0x0C)
#define LCD_DisplayOff()             LCD_Cde(0x08)
#define LCD_CursorMoveLeft()         LCD_Cde(0x10)
#define LCD_CursorMoveRight()        LCD_Cde(0x14)
#define LCD_DisplayMoveLeft()        LCD_Cde(0x18)
#define LCD_DisplayMoveRight()       LCD_Cde(0x1C)

#ifndef Byte
#define Byte unsigned char
#endif

#define CLS 12
#define TAB 9
#define CR 13
#define LF 10
#define Bell 7

rom const char chaine0[]="...";
rom const char chaine1[]="Port comm 38400 ouvert ... String en ROM \r\n";
rom const char chaine2[]="C18: LCD_P18_PortB_4b_Upper_Test.c\r\n";
rom const char chaine3[]="ESC pour sortir\r";
rom const char chaine4[]="Capacite en pF  ";
rom const char chaine5[]="Capacite en nF  ";
rom const char chaine6[]="Capacite en uF  ";
rom const char chaine7[]=" ";
// Attention sous VB6
// verifier l'ordre CRLF et non pas LFCR, sinon on voit 2 car non imprimable
// et pas de changement de ligne
rom char *RS_Str[]={chaine0,chaine1,chaine2,chaine3,chaine4,chaine5,chaine6,chaine7};

                     //  1234567890123456
rom const char Lcd00[]=" 18F252 20MHz   ";
rom const char Lcd01[]=" Capacimetre    ";
rom const char Lcd02[]="  MPLAB C18     ";
rom const char Lcd03[]=" 30 dec  2011   ";
rom const char Lcd04[]=" Capacite NanoF ";
rom const char Lcd05[]=" Over !!!       ";
rom const char Lcd06[]=" Moyenne 10 mes ";
rom const char Lcd07[]=" Capacite en uF ";
rom const char Lcd08[]=" Time Ecoule    ";
rom const char Lcd09[]="................";

rom char *LCD_Str[]={Lcd00,Lcd01,Lcd02,Lcd03,Lcd04,Lcd05,Lcd06,
      Lcd07,Lcd08,Lcd09};


#ifndef VARTXT
char Texte[MAX_LEN]="18F252_Capacim_ICM7555.c\r\n  string en RAM\r";
char *txt=&Texte[0];
unsigned char Entree[17]="123456789012345";
unsigned char *valtxt;
char buffer[MAX_LEN]="00000000000000000000000";	// buffer de reception
char received;
char *ptlec;		// pointeur de lecture
char *ptecr;		// pointeur d'ecriture
unsigned int CptCars;
unsigned int SaisieOk;
#endif


//unsigned char Drapeaux ;     // 8 flags
struct chbits {
                 unsigned Running:1;
                 unsigned Standby:1;
                 unsigned Elligible:1;
                 unsigned Accumule:1;
                 unsigned Blc:1;
                 unsigned OneShot:1;
                 unsigned Fill:1;
                 unsigned Lcd:1;
               } Drapeaux;

#define OUT_RS232 Drapeaux.Lcd=0;
#define OUT_LCD Drapeaux.Lcd=1;

Byte receive;
char error;
char EtatCf;
signed char Ve;
unsigned int  NbMes;
Byte Allume_led;
Byte Dummy;
unsigned short int i,j,k;




//------- Subroutines.h -----------
void Octet2Hex(unsigned char number);
void print_flt(float W,int NbDeci,char Bold);
void fltToa (float x, unsigned char *str,char precision);
void Write_Word(unsigned int M,char Sign,char Bold);
void Write_Str(char *ptr);

/*-------- LCD-----------------------
void LCD_pos(char L,char posX);
void LCD_Init(void);
void LCD_Put(char data);
void LCD_PutRamString(char *string);
void LCD_PutRomString(rom char *string);
void LCD_Cde(unsigned char cmd);
void Pulse_E (void);
void LCD_Pos(char L,char posX);
void Erase_Ligne(char L1);
LCD_L1home()    XLCDCommand(0x80)
LCD_L2home()    XLCDCommand(0xC0)
LCD_Clear()     XLCDCommand(0x01)
LCD_ReturnHome() XLCDCommand(0x02)
void LCD_Delay15ms (void);
void LCD_Delay4ms(void);
void LCD_Delay500ns(void);
void LCD_Delay(void);

--------------------------------------*/

void LCD_Custom_Car(char pos, const char *s)
 {
  int j1;
  for( j1=0; j1<8; j1++ ) {
    LCD_RSPIN=0;;
     LCD_Cde((SET_CGRAM_ADDRESS | ((pos << 3) + j1));
    LCD_RSPIN=1;
    LCD_Put( s[j1] );
  }
LCD_RSPIN=0;
}


void Octet2Hex(unsigned char number)
{
char high,low;
  // high nibble
  high = ((number & 0xF0) >> 4) + 48; // + '0'
  if (high > '9') high =high + 7;
 // low nibble
  low = (number & 0x0F) + 48;          // +'0' low nibble
  if (low > '9')  low += 7;           // '9'= 57u
  if (Drapeaux.Lcd) LCD_Put(high); else Put_RS(high);
  if (Drapeaux.Lcd) LCD_Put(low); else Put_RS(low);
  if (Drapeaux.Lcd) LCD_Put('h'); else Put_RS('h');
 }


void print_flt(float W,int NbDeci,char Bold)
{long lWhole;
 unsigned int ulPart;
 Drapeaux.Fill=0;
 lWhole=(long)(W);
 ulPart=(unsigned int)((W*(float)NbDeci)-(float)(lWhole*NbDeci));
 ultoa(lWhole,&Texte[0]);
 Write_Str(Texte);
 if (Drapeaux.Lcd) LCD_Put('.'); else Put_RS('.');
 Write_Word(ulPart,0,0);
}

void fltToa (float x, unsigned char *str,char precision)
{
/* converts a floating point number to an ascii string */
/* x is stored into str, which should be at least 30 chars long */
int ie, i, k, ndig;
double y;
ndig = ( precision<=0) ? 7 : (precision > 22 ? 23 : precision+1);
ie = 0;
/* if x negative, write minus and reverse */
if ( x < 0)
  {
  *str++ = '-';
  x = -x;
  }
/* put x in range 1 <= x < 10 */
if (x > 0.0) while (x < 1.0)
  {
  x *= 10.0;		// a la place de =*
  ie--;
  }
while (x >= 10.0)
  {
  x = x/10.0;
  ie++;
 }
 ndig += ie;				// a la place de =+
//round. x is between 1 and 10 and ndig will be printed to
// right of decimal point so rounding is ...
for (y = i = 1; i < ndig; i++)
  y = y/10.;
x += y/2.;
if (x >= 10.0) {x = 1.0; ie++;}
if (ie<0)
  {
   *str++ = '0'; *str++ = '.';
   if (ndig < 0) ie = ie-ndig;
   for (i = -1; i > ie; i--)  *str++ = '0';
  }
for (i=0; i < ndig; i++)
  {
  k = x;
  *str++ = k + '0';
  if (i ==  ie ) *str++ = '.';
  x -= (y=k);
  x *= 10.0;
  }
*str = '\0';
}


void Write_Word(unsigned int M,char Sign,char Bold)
{
unsigned int i,k,l;
unsigned long M1;
 valtxt=&Entree[0];
 if (Sign>1) return;
 if (Sign==0)
  {       M1=M;
        ultoa(M1,&Entree[0]);
  }
  else itoa(M,&Entree[0]);
 if (Drapeaux.Fill)
 {
  k=strlen(Entree);
  for (i=0;i<k;i++) Entree[4+Sign-i]=Entree[k-i-1];
  for (i=0;i<(5+Sign-k);i++)
  {if (Drapeaux.Blc) Entree[i]='0'; else Entree[i]=' ';}
 }
 Entree[5+Sign]=0;
  if (Drapeaux.Lcd) Write_Str(valtxt); else k=PutStr_RS(valtxt);

}

void Write_Str(char *ptr)
{
while(*ptr!=0)
    {
     if (Drapeaux.Lcd) LCD_Put(*ptr++); else Put_RS(*ptr++);
     Tempo(200L);
   } ;
}


void Init_Hardware()
 {
 #ifdef p18F258
   CANCON=0x00;     //   0b 000 0  0000    request disable mode
   CANSTAT =0x00;  //    0b 001 0 000 0    disable mode no interrupt
 #endif
   PORTB = 0x00;
   TRISB = 0x00;
   TRISBbits.TRISB0=1;   	// B0 not used
   TRISBbits.TRISB1=0;   	// B1 reserve LCD RW_PIN3 not used
   TRISBbits.TRISB2=0;   	// B2 RS_PIN
   TRISBbits.TRISB3=0;	// B3 E_PINB3
   TRISBbits.TRISB4=0;	// B4 LCD DATA
   TRISBbits.TRISB5=0;	// B5 LCD DATA
   TRISBbits.TRISB6=0;      // B6 LCD DATA
   TRISBbits.TRISB7=1;      // B7 LCD DATA

   PORTB = 0x00;

      // ATTENTION a l'ordre des canaux ANALOGIQUES !!!
  ADCON0 =0 ;
  ADCON1=0x07;            // No analog input on Port A
  TRISA = 0b00000111 ;    // PORTA is RA0,1,2,= Digital input  RA3,4,5=Digital output
  LATA = 0x00;

  PORTC = 0xFF;           // set PORTC to $FF
  TRISC = 0b10000100;
  TRISCbits.TRISC0 = 0;
  TRISCbits.TRISC1 = 0;
  TRISCbits.TRISC2 = 1;  //RC2/CCP1 en entree
  TRISCbits.TRISC3 = 0;
  TRISCbits.TRISC4 = 0;
  TRISCbits.TRISC5 = 0;
  TRISCbits.TRISC6 = 0;  // TX - Set as Output UART RS232 and Bootloader
  TRISCbits.TRISC7 = 1;  // RX - Set Receive pin for UART RS232 and Bootloader
 }

void main (void)
{
Init_Hardware();
Tempo(100000L);
OUT_LCD
LCD_Init();
Tempo(5000L);
// example to display Rom strings
LCD_L1home();
LCD_PutRomString(LCD_Str[0]);
Tempo(50000L);
// example to display Ram strings
LCD_L2home();
strcpypgm2ram(txt,"1234567890123456");
LCD_PutRamString(txt);
Tempo(250000L);

while(1);

}
