
/********************************************************************

ANALOG TO DIGITAL CONVERTOR INTERFACING TEST PROGRAM

*********************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include <xc.h>
//#include "plib/adc.h"


// #pragma config statements should precede project file includes.
// Use project enums instead of #define for ON and OFF.

// #pragma config statements should precede project file includes.
// Use project enums instead of #define for ON and OFF.

// CONFIG1H
#pragma config OSC = INTIO67    // Oscillator Selection bits (Internal oscillator block, port function on RA6 and RA7)
#pragma config FCMEN = OFF      // Fail-Safe Clock Monitor Enable bit (Fail-Safe Clock Monitor disabled)
#pragma config IESO = OFF       // Internal/External Oscillator Switchover bit (Oscillator Switchover mode disabled)

// CONFIG2L
#pragma config PWRT = OFF       // Power-up Timer Enable bit (PWRT disabled)
#pragma config BOREN = SBORDIS  // Brown-out Reset Enable bits (Brown-out Reset enabled in hardware only (SBOREN is disabled))
#pragma config BORV = 3         // Brown Out Reset Voltage bits (Minimum setting)

// CONFIG2H
#pragma config WDT = OFF        // Watchdog Timer Enable bit (WDT disabled (control is placed on the SWDTEN bit))
#pragma config WDTPS = 32768    // Watchdog Timer Postscale Select bits (1:32768)

// CONFIG3H
#pragma config CCP2MX = PORTC   // CCP2 MUX bit (CCP2 input/output is multiplexed with RC1)
#pragma config PBADEN = ON      // PORTB A/D Enable bit (PORTB<4:0> pins are configured as analog input channels on Reset)
#pragma config LPT1OSC = OFF    // Low-Power Timer1 Oscillator Enable bit (Timer1 configured for higher power operation)
#pragma config MCLRE = OFF      // MCLR Pin Enable bit (RE3 input pin enabled; MCLR disabled)

// CONFIG4L
#pragma config STVREN = ON      // Stack Full/Underflow Reset Enable bit (Stack full/underflow will cause Reset)
#pragma config LVP = ON         // Single-Supply ICSP Enable bit (Single-Supply ICSP enabled)
#pragma config XINST = OFF      // Extended Instruction Set Enable bit (Instruction set extension and Indexed Addressing mode disabled (Legacy mode))

// CONFIG5L
#pragma config CP0 = OFF        // Code Protection bit (Block 0 (000800-003FFFh) not code-protected)
#pragma config CP1 = OFF        // Code Protection bit (Block 1 (004000-007FFFh) not code-protected)
#pragma config CP2 = OFF        // Code Protection bit (Block 2 (008000-00BFFFh) not code-protected)
#pragma config CP3 = OFF        // Code Protection bit (Block 3 (00C000-00FFFFh) not code-protected)

// CONFIG5H
#pragma config CPB = OFF        // Boot Block Code Protection bit (Boot block (000000-0007FFh) not code-protected)
#pragma config CPD = OFF        // Data EEPROM Code Protection bit (Data EEPROM not code-protected)

// CONFIG6L
#pragma config WRT0 = OFF       // Write Protection bit (Block 0 (000800-003FFFh) not write-protected)
#pragma config WRT1 = OFF       // Write Protection bit (Block 1 (004000-007FFFh) not write-protected)
#pragma config WRT2 = OFF       // Write Protection bit (Block 2 (008000-00BFFFh) not write-protected)
#pragma config WRT3 = OFF       // Write Protection bit (Block 3 (00C000-00FFFFh) not write-protected)

// CONFIG6H
#pragma config WRTC = OFF       // Configuration Register Write Protection bit (Configuration registers (300000-3000FFh) not write-protected)
#pragma config WRTB = OFF       // Boot Block Write Protection bit (Boot Block (000000-0007FFh) not write-protected)
#pragma config WRTD = OFF       // Data EEPROM Write Protection bit (Data EEPROM not write-protected)

// CONFIG7L
#pragma config EBTR0 = OFF      // Table Read Protection bit (Block 0 (000800-003FFFh) not protected from table reads executed in other blocks)
#pragma config EBTR1 = OFF      // Table Read Protection bit (Block 1 (004000-007FFFh) not protected from table reads executed in other blocks)
#pragma config EBTR2 = OFF      // Table Read Protection bit (Block 2 (008000-00BFFFh) not protected from table reads executed in other blocks)
#pragma config EBTR3 = OFF      // Table Read Protection bit (Block 3 (00C000-00FFFFh) not protected from table reads executed in other blocks)

// CONFIG7H
#pragma config EBTRB = OFF      // Boot Block Table Read Protection bit (Boot Block (000000-0007FFh) not protected from table reads executed in other blocks)
#pragma intrinsic(_delay)

//#define _XTAL_FREQ 16000000 // Essayer a si on veut utiliser __delay_us() et __delay_ms()

//unsigned int val;

int scale; // voir TMR0_interrupt

//void interrupt TMR0_interrupt(void)
//{
//    // On entre dans le if si overflow de TMR0, dans ce cas on incrmente portValue
//    if (INTCONbits.TMR0IE && INTCONbits.TMR0IF)
//    {
//        scale++;
//        if (scale >= 4000)
//        {
//            scale = 0;
//            LATDbits.LATD0 = ~LATDbits.LATD0;
//
//        }
//        INTCONbits.TMR0IF = 0; // reset du flag
//    }
//}

void interrupt ADC_interrupt(void)
{
    if(ADIE && ADIF)
    {
        /* Steps 5 + 6 */

        // Lire les registres et les mettre en sortie

        LATD = ~LATD;
        //LATD = ADRESL;
        //LATB = ((unsigned int) ADRESH << 8);
        LATB = (ADRESH<<1); // seuls RB1 et RB2 nous intressent

        // Clear ADIF
        ADIF = 0;

        // Attendre un temps 2*Tad minimum (discharge)
        _delay(100);

        // On recommence ACQ + Conv, et on sort de l'interruption
        GO = 1;
    }

}
int main()
{
     // TIMER0 CONFIG
    T0CON = 0b11001111;
    TMR0IE = 1;
    scale = 0; // utilis dans TMR0_interrupt

    // OSCILLATOR SELECTION
    OSCCONbits.SCS1 = 1; // internal osc.

    OSCCONbits.IRCF2 = 1; // ATTENTION A LA FREQUENCE MAXIMALE EN FONCTION DU Tad CHOISI
    OSCCONbits.IRCF1 = 1;
    OSCCONbits.IRCF0 = 0;

    // Step 1 : Configure the A/D module

    ADCON1 = 0x02; // On n'utilise pas les pins ANx comme Digital I/O, mais uniquement AN0 comme analog input
    TRISA = 0xFF; // On met tous les pins en mode input (et donc AN0 aussi)
                  // D'aprs la datasheet c'est la seule chose  faire, car RA0 disabled si AN0 df en analog input
                  // via ADCON1
    TRISB = 0x00;
    TRISD = 0x00; // Tous les pins D output
    ADCON0 = 0b00000101;  // On active le module A/D et on slectionne AN1
    ADCON2 = 0b10010101;  // (Right Justified) ; Tad = 16*Tosc

    // Step 2 : Configure A/D Interrupt

    ADIF = 0;
    ADIE = 1;
    GIE = 1;
    

    // Step 3 : Wait the required acquisition Time (NOT required here because ACQT2:ACQT0 != 000)
    // Step 4 : Start conversion
    
    LATD = 0b01010101;
    GO = 1; // start (ACQ + CONV) process
    // Step 5 : Detect that A/D conversion has finished (via interruption)
    // Step 6 : read ADRESH and ADRESL
    // Step 7 : Go directly to step 2 for next conversion (step 1 must not be modified in our case)


    while(1){}

    return 0;
}