;**********************************************************
;
;	I/O Assignments.
;

#define	LCD0	PORTB,3
#define	LCD1	PORTB,2
#define	LCD2	PORTB,1
#define	LCD3	PORTB,0
#define	ENA	PORTB,4		; Display "E"
#define	RS	PORTB,5		; Display "RS"
#define	functn	PORTB,6		; 0 = "Inductor"
#define relay	PORTB,7		; Switches Ccal





;*******************************************************************
;
;       GENERAL MATH LIBRARY DEFINITIONS
;
;
;	define assembler constants

B0		equ	0
B1		equ	1
B2		equ	2
B3		equ	3
B4		equ	4
B5		equ	5
B6		equ	6
B7		equ	7

MSB		equ	7
LSB		equ	0

;     STATUS bit definitions

#define	_C	STATUS,0
#define	_Z	STATUS,2

	processor	16f628
	include		<p16f628.inc>

;*******************************************************************
;
;       FLOATING POINT literal constants
;

EXPBIAS         equ     D'127'

;
;       floating point library exception flags
;

IOV             equ     0       ; bit0 = integer overflow flag
FOV             equ     1       ; bit1 = floating point overflow flag
FUN             equ     2       ; bit2 = floating point underflow flag
FDZ             equ     3       ; bit3 = floating point divide by zero flag
NAN		equ	4	; bit4 = not-a-number exception flag
DOM		equ	5	; bit5 = domain error exception flag
RND             equ     6       ; bit6 = floating point rounding flag, 0 = truncation
                               ; 1 = unbiased rounding to nearest LSB
SAT             equ     7       ; bit7 = floating point saturate flag, 0 = terminate on
                                ; exception without saturation, 1 = terminate on
                                ; exception with saturation to appropriate value

;**********************************************************
;
;	Motorola syntax branches
;

#define	beq	bz 
#define	BEQ	bz
#define	BNE	bnz
#define	bne	bnz

#define	BCC	bnc
#define	bcc	bnc
#define	BCS	bc
#define	bcs	bc

#define	BRA	goto
#define	bra	goto
