;**********************************************************
;
;	LCD routines
;
;*********** INITIALISE LCD MODULE 4 BIT MODE ***********************


#include <defines.inc>
#include <macros.inc>


	global LCD_Init, LCD_Clear, LCD_Home, LCD_Line2, Write_BCD_Nybble, LCD_Write_Char
	extern	MS100, Delay_2MS
	extern CHR, PB_data, COUNT1

LCDCODE	code

LCD_Init
	CALL	MS100		; WAIT FOR LCD MODULE HARDWARE RESET
	BCF	RS		; REGISTER SELECT LOW
	BCF	ENA		; ENABLE LINE LOW
	
	MOVLW	0x03		; 1
	call	LCD_Write_Nybble
	CALL	MS100		; WAIT FOR DISPLAY TO CATCH UP

	MOVLW	0x03		; 2
	call	LCD_Write_Nybble

	MOVLW	0x03		; 3
	call	LCD_Write_Nybble

	MOVLW	0x02		; Fn set 4 bits
	call	LCD_Write_Nybble
	
	MOVLW	0x0C		; 0x0C DISPLAY ON
	CALL	LCD_Write_Command

	MOVLW	0x28		; DISPLAY 2 Line , 5x7 Dot's
	CALL	LCD_Write_Command		; New in LC628/LC006 version
	
	MOVLW	0x06		; 0x06 ENTRY MODE SET
	CALL	LCD_Write_Command

	CALL	LCD_Clear
	return

;************ CLEAR DISPLAY ***************************
LCD_Clear	
	MOVLW	0x01		; CLEAR DISPLAY
	CALL	LCD_Write_Command
	CALL	Delay_2MS
	return

;*********** MOVE TO HOME *****************************
LCD_Home
	MOVLW	0x02		; HOME DISPLAY
	CALL	LCD_Write_Command
	CALL	Delay_2MS
	return

;************ MOVE TO START OF LINE 2 *****************
LCD_Line2
	MOVLW	0xC0		; ADDRESS FOR SECOND LINE OF DISPLAY
	CALL	LCD_Write_Command
	return

;**********************************************************
;	Put a BCD byte to display
Write_BCD_Byte	
;	movwf	CHR1		; temp store char
;	swapf	CHR1, W		; first high 4 bits
;	call	Write_BCD_Nybble
;	movfw	CHR1		; and then lower 4 bits, fall into Write_BCD_Nybble
;	Put a BCD nybble to display
Write_BCD_Nybble	
	ANDLW	0x0F		; MASK OFF OTHER PACKED BCD DIGIT
	ADDLW	0x30		; Convert BIN to ASCII
	call	LCD_Write_Char
	return


LCD_Write_Command
	BCF	RS
	goto	cmd1
LCD_Write_Char
	BSF	RS
cmd1
	MOVWF	CHR		; STORE CHAR TO DISPLAY
	SWAPF	CHR,W		; SWAP UPPER AND LOWER NIBBLES (4 BIT MODE)
	call	LCD_Write_Nybble
	MOVF	CHR,W		; GET CHAR AGAIN 
	call	LCD_Write_Nybble
	return	

;**********************************************************
;
;	Put 4 bits to LCD & wait (untrimmed)
;

LCD_Write_Nybble
	movwf	PB_data		; Save nybble

	btfss	PB_data,0	; copy LSbit
	bcf	LCD0
	btfsc	PB_data,0
	bsf	LCD0
	
	btfss	PB_data,1
	bcf	LCD1
	btfsc	PB_data,1
	bsf	LCD1
	
	btfss	PB_data,2
	bcf	LCD2
	btfsc	PB_data,2
	bsf	LCD2
	
	btfss	PB_data,3	; copy MSbit
	bcf	LCD3
	btfsc	PB_data,3
	bsf	LCD3
	
	BSF	ENA		; ENA HIGH
	NOP			
	BCF	ENA		; ENA LOW 
D200us	MOVLW	0x42		; DELAY  200us
	MOVWF	COUNT1	
NXT5	DECFSZ	COUNT1,F
	GOTO	NXT5	
	RETLW	0

	END