#ifndef UART_LIB_H
#define UART_LIB_H

#ifndef F_CPU
/* prevent compiler error by supplying a default */
#warning "F_CPU n'est pas defini pour <util/delay.h>. par defaut : F_CPU = 16000000UL "
#define F_CPU 16000000UL
#endif

#include <avr/interrupt.h>
#include <string.h>


// Define constants and variables for buffering incoming serial data.  We're
// using a ring buffer (I think), in which head is the index of the location
// to which to write the next incoming character and tail is the index of the
// location from which to read.
#define false 0
#define true 1

#define SERIAL_BUFFER_SIZE 64

#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))

// Define config for Serial_begin(baud, config);
#define SERIAL_5N1 0x00
#define SERIAL_6N1 0x02
#define SERIAL_7N1 0x04
#define SERIAL_8N1 0x06
#define SERIAL_5N2 0x08
#define SERIAL_6N2 0x0A
#define SERIAL_7N2 0x0C
#define SERIAL_8N2 0x0E
#define SERIAL_5E1 0x20
#define SERIAL_6E1 0x22
#define SERIAL_7E1 0x24
#define SERIAL_8E1 0x26
#define SERIAL_5E2 0x28
#define SERIAL_6E2 0x2A
#define SERIAL_7E2 0x2C
#define SERIAL_8E2 0x2E
#define SERIAL_5O1 0x30
#define SERIAL_6O1 0x32
#define SERIAL_7O1 0x34
#define SERIAL_8O1 0x36
#define SERIAL_5O2 0x38
#define SERIAL_6O2 0x3A
#define SERIAL_7O2 0x3C
#define SERIAL_8O2 0x3E

#define DEC 10
#define HEX 16
#define OCT 8
#define BIN 2


#define _ubrrh UBRR0H
#define _ubrrl UBRR0L
#define _ucsra UCSR0A
#define _ucsrb UCSR0B
#define _ucsrc UCSR0C
#define _udr UDR0

// Has any byte been written to the UART since begin()
uint8_t _written;

volatile uint8_t _rx_buffer_head;
volatile uint8_t _rx_buffer_tail;
volatile uint8_t _tx_buffer_head;
volatile uint8_t _tx_buffer_tail;

// Don't put any members after these buffers, since only the first
// 32 bytes of this struct can be accessed quickly using the ldd
// instruction.
unsigned char _rx_buffer[SERIAL_BUFFER_SIZE];
unsigned char _tx_buffer[SERIAL_BUFFER_SIZE];

// private
uint8_t printNumber(unsigned long, uint8_t);
uint8_t printFloat(double, uint8_t);

// public functions
void Serial_begin(unsigned long baud, uint8_t config);
void Serial_end();
int Serial_available(void);
int Serial_peek(void);
uint8_t Serial_read(void);
void Serial_flush(void);

// write functions
uint8_t Serial_writeChar(uint8_t);
uint8_t Serial_writeBuffer(const uint8_t *buffer, size_t size);
uint8_t Serial_writeStr(const char *str);


uint8_t Serial_printStr(const char[]);
uint8_t Serial_printChar(char);
uint8_t Serial_printuChar(unsigned char, int);
uint8_t Serial_printInt(int, int);
uint8_t Serial_printuInt(unsigned int, int);
uint8_t Serial_printLong(long, int );
uint8_t Serial_printuLong(unsigned long, int);
uint8_t Serial_printDouble(double, int );


uint8_t Serial_printlnStr(const char[]);
uint8_t Serial_printlnChar(char);
uint8_t Serial_printlnuChar(unsigned char, int );
uint8_t Serial_printlnInt(int, int);
uint8_t Serial_printlnuInt(unsigned int, int );
uint8_t Serial_printlnLong(long, int);
uint8_t Serial_printlnuLong(unsigned long, int);
uint8_t Serial_printlnDouble(double, int);
uint8_t Serial_println(void);

#endif
