
// 14-11-2014 
//http://forums.futura-sciences.com/electronique/666166-possible-langage-c-3.html

#define Version "Version 14115 b"
/*
http://forums.futura-sciences.com/electronique/666166-possible-langage-c.html
Mais comment faut-il que je procde?Je rexplique ce que je veux faire :
- Entre CAN sur 8 bits, moyennage sur 16 mesures.
- Je prends les 8 bits de poids fort de mon PWM :
- Si mon PWM < CAN,  chaque interruption Timer, 
  j'augmente de 1 mes bits de poids faible de mon PWM(en tout 6 bits donc 2^6 cycles minimum)
- Si mon PWM > CAN,  chaque interruption Timer, je diminue de 1 mes bits de poids faible de mon PWM
 (en tout 6 bits donc 2^6 cycles minimum)
- Si mon CAN = 0, je mets  0 mes 6 bits de poids faible de mon PWM (en tout 6 bits donc 2^6 cycles minimum)
- Si mon CAN = 255, je mets  1 mes 6 bits de poids faible de mon PWM (en tout 6 bits donc 2^6 cycles minimum)

Le but tant d'avoir une courbe linaire sur ma PWM, peu importe  quelle vitesse je fais varier
 mon potentiomtre en entre (entre CAN).
*/




 /*  HARDWARE
 =========== HARDWARE ====================
27 pf  Q=20Mhz 27pF
Interface 2T pour liaison UART TTL <-> RS232 38400 bauds
LCD 2x16 cars

PIC 18F46K22  40 pins DIP
PortB
 RB0  33   input for IRC5 en interrupt TSOP1736 
 RB1  34  
 RB2  23  
 RB3  24
 RB4  25  
 RB5  26
 RB6  27  ICSP_Clck   Bleu fonc    Pin5 Pickit2
 RB7  28  ICSP_Data   Bleu clair    Pin4 Pickit2
  

PORTA
 RA0   2  Analog Input
 RA1   3  Analog Input
 RA2   4  Analog Input
 RA3   5  input
 RA4   6  Output .. Led .. 390 ohms +5V
 RA5   7  Output
 RA6   8  ----- Quartz 20Mhz   C=22pF -- Gnd
 RA7   9  ------ Quartz ---    C=22pF -- Gnd

PORTC
 RC0   15
 RC1   16
 RC2   17
 RC3   18
 RC4   23  CTRL     5_LCD    RS_PIN LCD 
 RC5   24  CTRL     7_Enable  E_PIN LCD
 RC6   25  TX  RS232   UART1 Harware
 RC7   26  RX  RS232   UART1 Hardware

PORTD
 RD0   19   
 RD1   20
 RD2   21
 RD3   22
 RD4   27   DATA    13_D4 LCD
 RD5   28   DATA    14_D5 LCD
 RD6   29   DATA    15_D6 LCD
 RD7   30   DATA    16_D7 LCD
       DATAS   7_D0_LCD ..10_LCD_D3  ...to Gnd
        1_LCD   Gnd power
        2_LCD   +5V power
        3_LCD   R=390 to Gnd

PORTE
 RE0   8
 RE1   9
 RE2   10
 RE3   1   MCLR via Rserie=1K to  R=2,7K to +5V et C=100nF to Gnd  diode//2,7K
      1   --- jaune -- VPP/MCLR ---  pin1 Pickit2
 VSS  12  ---- blanc ------Gnd-----  pin3 Pickit2
 VSS  12  ----  GND Power
 VSS  31  ----  GND Power
 VDD  11  ----  +5V Power
 VDD  32  ----  +5V Power

====================================================
*/





#include "stdio.h"   // pour fonction fprintf
#include <stdlib.h>
#include <delays.h>
#include <string.h>
#include <usart.h>   // pour fonctions UART
#include <adc.h>
#include <ctype.h>
#include <portb.h>
#include <timers.h>
#include <math.h>


#include "../_common/p18f46k22_.h"

#ifdef OSCILLATEUR_INTERNE
#pragma config FOSC = INTIO67, FCMEN = OFF, PLLCFG=OFF            // CONFIG1H
#else
//#pragma config FOSC = HSHP, PLLCFG=OFF, PRICLKEN=ON ,FCMEN=OFF   // High Power for Q>=16Mhz
#pragma config FOSC = HSMP, PLLCFG=OFF, PRICLKEN=ON ,FCMEN=OFF    // Medium power for Q=10Mhz
#endif 
      
#pragma config IESO=OFF,PWRTEN=OFF,BOREN=OFF,WDTEN=OFF,CCP2MX=PORTC1        
#pragma config PBADEN=OFF,CCP3MX=PORTE0,T3CMX=PORTC0,P2BMX=PORTC0
#pragma config MCLRE=EXTMCLR,STVREN=OFF,LVP=ON,XINST=OFF,DEBUG=OFF
#pragma config CP0 = OFF, CP1 = OFF, CP2 = OFF, CP3 = OFF                    // CONFIG5L
#pragma config CPB = OFF, CPD = OFF                                          // CONFIG5H
#pragma config WRT0 = OFF, WRT1 = OFF, WRT2 = OFF, WRT3 = OFF                // CONFIG6L
#pragma config WRTB = OFF, WRTC = OFF, WRTD = OFF                            // CONFIG6H
#pragma config EBTR0 = OFF, EBTR1 = OFF, EBTR2 = OFF, EBTR3 = OFF            // CONFIG7L
#pragma config EBTRB = OFF                                                   // CONFIG7H




#define DureeCycle 2 // * 2 diziemes de secondes =>0.20sec

#define CLS 12
#define BS 8
#define TAB 9
#define CR 13
#define LF 10
#define Bell 7
#define ON 0	// logique inverse avec led tiree au +5V
#define OFF 1

#define Led_Rouge    PORTAbits.RA4
#define Allume 0
#define Eteint 1
#define MAX_LEN	80		// taille buffer
#define  Byte unsigned char


/*	Variables globales */
unsigned int count;
char Texte[MAX_LEN]; 
char *txt;
unsigned char Entree[17]="1234567890123456";
unsigned char *valtxt;
char buffer[40]="00000000000000000000000";	// buffer de reception 
char received;
char *ptlec;		// pointeur de lecture 
char *ptecr;		// pointeur d'ecriture 
unsigned int CptCars;
unsigned int SaisieOk;
//unsigned char Drapeaux ;     // 8 flags
struct chbits {
                 unsigned running:1;
                 unsigned standby:1;
                 unsigned elligible:1;
                 unsigned Accumule:1;
                 unsigned Blc:1;
                 unsigned OneShot:1;
                 unsigned Fill:1;
                 unsigned Lcd:1;
               } Drapeaux;

#define OUT_RS232 Drapeaux.Lcd=0;
#define OUT_LCD Drapeaux.Lcd=1;

#define HI(x)     ((unsigned int)(((x))&0xFF00)>>8)
#define LO(x)     ((unsigned int)((x)&0x00FF))
#define _XTAL_FREQ 10000000


unsigned int TimeEcoule;
Byte receive;
char error;
char EtatCf;
signed char Ve;
unsigned int  NbMes;
Byte Allume_led;
Byte Dummy;
unsigned int i,j,k,l ;
unsigned char s_count = 0;
unsigned int M,MV;
unsigned int INT_TEMP;      // temperature interne via diode

volatile unsigned int result_conv;
volatile unsigned int compte;
volatile unsigned int inter_Timer2 ;
unsigned int moyenne;
unsigned int Old_Moyenne ;
unsigned int PWM_Val_6 ;
unsigned int PWM_Val14 ;
unsigned char PDC0H,PDC0L ;

/*#pragma udata GrosseBank    // regroupe les banks 5 a 9
unsigned char Mapping[512];// 768
#pragma udata
*/
rom const char chaine0[]="...";
rom const char chaine1[]="Port comm 192000 ouvert ... String en ROM \r\n";
rom const char chaine2[]="C18: 18F46K22_UART1_ADC_Rampe_test.c\r\n";
rom const char chaine3[]="ESC pour sortir\r";
rom const char chaine4[]="J= ";
rom char *RS_Str[]={chaine0,chaine1,chaine2,chaine3,chaine4 };


#pragma romdata EEP_=0xF00000

rom unsigned char EEPROM_data [][32] ={
      //   1234567890123456789012345678901
          "Projet:18F46K22_test_rampe.mcp\r",//0  avec terminateur zero
          Version,"            \r",//20 avec terminateur zero
          "Port Com 19200bds & Init HARD.\r",//40  avec terminateur zero 
          "Boucle en 1 Sec   <ESC> exit  \r",//60  avec terminateur zero
          "Avec UART1 HARDWARE.......... \r",//80  avec terminateur zero
          "paulfjujo@free.fr        \r\n",//A0   sans terminateur zero
          "MPLAB IDE V8.91  \r\n", 
          "C18 v3.37.01   \r\n",0  
          };
#pragma romdata

//--------- RS232 UART HARDWARE --------------

void Init_UART1(void);
int PutStrR_RS(rom char *s);
int PutStr_RS(unsigned char *s);
void Put_RS(unsigned char untel);
void CRLF();
void Write_Word(unsigned int M,char Sign);
void fltToa (float x, unsigned char *str,char precision);
void print_flt(float W,int NbDeci,char Bold);
void Decompile_byte(Byte un);
void Octet2Hex(unsigned char number);
void Tempo(long val);
void Remplis_N_blancs(Byte N);
void Print_Decompose_32bits (void);
void Init_Hardware(void) ;
void Init_Timer1(void);
void Init_Timer0(void);
void Init_ADC(void);

//---- EEPROM PIC de 1024 bytes !!!
unsigned char EEPROM_Lect(unsigned int AdrL) ;
void EEPROM_Ecr(unsigned int AdrE,unsigned char car);
void Save_Msg_To_EEPROM(unsigned int * adrx, unsigned char * ptr1);
void PrintOut_Eeprom_Msg(unsigned int PtrE, int Modulo);
  
void InterruptHandlerHigh (void);
void InterruptHandlerLow (void);

//gestionnaire d'interruption
//------------------------------
// High priority interrupt vector
#pragma code InterruptVectorHigh = 0x08
void InterruptVectorHigh (void)
{
  _asm
    goto InterruptHandlerHigh //jump to interrupt routine
  _endasm
}


// High priority interrupt routine
#pragma code
#pragma interrupt InterruptHandlerHigh
void InterruptHandlerHigh ()
{
  static char i ; // doit tre statique pour conserver sa valeur entre les IT
  char C ;

 if ((PIR1bits.ADIF == 1) && ( PIE1bits.ADIE ==1))// Si conversion termine
   {
       result_conv=result_conv + (int) ADRESH;
       compte++;
       // pour test only
       // Put_RS('.');
       if(compte < 16)
       {
         ADCON0bits.GO = 1; // On lance une conversion 
         }
       else
         PIE1bits.ADIE = 0; 
     
     PIR1bits.ADIF = 0; // On rintialise ADIF
   }

 if ((PIR1bits.TMR2IF == 1) && (PIE1bits.TMR2IE ==1))
   {
       inter_Timer2 = 1;
       PIR1bits.TMR2IF = 0;
   }
/*
//======== SERIAL======================
if(PIR1bits.RCIF) // si un car arrive
   {
   C =Read1USART(); // le lire => RAZ  RCIF
   if(RCSTAbits.FERR || RCSTAbits.OERR)
     {
      RCSTAbits.CREN = 0 ; RCSTAbits.CREN= 1 ;
     }
    while(Busy1USART()); // par scurit
    if (PORTBbits.RB1==0) Write1USART(C); // echo
     if( C == BS)
        {
         if(i>0){
             i--;  }
        }
      else {
      if(C != CR && i<MAX_LEN)
      {
        buffer[i++]=C ; // stockage
        }else
        {
         buffer[i]='\0'; // fin de chane si CR
         i=0;
         received =1;
       }
      }
    }
 // ===  Timer1 interrupt ====
   if ((PIR1bits.TMR1IF==1)&&(PIE1bits.TMR1IE==1))
      {
       count ++;
       if (count >= DureeCycle)  // x 0.1S=> XXsec
        {
         count=0;
         TimeEcoule=1;
         // Led_Verte=!Led_Verte;
        }
        WriteTimer1(3035);    // 62500*8*0.2 => 200000S  =0,1sec
       PIR1bits.TMR1IF = 0;
      }
=================*/
}

/*
#pragma

// Low priority interrupt vector
#pragma code InterruptVectorLow = 0x18
void InterruptVectorLow (void)
{
  _asm
    goto InterruptHandlerLow //jump to interrupt routine
  _endasm
}
// Low priority interrupt routine
#pragma code
#pragma interrupt InterruptHandlerLow
void InterruptHandlerLow ()
{
   if (PIR1bits.ADIF == 1) // Si conversion termine
   {
       //result_conv[compte] = ( (int) ADRESH << 2 ); // Rsultat de la conversion sur 8 bits.
       result_conv=result_conv + (int) ADRESH;
       compte++;
       Nop();
       Nop();
       Nop();
       PIR1bits.ADIF = 0; // On rintialise ADIF
       ADCON0bits.GO = 1; // On lance une conversion
   }
} // fin de routine Low interrupts
#pragma
*/

void Init_UART1(void)
{
// voir para 18.5 spec sheet DS41159B page 186
Open1USART( USART_TX_INT_OFF &
USART_RX_INT_ON &
USART_ASYNCH_MODE &
USART_EIGHT_BIT &
USART_SINGLE_RX &  
//USART_CONT_RX &
//USART_BRGH_HIGH,10  // 115200 bds @ 20Mhz 
//USART_BRGH_HIGH,10  // 57600 bds @ 10Mhz 
//USART_BRGH_HIGH,32  // 38400 bds @20Mhz 
USART_BRGH_HIGH,32  // 19200Bd a 10Mhz 

);
IPR1bits.RC1IP=1;  // high priority for UART
RCONbits.IPEN = 1;     // Enable High interrupt priority model.
PIE1bits.RC1IE = 0;
INTCONbits.PEIE = 0 ; // autorisation des IT des priphriques
}


int PutStrR_RS(rom char *s)
{
	int n;
	for (n = 0; *s; n++, s++)
	{
       	Put_RS(*s);
     	}
	return n;
}


int PutStr_RS(unsigned char *s)
{
	int n;
	for (n = 0; *s; n++, s++)
	{
       	Put_RS(*s);
     	}
	return n;
}

void Put_RS(unsigned char untel)
{
   	while(Busy1USART());
   	Write1USART(untel);
}






void CRLF()
{
  Put_RS(CR);  Put_RS(LF);
  }

void Write_Word(unsigned int M,char Sign)
{
unsigned int i,k,l;
unsigned long M1;
 valtxt=&Entree[0];
 if (Sign>1) return;
 if (Sign==0)
  {       M1=(long)M;
        ultoa(M1,valtxt);
  }
  else itoa(M,valtxt);
 if (Drapeaux.Fill==1)
 {
  k=strlen(Entree);
  for (i=0;i<k;i++) Entree[4+Sign-i]=Entree[k-i-1];
  for (i=0;i<(5+Sign-k);i++)
  {
  if (Drapeaux.Blc==1) Entree[i]='0'; else Entree[i]=' ';}
 }
 Entree[5+Sign]=0;
// #ifdef Nokia3310
// if (Drapeaux.Lcd) Nokia_PutRamString(valtxt); else k=PutStr_RS(valtxt);
// #else
  PutStr_RS(valtxt);     
// #endif 
}

void fltToa (float x, unsigned char *str,char precision)
{
/* converts a floating point number to an ascii string */
/* x is stored into str, which should be at least 30 chars long */
unsigned char *adpt;
int ie, i, k, ndig;
double y;
adpt=str;
ndig = ( precision<=0) ? 7 : (precision > 22 ? 23 : precision+1);
ie = 0;
/* if x negative, write minus and reverse */
if ( x < 0)
  {
  *str++ = '-';
  x = -x;
  }
/* put x in range 1 <= x < 10 */
if (x > 0.0) while (x < 1.0)
  {
  x *= 10.0;		// a la place de =*
  ie--;
  }
while (x >= 10.0)
  {
  x = x/10.0;
  ie++;
 }
 ndig += ie;				// a la place de =+
//round. x is between 1 and 10 and ndig will be printed to
// right of decimal point so rounding is ...
for (y = i = 1; i < ndig; i++)
  y = y/10.;
x += y/2.;
if (x >= 10.0) {x = 1.0; ie++;}
if (ie<0)
  {
   *str++ = '0'; *str++ = '.';
   if (ndig < 0) ie = ie-ndig;
   for (i = -1; i > ie; i--)  *str++ = '0';
  }
for (i=0; i < ndig; i++)
  {
  k = x;
  *str++ = k + '0';
  if (i ==  ie ) *str++ = '.';
  x -= (y=k);
  x *= 10.0;
  }
*str = '\0';
//return (adpt);
}

void print_flt(float W,int NbDeci,char Bold)
{long lWhole;
 unsigned int ulPart;
 Drapeaux.Fill=0;
 lWhole=(long)(W);
 ulPart=(unsigned int)((W*(float)NbDeci)-(float)(lWhole*NbDeci));
 ultoa(lWhole,&Texte[0]);
 #ifdef LCD
 if (Drapeaux.Lcd) LCD_PutRamString(Texte);else k=PutStr_RS(Texte);
 if (Drapeaux.Lcd) LCD_Put('.'); else  Put_RS('.');
 #else
 PutStr_RS(Texte);
 Put_RS('.');
 #endif
  Write_Word(ulPart,0);
}

void Decompile_byte(Byte un) {
Byte masque;
  masque = 0x80;
  while (masque > 0u )
 { 
  #ifdef LCD
   if (un & masque)
      if (Drapeaux.Lcd) LCD_Put(49u);  else Put_RS(49u);  //  '1'
    else
       if (Drapeaux.Lcd)LCD_Put(48u);   Put_RS(48u);  //  '0'
    masque =masque >>1;
     }
  #else
    if (un & masque)
      Put_RS(49u);  //  '1'
    else
       Put_RS(48u);  //  '0'
   	 masque =masque >>1;
     }
 #endif

 }

void Octet2Hex(unsigned char number)
{
char high,low;
  // high nibble
  high = ((number & 0xF0) >> 4) + 48; // + '0'
  if (high > '9')
    high =high + 7;
 // low nibble
  low = (number & 0x0F) + 48;        // +'0' low nibble
  if (low > '9')  low += 7;          // '9'= 57u
#ifdef LCD
  if (Drapeaux.Lcd) LCD_Put(high); else Put_RS(high);
  if (Drapeaux.Lcd) LCD_Put(low); else Put_RS(low);
  if (Drapeaux.Lcd) LCD_Put('h'); else Put_RS('h');
#else
 Put_RS(high);
 Put_RS(low);
 Put_RS('h');
#endif
 }

void Tempo(long val)
{
while(val>0){val--;}
}

void Remplis_N_blancs(Byte N)
{int i;
 for (i=0;i<N;i++)
 {
  Put_RS(' ');
 }
}



//------  EEPROM  PIC 18FX6K22  1024 bytes !!------------

unsigned char EEPROM_Lect(unsigned int AdrL) 
{ 
    EEADR =(unsigned char)(AdrL&0x00FF);
    EEADRH =(unsigned char) ((AdrL>>8)& 0x03);   //Bits 3-7 are masked off since EEPROM is only 1KB
//	EEADR=(Hi)AdrL;
//	EEADR=(low)AdrL;
	EECON1bits.EEPGD=0;     // 0= adressage EEPROM
	EECON1bits.CFGS=0;      // 0= acces data EEPROM
	EECON1bits.RD=1;        // arme Lecture EEprom
	 Tempo(1000L);
	return(EEDATA);
}

void EEPROM_Ecr(unsigned int AdrE,unsigned char car) // ecrit  a l'adresse adrE
{int dr;
    
    EEADRH = ((AdrE>>8)&0x03);   //Bits 2-7 are masked off since EEPROM is only 1KB
    EEADR =(AdrE &0xFF);
	EEDATA=car;
	EECON1bits.EEPGD=0;
	EECON1bits.WREN=1;            // autorise ecriture EEPROM
	EECON1bits.CFGS =0;
  if(INTCONbits.GIE ==1)
    {
    INTCONbits.GIE =0 ;
    dr=1;
    }
	EECON2=0x55;
	EECON2=0xAA;
	EECON1bits.WR=1;
	while (PIR2bits.EEIF==0);
	PIR2bits.EEIF=0;
	EECON1bits.WREN=0;
	if (dr==1)INTCONbits.GIE =1;
}

void Save_Msg_To_EEPROM(unsigned int * adrx, unsigned char * ptr1)
{
	while (*ptr1) EEPROM_Ecr(adrx++,*ptr1++);
}

void PrintOut_Eeprom_Msg(unsigned int PtrE, int Modulo)
{ 
  int i,j;
  if(Modulo==0)PtrE=(PtrE<<4)+0x0200;  // numero Msg *16 
  if(Modulo==1)PtrE=(PtrE<<5) ; // modulo 32
  j=0;
  do
  {
  if ( PtrE >1023) break;
  i = (int)EEPROM_Lect(PtrE);
  if ( i==0) break;
  Put_RS((Byte)i);
  PtrE++;j++;
  if ((Modulo==0)&& (j>15)) break;  // msg cadres sur 16 bytes !!
  if ((Modulo==1)&& (j>31)) break;  // msg cadres sur 32 bytes !!
  }
  while (i!=0)  ;
 Tempo(100L);
}



void Init_Hardware()
 {   
   PMD0bits.UART2MD=1;  // USART2 disabled
   PMD0bits.UART1MD=0;
   PMD0bits.TMR6MD=1;   // Timer6 disable
   PMD0bits.TMR5MD=1;   // Timer5 disable
   PMD0bits.TMR4MD=1;   // Timer4 disable
   PMD0bits.TMR3MD=1;   // Timer3 disable
   PMD0bits.TMR2MD=0;   // Timer2 Enable
   PMD0bits.TMR1MD=0;   // Timer1 Enable
  
   PMD1bits.MSSP2MD=1;   // MSSP2 disabled
   PMD1bits.MSSP1MD=1;   // MSSP1 disabled
   PMD1bits.CCP5MD=1;   // Disabled
   PMD1bits.CCP4MD=1;   // Disabled
   PMD1bits.CCP3MD=1;   // Disabled
   PMD1bits.CCP2MD=0;   // Enabled
   PMD1bits.CCP1MD=0;   // Enabled

   PMD2bits.CTMUMD=1;   // Disabled
   PMD2bits.CMP2MD=1;   // Disabled   
   PMD2bits.CMP1MD=1;   // Disabled      
   PMD2bits.ADCMD=0;    // Enable      
              
   ANSELB=0;              // No analog input,PortB digital 
   PORTB = 0xFF;
   TRISB = 0x00;
  /*
   TRISBbits.TRISB0=1;   	// B0 <- IR input
   TRISBbits.TRISB1=1;   	// B1 input for debug echo reception
   TRISBbits.TRISB2=0;   	// B2 led
   TRISBbits.TRISB3=1;		// B3 not used
   TRISBbits.TRISB4=1;		// B4 not used
   TRISBbits.TRISB5=1;		// B5 not used
   TRISBbits.TRISB6=1;      // B6 not used
   TRISBbits.TRISB7=1;      // B7 not used
   */
   WPUB=0x02;               // any pin pull up
   INTCON2bits.RBPU=0;      // enable Pull-up

      // ATTENTION a l'ordre des canaux ANALOGIQUES !!!
  ANSELA=0;   
  ANSELAbits.ANSA0=1;    //  analog input on Port A   voir page 154
  ANSELAbits.ANSA1=1; 
  ANSELAbits.ANSA2=1; 
  TRISA = 0b00001111 ;   // PORTA is RA0,1,2,= analog input  RA3=input,4,5=Digital output
  LATA = 0x00;

  PORTC = 0xFF;          // set PORTC to $FF
  ANSELC=0; 
  TRISC = 0b10000000;    // all output expect RC7
  TRISCbits.TRISC0 = 0;
  TRISCbits.TRISC1 = 0;
  TRISCbits.TRISC2 = 0;
  TRISCbits.TRISC3 = 0;
  TRISCbits.TRISC4 = 0;  // R/S LCD
  TRISCbits.TRISC5 = 0;  // EN LCD
  TRISCbits.TRISC6 = 0;  // TX - Set as Output UART RS232 and Bootloader
  TRISCbits.TRISC7 = 1;  // RX - Set Receive pin for UART RS232 and Bootloader
  
  ANSELD=0;
  TRISD=0;              // all outputs
  ANSELE=0;
  
  RCONbits.IPEN=1   ; // enable priority levels
  RCONbits.SBOREN=0;  //  BOR disbled
  
  SLRCON=0; // standard rate for PORTA,B,C,D,E
 }


void Init_ADC()
 {
       //config lecture ADC 10 bits
 ADCON0bits.ADON=1;      // ADC enabled chanel 0
 ADCON1bits.TRIGSEL=0 ; // trigger from CCP5
 ADCON2bits.ADFM=1;     // right justified
 ADCON2bits.ACQT2=1;
 ADCON2bits.ACQT1=1;
 ADCON2bits.ACQT0=0;    // 16 TAD
 ADCON2bits.ADCS1=1;    // select RA0 = analog input
 ADCON2bits.ADCS2=0;    // RA1 = Analog input
 ADCON2bits.ADCS0=0;    // Fosc/32
 ADCON1bits.PVCFG1=0;   // +Vref = +5V AVdd
 ADCON1bits.PVCFG0=0;
 ADCON1bits.NVCFG1=0;   // -Vref = Gnd AVss
 ADCON1bits.NVCFG0=0;
 }

 unsigned int Mesure_ADC(int j) // utilise buffer pointe par txt
{
  unsigned int M0;
  ADCON0=1 + (j<<2);   // ADON=1 et choix de canal
  Delay10TCYx( 10 ); // Delay for 100TCY
  ConvertADC(); // Start conversion
  while( BusyADC() );
  M0 = ReadADC(); // Read result
  return (M0);
}

void Init_Timer1()
{
 //--- init timer
 //see PIC18F25K22_46K22_41412E.pdf  12.13 page 172
  T1CONbits.TMR1CS1=0;
  T1CONbits.TMR1CS0=0; // clock source= Fosc/4
  T1CONbits.T1CKPS1=1;
  T1CONbits.T1CKPS0=1; // prescaler =1/8
  T1CONbits.T1SOSCEN=0; // Secondary Oscillator Disabled
  T1CONbits.T1SYNC=0;   // Synchro extern clock input with Fosc  (ignore)
  T1CONbits.T1RD16=1 ;  // Mode 16 bits
  T1CONbits.TMR1ON=0;   // Stop timer1
  //---
  T1GCONbits.TMR1GE=0;  // allways count if TMR1ON=1
  T1GCONbits.T1GTM=0;   // Toogle Gate mode disabled
  T1GCONbits.T1GSS1=0;  // Timer1 gate pin
  T1GCONbits.T1GSS0=0; 
  //----
  IPR1bits.TMR1IP=1;      // set hihh priority for Timer1
  RCONbits.IPEN = 1;      // Enable High interrupt priority model.
  WriteTimer1(3035);      // 62500*8*4*0.1 => 200000S  =0,2sec
  PIR1bits.TMR1IF=0;      // raz flag interrupt
  INTCONbits.PEIE = 0;    // enable interupt Peripheriques
  T1CONbits.TMR1ON=0;     // desactive Timer1
  PIE1bits.TMR1IE=0;      // Enable Interrupt Timer1
  INTCONbits.GIE = 0;     // active global interrupt
  INTCONbits.GIEL=0;      // active les priorites  (par8 page 79 docu PIC18Fxx8)
 
}

void  Diode_Temper()
{

// Initialize CTMU 
CTMUICON = 0b00000010; // use x10 base current 
//CTMUCONHbits.CTMUEN = 1; // already enabled by "mTouch" 
ADCON0 = 0b01110001; // Enable ADC and connect to Internal diode 
ADCON1 = 0b00001000; // ADC voltage source VREF+ = internal FVR source and VREF- = VSS 
   // using the FVR set at 2.048v with a Vcc of 4.95v 
ADCON2 = 0b00001010; // Fosc/32 and 2_TAD @ 32mHz 
CTMUCONLbits.EDG2STAT = 0; // activate current source 
CTMUCONLbits.EDG1STAT = 1; 
Tempo(1000)  ; //delay_us(40);  // a 40us CTMU setup time before sampling seemed most stable at low current settings 
ADCON0bits.GO = 1; // Start conversion 
while(ADCON0bits.GO); 
CTMUCONLbits.EDG1STAT = 0; // deactivate current source  
INT_TEMP = ADRES; // Read ADC results (inversely proportional to temperature) 
}


void Init_Timer0()
{
 //--- init timer
 //see PIC18F25K22_46K22_41412E.pdf  11.11 page 159
  T0CONbits.PSA=0;   // Timer0 prescaler assigned to Clock
  T0CONbits.T0PS2=1; // 
  T0CONbits.T0PS1=1; //
  T0CONbits.T0PS0=1; // prescler =1/256
  T0CONbits.T0CS=0;     // internal cycle clock 
  T0CONbits.T08BIT=1 ;  // Mode 16 bits
  //----
   WriteTimer0(3035);      // 62500*8*4*0.1 => 200000S  =0,2sec
  INTCONbits.TMR0IF=0;      // raz flag interrupt
  INTCONbits.TMR0IE=0;    // enable interupt Peripheriques
  T0CONbits.TMR0ON=0;     // Stop Timer0 OFF
  INTCONbits.GIE = 0;     // active global interrupt
  INTCONbits.GIEL=0;      // active les priorites  (par8 page 79 docu PIC18Fxx8)
}


void config_CAN (void)
{
  /*
    TRISAbits.TRISA3 = 1;
    ANSEL0bits.ANS3 = 1;
    ADCON0 = 0x2D;
    ADCON1 = 0x00;
    ADCON2 = 0x36;
    ADCHSbits.GDSEL1 = 0; //AN3
    ADCHSbits.GDSEL0 = 0; //AN3
*/
}

void config_PWM(void)
{
 /*
   PTCON0 = 0;
    PTCON1bits.PTEN = 1;
    PWMCON0bits.PWMEN0 = 1; // PWM1 enabled
    PWMCON0bits.PMOD = 1; // PWM indpendants
    OVDCONDbits.POVD1 = 1; //
    periode_PWM =  4095; //priode de 420S
    PTPERH = periode_PWM >> 8; // On stocke les 4 bits de poids fort dans PTPERH
    PTPERL = periode_PWM; // On masque les 4 bits de poids fort et on stocke les 8 bits de poids faible
*/
}

void config_Timer2 (void)
{
    T2CON = 0x05;
    PR2 = 125; // Periode = 50s
}



void main()
{
 Init_Hardware() ;
 valtxt=&Entree[0];
 Led_Rouge=Allume;
 Drapeaux.Fill=1;
 Drapeaux.Blc=1;
 Init_UART1();
 OUT_RS232
 while(DataRdy1USART())
 {
  Dummy=getc1USART();
  }
 Put_RS(CLS);
 Tempo(200000L);
 // init des pointeurs stockage reception car
 received=0;
 buffer[0]=0;
 Led_Rouge=Eteint;
 CptCars=0;
 count=0;
 CRLF();
 Led_Rouge=Allume;
 
 // PutStr_R("\r\nLIGNE DE TEST \r\n");

 PrintOut_Eeprom_Msg(0x0000,1); 
 
 PrintOut_Eeprom_Msg(0x0020,1); 
 txt=&Texte[0];
 strcpypgm2ram(txt,RS_Str[2]);
 PutStr_RS(txt);
 Tempo(100000L) ;
 
 PrintOut_Eeprom_Msg(0x0040,1); 
 PrintOut_Eeprom_Msg(0x0060,1);   
 PrintOut_Eeprom_Msg(0x0080,1);  

 CRLF();
 Led_Rouge=Eteint;
 Tempo(1000L) ;
 Led_Rouge=!Led_Rouge;

    RCONbits.IPEN = 1; // On active les priorits des interruptions
    INTCONbits.PEIE = 1; //Active les interruptions priphriques
   
    IPR1bits.TMR2IP = 1; // TMR2 to PR2 Match Interrupt High Priority
  //  IPR1bits.ADIP = 0; // A/D Converter Interrupt Low Priority
   IPR1bits.ADIP = 1; // A/D Converter Interrupt high Priority
   PIE1bits.TMR2IE = 0; // Disable the TMR2 to PR2 match interrupt

   Init_ADC(); //config_CAN();
   ADCON2bits.ADFM=0;     // left justified
   PIE1bits.ADIE = 1; // Active les interrutpions de l'AD
   //config_PWM();
   //config_Timer2();
	compte=0;
	moyenne=0;
	Old_Moyenne=0;
    PDC0H = (unsigned char)(moyenne>>2); 
    PDC0L = (unsigned char) (Old_Moyenne & 0x0003) << 6;  
  	PWM_Val_6 = 0  ;// Consigne PWM sur 6bits
  	PWM_Val14= 0  ;// Consigne PWM sur 14bits
  	INTCONbits.GIE = 1; // Active les interruptions
    ADCON0bits.GO = 1; // On lance une conversion
    compte = 0;
    moyenne = 0;
    
   result_conv = 0;
    PIE1bits.ADIE = 1; // rActive les interruptions de l'AD
    ADCON0bits.GO = 1;
    
    /*for (i=0;i<16384;i=i+128)
    {
      	PWM_Val14=i;  
        PutStrR_RS("PWM_val_14= ");
          itoa( PWM_Val14,valtxt);PutStr_RS(valtxt);
          CRLF();
    }
    Tempo(200000); 
    */     
    
    while(1)
    { if (compte >= 16)  
            {
                PIE1bits.ADIE = 0; // Dsactive les interruptions de l'AD
                moyenne =result_conv >> 4 ; // Dcalage de 4 bits  droite correspond  division par 16
      			PWM_Val_6 = PDC0L & 0x03f;  // adjustement fin Consigne PWM sur 6 bits
                if (moyenne >Old_Moyenne)  
				{	
					PWM_Val_6++;
		       		PDC0H = (unsigned char)(Old_Moyenne>>2); 
   					PDC0L = (unsigned char) (Old_Moyenne <<6)+ PWM_Val_6 ;
   					if (PDC0L ==0xFF)
   					{
       				PWM_Val_6=0;
       				PDC0H++;PDC0L=0;
       				}	
   					Old_Moyenne= (	PDC0H <<2 )+ (PDC0L>>6);
				}
 				if (moyenne <Old_Moyenne)  
				{
 					PWM_Val_6--;
 					if(PDC0L==0)
 					{
     				PDC0H--;
     				PDC0L=0xFF;
     				PWM_Val_6=0;
     				}	
 					PDC0H = (unsigned char)(Old_Moyenne>>2); 
					PDC0L = (unsigned char) (Old_Moyenne <<6)+ PWM_Val_6;
					if (PDC0L ==0x00)
   					{
       				PWM_Val_6=0;
       				PDC0H--;
       				PDC0L=0xFF;
       				}	
                    Old_Moyenne= (	PDC0H <<2 )+ (PDC0L>>6);
                            
				}
				if (moyenne==Old_Moyenne) 
				{
					PWM_Val_6=	0; // Raz partie 6 bits details
					Old_Moyenne=moyenne;
 					PDC0H = (unsigned char)(moyenne>>2); 
   					PDC0L = (unsigned char) (moyenne << 6); 
   					
				}
            // attention , ci dessous ne marche pas !!!??
            //PWM_Val14=(unsigned int)PDC0H << 8 + PDC0L; 
            PWM_Val14=(unsigned int)PDC0H << 8;
            PWM_Val14=PWM_Val14+ PDC0L;
           
                
          //PutStrR_RS("PWM_val6="); Write_Word(PWM_Val_6,0);Put_RS(TAB);
          PutStrR_RS("moy=");
          Write_Word(moyenne,0);Put_RS(TAB);
          //Octet2Hex(moyenne);Put_RS(TAB);
          PutStrR_RS("OldMoy=");
          //Octet2Hex(Old_Moyenne);Put_RS(TAB);
          Write_Word(Old_Moyenne,0);Put_RS(TAB);
          PutStrR_RS("PWM_val14= ");
          itoa( PWM_Val14,valtxt);
          PutStr_RS(valtxt);
          //  Write_Word(PWM_Val_14,0);
          //Put_RS(TAB);
          //PutStrR_RS("PDC0 H et L=");Decompile_byte(PDC0H );Put_RS(' ');  Decompile_byte(	PDC0L );
          CRLF();
 		  
  		  compte = 0;
	      result_conv = 0;
          PIE1bits.ADIE = 1; // rActive les interruptions de l'AD
           ADCON0bits.GO = 1;
         }     
         Tempo(1000);   // eventuel ralentissement de la boucle
       }// while
   
}

/*
----------------------------------------------------------------------
Release build of project `C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_test_Rampe.mcp' started.
Language tool versions: MPASMWIN.exe v5.50, mplink.exe v4.48, mcc18.exe v3.46, mplib.exe v4.48
Fri Nov 14 16:30:44 2014
----------------------------------------------------------------------
Clean: Deleting intermediary and output files.
Clean: Deleted file "C:\_C18\tmp\18F46K22_UART1_ADC_Rampe_test.o".
Clean: Deleted file "C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_test_Rampe.cof".
Clean: Deleted file "C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_test_Rampe.hex".
Clean: Deleted file "C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_test_Rampe.map".
Clean: Done.
Executing: "C:\Program Files (x86)\Microchip\mplabc18\v3.46\bin\mcc18.exe" -p=18F46K22 /i"C:\Program Files (x86)\Microchip\mplabc18\v3.46\h" -I"C:\_C18\_MesProjets_C18\_common" "18F46K22_UART1_ADC_Rampe_test.c" -fo="C:\_C18\tmp\18F46K22_UART1_ADC_Rampe_test.o" -Oi -O-
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:374:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:383:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:388:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:388:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:399:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:401:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:404:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:414:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:482:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:501:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:503:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:525:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:526:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:527:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:540:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:578:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:588:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:814:Warning [2054] suspicious pointer conversion
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:829:Warning [2066] type qualifier mismatch in assignment
C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_UART1_ADC_Rampe_test.c:851:Warning [2058] call of function without prototype
Executing: "C:\Program Files (x86)\Microchip\mplabc18\v3.46\bin\mplink.exe" /p18F46K22 /l"C:\Program Files (x86)\Microchip\mplabc18\v3.46\lib" /k"C:\Program Files (x86)\Microchip\mplabc18\v3.46\bin\LKR" /k"C:\_C18\_MesProjets_C18\_common" "..\..\tmp\18F46K22_UART1_ADC_Rampe_test.o" /u_CRUNTIME /z__MPLAB_BUILD=1 /m"C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_test_Rampe.map" /w /o"C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_test_Rampe.cof"
MPLINK 4.48, Linker
Device Database Version 1.13
Copyright (c) 1998-2011 Microchip Technology Inc.
Errors    : 0

MP2HEX 4.48, COFF to HEX File Converter
Copyright (c) 1998-2011 Microchip Technology Inc.
Errors    : 0

Loaded C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_test_Rampe.cof.
----------------------------------------------------------------------
Release build of project `C:\_C18\_MesProjets_C18\_18F46K22\18F46K22_test_Rampe.mcp' succeeded.
Language tool versions: MPASMWIN.exe v5.50, mplink.exe v4.48, mcc18.exe v3.46, mplib.exe v4.48
Fri Nov 14 16:30:45 2014
----------------------------------------------------------------------
BUILD SUCCEEDED

*/