/*******************************
Gilles Jean-Marie
 12.12.2014
Tlcommande Infrarouge
PIC16F628
 -----------------------------
 RA0-7 = interrupteur
 RB1 = Power LED
 RB2 = Temoin signal
 RB3 = PWM modulation alim LED IR
 RB5 = Envoie du signale
********************************/

// Dfinition des tableaux BIT pour envoie
// inverser par apport au recepteur
char bt[][26] = {{0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,0,1,0,1},
{0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,0,1,0,1},
{0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,0,1}
};

short int i; // initialisation boucle
int presser = 99;  // initialisation du bouton presser


// PROGRAMME PRINCIPALE
void main(void)
{
  // Initialisation de PWM ()
  PWM1_Init(38000);     // initialisation PWM 38000Hz
  PWM1_Start();         // dmarrage de PWM
  PWM1_Set_Duty(128);   // Rapport cycle (0-255) 128 = +-50%

  CMCON  = 0x07;   // Disable Comparators
  
// PORT A en entre
 TRISA = 0xf8;
 PORTA = 0x00;
 // PORT B en sortie
 TRISB = 0x00;
// LED temoin PORT RB1 ON
 PORTB.RB1 = 1; // power ON
 
 // Dtection des boutons presser
  while(1)
  {
     PORTA.RA0 = 1;
     if(PORTA.RA4) presser = 0; // bouton 1
     if(PORTA.RA6) presser = 3; // bouton 4
     if(PORTA.RA7) presser = 6; // bouton 7
     PORTA.RA0 = 0;
     
     PORTA.RA1 = 1;
     if(PORTA.RA4) presser = 1; // bouton 2
     if(PORTA.RA6) presser = 4; // bouton 5
     if(PORTA.RA7) presser = 7; // bouton 8
     PORTA.RA1 = 0;
     
     PORTA.RA2 = 1;
     if(PORTA.RA4) presser = 1; // bouton 3
     if(PORTA.RA6) presser = 5; // bouton 6
     if(PORTA.RA7) presser = 8; // bouton 9
     PORTA.RA2 = 0;
     
     PORTA.RA3 = 1;
     if(PORTA.RA4) presser = 9; // bouton +
     if(PORTA.RA6) presser = 10; // bouton -
     if(PORTA.RA7) presser = 11; // bouton x
     PORTA.RA3 = 0;
     
     // Envoie du signal selon la valeur sur RB5
     if(presser != 99)
     {
        PORTB.RB2 = 1;    // Temoin signale  ON
        PORTB.RB3 = 1;    // PWM ON
       for(i=25;i>=0;i--)// boucle sur les 25 bits
       {
           if(bt[presser][i] == 1) // si le bit est a 1
           {
            PORTB.RB5 = 1;
           }// fin if
           else // sinon le bit est a 0
           {
            PORTB.RB5 = 0;
           } // fin condition
            Delay_us(850);; // delai du BIT
        }// fin boucle
        
         delay_ms(100);  // Delai avant envoie d une nouvelle trame de BIT
         PORTB.RB3 = 0;    // PWM OFF
         PORTB.RB2 = 0;    // Temoin signale  OFF


         presser = 99;
         i=25;
     } // fin du signal
  } // fin WHILE
} // fin VOID main