/*******************************
Gilles Jean-Marie
 12.12.2014
Tlcommande Infrarouge
PIC16F628
 -----------------------------
 RA0-7 = interrupteur
 RB1 = Power LED
 RB2 = Temoin signal
 RB3 = PWM modulation alim LED IR
 RB5 = Envoie du signale
********************************/

// Dfinition des tableaux BIT pour envoie
// inverser par apport au recepteur


short int i=0,i2=0; // initialisation boucle
long int presser=0,x=0;  // initialisation du bouton presser
char tab_bits[26] ;

/*char bt[][26] = {{0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,0,1,0,1},
{0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,0,1,0,1},
{0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,0,1}
};*/

// PROGRAMME PRINCIPALE
void main(void)
{
  // Initialisation de PWM ()
  PWM1_Init(38000);     // initialisation PWM 38000Hz
  PWM1_Start();         // dmarrage de PWM
  PWM1_Set_Duty(128);   // Rapport cycle (0-255) 128 = +-50%

  CMCON  = 0x07;   // Disable Comparators

// PORT A en entre
 TRISA = 0xf8;
 PORTA = 0x00;
 // PORT B en sortie
 TRISB = 0x00;
// LED temoin PORT RB1 ON
 RB1_bit = 1; // power ON

 
 // Dtection des boutons presser
  while(1)
  {
     RA0_bit = 1;
     if(RA4_bit == 1) presser = 22173002; // bouton 1
     if(RA6_bit == 1) presser = 23800140; // bouton 4
     if(RA7_bit == 1) presser = 6; // bouton 7
     RA0_bit = 0;

     RA1_bit = 1;
     if(RA4_bit == 1) presser = 1; // bouton 2
     if(RA6_bit == 1) presser = 4; // bouton 5
     if(RA7_bit == 1) presser = 7; // bouton 8
     RA1_bit = 0;

     RA2_bit = 1;
     if(RA4_bit == 1) presser = 1; // bouton 3
     if(RA6_bit == 1) presser = 5; // bouton 6
     if(RA7_bit == 1) presser = 8; // bouton 9
     RA2_bit = 0;

     RA3_bit = 1;
     if(RA4_bit == 1) presser = 9; // bouton +
     if(RA6_bit == 1) presser = 10; // bouton -
     if(RA7_bit == 1) presser = 11; // bouton x
     RA3_bit = 0;


     // Envoie du signal selon la valeur sur RB5
     if(presser != 0)
     {

            // aprs chaque division par deux,
            // quand "dec" est inferieur ou egal  1, on arrete
             for(i2=0;presser>=1;i2++)
            {
              x = (presser % 2);  // on reprend le reste de la division par 2
              tab_bits[i2] = x;  // on incrmente la tableaux du "reste" 1/0
              presser = (presser / 2 );  // on divise le nombre par 2
            }
            

            
        RB2_bit = 1;    // Temoin signale  ON
        RB3_bit = 1;    // PWM ON
       for(i=25;i>0;i--)// boucle sur les 25 bits
       {
           if(tab_bits[i] == 1) // si le bit est a 1
           {
            RB5_bit = 1;
           }// fin if
           else // sinon le bit est a 0
           {
            RB5_bit = 0;
           } // fin condition
            Delay_us(850); // delai du BIT
        }// fin boucle
       RB5_bit = 0; // si on termine par un bit a 1, on remet le port a 0
        
         //i2=0;
         //i=25;

         delay_ms(100);  // Delai avant envoie d une nouvelle trame de BIT
         RB3_bit = 0;    // PWM OFF
         RB2_bit = 0;    // Temoin signale  OFF


     } // fin du signal
  } // fin WHILE
} // fin VOID main