/* 
 * File:   main.c
 * Author: Administrateur
 *
 * Created on 11 fvrier 2015, 17:44
 */



#include <stdio.h>
#include <stdlib.h>
#include <xc.h>

// CONFIG
#pragma config FOSC = INTOSCIO  // Oscillator Selection bits (INTOSC oscillator: I/O function on RA6/OSC2/CLKOUT pin, I/O function on RA7/OSC1/CLKIN)
#pragma config WDTE = OFF       // Watchdog Timer Enable bit (WDT disabled)
#pragma config PWRTE = ON       // Power-up Timer Enable bit (PWRT enabled)
#pragma config MCLRE = OFF      // RA5/MCLR/VPP Pin Function Select bit (RA5/MCLR/VPP pin function is digital input, MCLR internally tied to VDD)
#pragma config BOREN = ON       // Brown-out Detect Enable bit (BOD enabled)
#pragma config LVP = OFF        // Low-Voltage Programming Enable bit (RB4/PGM pin has digital I/O function, HV on MCLR must be used for programming)
#pragma config CPD = OFF        // Data EE Memory Code Protection bit (Data memory code protection off)
#pragma config CP = OFF         // Flash Program Memory Code Protection bit (Code protection off)



/*Macro For Segment Enable Pins*/
#define AFF1 PORTAbits.RA0  //afficheur unit
#define AFF2 PORTAbits.RA1  //afficheur dizaine
#define BP1 PORTAbits.RA2
#define BP2 PORTAbits.RA3

#define _XTAL_FREQ 4000000

void ecr_aff(unsigned char);

void main()
{
    unsigned char cmpt = 0; // Compteur variable
    CMCON = 0b00000111;
    TRISA = 0b11111100; // RA0 et RA1 sortie
    TRISB = 0x00;
    cmpt = eeprom_read (1);
    while(1)
    {
        if (cmpt > 99)
            cmpt = 0; // reset le compteur
            eeprom_write(1, cmpt);

        if (!BP1)
        {
            cmpt++; // incremente le compteur
            eeprom_write(1, cmpt);
            __delay_ms(10);
        }
        if (!BP2)
        {
            cmpt--; // decremente le compteur
            eeprom_write(1, cmpt);
            __delay_ms(10);
        }
        ecr_aff(cmpt);
        
    }
}

/*Function pour ecrire data dans l'afficheur 7 segments*/
void ecr_aff(unsigned char val)
{
    unsigned char const table_aff[]={0x3f,0x06,0x5b,0x4f,0x66,
                            0x6d,0x7d,0x07,0x7f,0x6f};
    long unite,diz;
    long cp = 0;
    unite = val/10;
    diz = val%10;
    for(cp=0;cp<10; cp++)
    {
        PORTB = table_aff[unite];
        AFF1 = 1; // Afficheur 1 ON
        __delay_ms(10);
        AFF1 = 0; // Afficheur 1 OFF
        PORTB = table_aff[diz];
        AFF2 = 1; // Afficheur 2 ON
        __delay_ms(10);
        AFF2 = 0; // Afficheur 2 OFF
    }
}
