/* 
 * File:   config_lcd.h
 * Author: Adiministrateur
 *
 * Created on 25 novembre 2014, 16:29
 */

#ifndef CONFIG_LCD_H
#define	CONFIG_LCD_H
#endif
// Definition des pins du LCD
#define LCD_PORT        LATB                        //PORTB
#define BUSY_PORT       PORTB
#define TRIS_LCD_PORT   TRISB
#define LCD_RW          LATBbits.LATB2             /* PORT for RW */
#define TRIS_LCD_RW     TRISBbits.TRISB2           /* TRIS for RW */
#define LCD_RS          LATBbits.LATB1             /* PORT for RS */
#define TRIS_LCD_RS     TRISBbits.TRISB1           /* TRIS for RS */
#define LCD_E           LATBbits.LATB3             /* PORT for E  */
#define TRIS_LCD_E      TRISBbits.TRISB3           /* TRIS for E  */

/* Display ON/OFF Control defines */
#define DON         0b00001111  /* Display on      */
#define DOFF        0b00001011  /* Display off     */
#define CURSOR_ON   0b00001111  /* Cursor on       */
#define CURSOR_OFF  0b00001101  /* Cursor off      */
#define BLINK_ON    0b00001111  /* Cursor Blink    */
#define BLINK_OFF   0b00001110  /* Cursor No Blink */

/* Cursor or Display Shift defines */
#define SHIFT_CUR_LEFT    0b00000100  /* Cursor shifts to the left   */
#define SHIFT_CUR_RIGHT   0b00000101  /* Cursor shifts to the right  */
#define SHIFT_DISP_LEFT   0b00000110  /* Display shifts to the left  */
#define SHIFT_DISP_RIGHT  0b00000111  /* Display shifts to the right */

/* Function Set defines */
#define FOUR_BIT   0b00101100  /* 4-bit Interface               */
#define EIGHT_BIT  0b00111100  /* 8-bit Interface               */
#define LINE_5X7   0b00110000  /* 5x7 characters, single line   */
#define LINE_5X10  0b00110100  /* 5x10 characters               */
#define LINES_5X7  0b00111000  /* 5x7 characters, multiple line */

#define UPPER

void LCD_Init(void);
void LCD_Cmd(unsigned char command);
//void LCD_Cmd4(unsigned char commande);
void LCD_Write(char Data);
void LCD_Write_Text( char *msg);
void LCD_Write_const(const char *msg);
unsigned char BusyLCD(void);
void PosDDRamAddr(unsigned char DDaddr);
void PosCGRamAddr(unsigned char DDaddr);
extern void DelayFor18TCY(void);
