
#include<xc.h>
#include "config.h"
#include "config_lcd.h"


void LCD_Init(void)
{
    TRIS_LCD_E = 0;
    TRIS_LCD_RW = 0;
    TRIS_LCD_RS = 0;
    __delay_ms(15);
    LCD_Cmd(0b00110000);        //
    __delay_ms(5);
    LCD_Cmd(0b00110000);        //init mode 4bits
    __delay_ms(5);
    LCD_Cmd(0b00110010);        //init mode 4bits
    while( BusyLCD() );
    LCD_Cmd(0x28);              //init mode 4bits
    while( BusyLCD() );
    LCD_Cmd(0x28);              //init mode 4bits
    while( BusyLCD() );
    LCD_Cmd(0x0C);
    while( BusyLCD() );
    LCD_Cmd(0x01);              //efface lcd
    while( BusyLCD() );
    PosDDRamAddr(0x80);
    while( BusyLCD() );
    }
/*--------------------------------------------------------------*/

void LCD_Cmd(unsigned char commande)
{
    #ifdef UPPER
        
        LCD_PORT &= 0x0f;
        LCD_PORT |= (commande&0xf0);
        TRIS_LCD_PORT &= 0x0f;
    #else                                   // Lower nibble interface
        TRIS_LCD_PORT &= 0xf0;
        LCD_PORT &= 0xf0;
        LCD_PORT |= (commande>>4)&0x0f;
    #endif
        LCD_RW = 0;                     // Set control signals for command
        LCD_RS = 0;
        DelayFor18TCY();
        LCD_E = 1;                      // Clock command in
        DelayFor18TCY();
        LCD_E = 0;
    #ifdef UPPER                            // Upper nibble interface
        LCD_PORT &= 0x0f;
        LCD_PORT |= (commande<<4)&0xf0;

    #else                                   // Lower nibble interface
        LCD_PORT &= 0xf0;
        LCD_PORT |= commande&0x0f;
    #endif
        DelayFor18TCY();
        LCD_E = 1;                      // Clock command in
        DelayFor18TCY();
        LCD_E = 0;
    #ifdef UPPER                            // Make data nibble input
        TRIS_LCD_PORT |= 0xf0;
    #else
        TRIS_LCD_PORT |= 0x0f;
    #endif
}
/*--------------------------------------------------------------*/
void LCD_Write(char Data)
{
    
    #ifdef UPPER                            // Upper nibble interface
     TRIS_LCD_PORT &= 0x0f;
        LCD_PORT &= 0x0f;
        LCD_PORT |= Data&0xf0;
    #else                                   // Lower nibble interface
        TRIS_LCD_PORT &= 0xf0;
        LCD_PORT &= 0xf0;
        LCD_PORT |= ((Data>>4)&0x0f);
    #endif

        LCD_RS = 1;                     // Set control bits
        LCD_RW = 0;
        DelayFor18TCY();
        LCD_E = 1;                      // Clock nibble into LCD
        DelayFor18TCY();
        LCD_E = 0;
    #ifdef UPPER                            // Upper nibble interface
        LCD_PORT &= 0x0f;
        LCD_PORT |= ((Data<<4)&0xf0);
    #else                                   // Lower nibble interface
        LCD_PORT &= 0xf0;
        LCD_PORT |= (Data&0x0f);
    #endif
        DelayFor18TCY();
        LCD_E = 1;                      // Clock nibble into LCD
        DelayFor18TCY();
        LCD_E = 0;
    #ifdef UPPER                            // Upper nibble interface
        TRIS_LCD_PORT |= 0xf0;
    #else                                   // Lower nibble interface
        TRIS_LCD_PORT |= 0x0f;
    #endif
}
/*--------------------------------------------------------------*/
void LCD_Write_Text( char *msg)
{
    while(*msg)
    {
        while( BusyLCD() );
        LCD_Write(*msg);
        msg++;
    }
}
/*--------------------------------------------------------------*/
void LCD_Write_const(const char *msg)
{
    while(*msg)
    {
        //while( BusyLCD() );
        LCD_Write(*msg);
        msg++;
    }
}
/*--------------------------------------------------------------*/
unsigned char BusyLCD(void)
{
    #ifdef UPPER                            // Upper nibble interface
        TRIS_LCD_PORT |= 0xf0;
    #else                                   // Lower nibble interface
        TRIS_LCD_PORT |= 0x0f;
    #endif
    LCD_RW = 1;
    LCD_RS = 0;
    DelayFor18TCY();
    LCD_E = 1;                      // Clock in the command
    DelayFor18TCY();
    
    #ifdef UPPER                            // Upper nibble interface
        if(BUSY_PORT&0x80)
    #else                                   // Lower nibble interface
        if(BUSY_PORT&0x08)
    #endif
        {
                LCD_E = 0;              // Reset clock line
                DelayFor18TCY();
                LCD_E = 1;              // Clock out other nibble
                DelayFor18TCY();
                LCD_E = 0;
                LCD_RW = 0;             // Reset control line
                return 1;               // Return TRUE
        }
        else                            // Busy bit is low
        {
                LCD_E = 0;              // Reset clock line
                DelayFor18TCY();
                LCD_E = 1;              // Clock out other nibble
                DelayFor18TCY();
                LCD_E = 0;
                LCD_RW = 0;             // Reset control line
                return 0;               // Return FALSE
        }
 
}
/*-------------------------------------------------------------------*/
void PosDDRamAddr(unsigned char DDadr)
{
    #ifdef UPPER                                    // Upper nibble  interface
        TRIS_LCD_PORT &= 0x0f;                 // Make port output
        LCD_PORT &= 0x0f;                      // and write upper nibble
        LCD_PORT |= ((DDadr | 0b10000000) & 0xf0);
    #else                                           // Lower nibble interface
        TRIS_LCD_PORT &= 0xf0;                 // Make port output
        LCD_PORT &= 0xf0;                      // and write upper nibble
        LCD_PORT |= (((DDadr | 0b10000000)>>4) & 0x0f);
    #endif
        LCD_RW = 0;                             // Set control bits
        LCD_RS = 0;
        DelayFor18TCY();
        LCD_E = 1;                              // Clock the cmd and address in
        DelayFor18TCY();
        LCD_E = 0;
    #ifdef UPPER                                    // Upper nibble interface
        LCD_PORT &= 0x0f;                      // Write lower nibble
        LCD_PORT |= ((DDadr<<4)&0xf0);
    #else                                           // Lower nibble interface
        LCD_PORT &= 0xf0;                      // Write lower nibble
        LCD_PORT |= (DDadr&0x0f);
    #endif
        DelayFor18TCY();
        LCD_E = 1;                              // Clock the cmd and address in
        DelayFor18TCY();
        LCD_E = 0;
    #ifdef UPPER                                    // Upper nibble interface
        TRIS_LCD_PORT |= 0xf0;                 // Make port input
    #else                                           // Lower nibble interface
        TRIS_LCD_PORT |= 0x0f;                 // Make port input
    #endif
 }
/*-------------------------------------------------------------------*/
void PosCGRamAddr(unsigned char CGadr)
{
    #ifdef UPPER                                    // Upper nibble interface
        TRIS_LCD_PORT &= 0x0f;                 // Make nibble input
        LCD_PORT &= 0x0f;                      // and write upper nibble
        LCD_PORT |= ((CGadr | 0b01000000) & 0xf0);
    #else                                           // Lower nibble interface
        TRIS_LCD_PORT &= 0xf0;                 // Make nibble input
        LCD_PORT &= 0xf0;                      // and write upper nibble
        LCD_PORT |= (((CGadr |0b01000000)>>4) & 0x0f);
    #endif
        LCD_RW = 0;                             // Set control signals
        LCD_RS = 0;
        DelayFor18TCY();
        LCD_E = 1;                              // Clock cmd and address in
        DelayFor18TCY();
        LCD_E = 0;
    #ifdef UPPER                                    // Upper nibble interface
        LCD_PORT &= 0x0f;                      // Write lower nibble
        LCD_PORT |= ((CGadr<<4)&0xf0);
    #else                                           // Lower nibble interface
        LCD_PORT &= 0xf0;                      // Write lower nibble
        LCD_PORT |= (CGadr&0x0f);
    #endif
        DelayFor18TCY();
        LCD_E = 1;                              // Clock cmd and address in
        DelayFor18TCY();
        LCD_E = 0;
    #ifdef UPPER                                    // Upper nibble interface
        TRIS_LCD_PORT |= 0xf0;                 // Make inputs
    #else                                           // Lower nibble interface
        TRIS_LCD_PORT |= 0x0f;                 // Make inputs
    #endif
  
}
/*-------------------------------------------------------------------*/
