//************************************************************************************
//**  
//**  Source name:   C:\Users\Peter\Wallpaper\CodeClavier.fcfx
//**  Title:         
//**  Description:   
//**  Device:        PIC.16F.16F887
//**  
//**  Generated by:  Flowcode v6.1.1.0
//**  Date:          Sunday, March 01, 2015 16:04:30
//**  Users:         0
//**  Registered to: 36986956
//**  Licence key:   VRVJV7
//**  
//**  
//**     POUR UN USAGE NON COMMERCIAL
//**  
//**  http://www.matrixtsl.com
//**  
//************************************************************************************


#define MX_PIC

#define MX_CAL_PIC

#define MX_CLK_SPEED 19660800

#define FCP_NULL Unconnected_Port



#ifdef _BOOSTC
#pragma DATA 0x2007, 0x23E2
#endif
#ifdef HI_TECH_C
__CONFIG(0x23E2);
#endif
#ifdef _BOOSTC
#pragma DATA 0x2008, 0x3EFF
#endif
#ifdef HI_TECH_C
__CONFIG(0x3EFF);
#endif

/*========================================================================*\
   Use :Inclure les dfinitions de type
\*========================================================================*/
#include "C:\Program Files (x86)\Flowcode 6\CAL\internals.c"

MX_UINT8 FCLV_LOOP1;


/*========================================================================*\
   Use :panel
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCVsz_TOUCHEREF 12
#define FCVsz_TOUCHEBIN 12
#define FCVsz_CODETOUCHE 5
#define FCV_FALSE (0)
#define FCV_TRUE (1)
MX_GLOBAL MX_CHAR FCV_TOUCHEREF[FCVsz_TOUCHEREF];
MX_GLOBAL MX_UINT8 FCV_COLONNE;
MX_GLOBAL MX_CHAR FCV_TOUCHEBIN[FCVsz_TOUCHEBIN];
MX_GLOBAL MX_CHAR FCV_CODETOUCHE[FCVsz_CODETOUCHE];
MX_GLOBAL MX_UINT8 FCV_Y;
MX_GLOBAL MX_UINT8 FCV_LIGNE;
MX_GLOBAL MX_UINT8 FCV_TOUCHE;
MX_GLOBAL MX_UINT8 FCV_I;

void FCM_Initialisation();
void FCM_AttribuerTouche();

/*========================================================================*\
   Use :ctrl_lcd
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/

/*========================================================================*\
   Use :LCD
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
void FCD_04071_LCD__Clear();
void FCD_04071_LCD__PrintString(MX_CHAR *FCL_TEXT, MX_UINT16 FCLsz_TEXT);
void FCD_04071_LCD__PrintAscii(MX_UINT8 FCL_CHARACTER);
void FCD_04071_LCD__PrintNumber(MX_SINT16 FCL_NUMBER);
void FCD_04071_LCD__RAMWrite(MX_UINT8 FCL_INDEX, MX_UINT8 FCL_D0, MX_UINT8 FCL_D1, MX_UINT8 FCL_D2, MX_UINT8 FCL_D3, MX_UINT8 FCL_D4, MX_UINT8 FCL_D5, MX_UINT8 FCL_D6, MX_UINT8 FCL_D7);
void FCD_04071_LCD__ClearLine(MX_UINT8 FCL_LINE);
void FCD_04071_LCD__Cursor(MX_UINT8 FCL_X, MX_UINT8 FCL_Y);
void FCD_04071_LCD__Command(MX_UINT8 FCL_INSTRUCTION);
void FCD_04071_LCD__PrintFormattedNumber(MX_UINT32 FCL_NUMBER, MX_BOOL FCL_FORMAT);
void FCD_04071_LCD__ScrollDisplay(MX_UINT8 FCL_POSITION, MX_UINT8 FCL_DIRECTION);
void FCD_04071_LCD__RawSend(MX_UINT8 FCL_DATA, MX_BOOL FCL_TYPE);
void FCD_04071_LCD__Start();

/*========================================================================*\
   Use :lcd_eb005
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCD_0ad31_lcd_eb005__Clear FCD_04071_LCD__Clear
#define FCD_0ad31_lcd_eb005__PrintString FCD_04071_LCD__PrintString
#define FCD_0ad31_lcd_eb005__PrintAscii FCD_04071_LCD__PrintAscii
#define FCD_0ad31_lcd_eb005__PrintNumber FCD_04071_LCD__PrintNumber
#define FCD_0ad31_lcd_eb005__RAMWrite FCD_04071_LCD__RAMWrite
#define FCD_0ad31_lcd_eb005__ClearLine FCD_04071_LCD__ClearLine
#define FCD_0ad31_lcd_eb005__Cursor FCD_04071_LCD__Cursor
#define FCD_0ad31_lcd_eb005__Command FCD_04071_LCD__Command
#define FCD_0ad31_lcd_eb005__PrintFormattedNumber FCD_04071_LCD__PrintFormattedNumber
#define FCD_0ad31_lcd_eb005__ScrollDisplay FCD_04071_LCD__ScrollDisplay
#define FCD_0ad31_lcd_eb005__RawSend FCD_04071_LCD__RawSend
#define FCD_0ad31_lcd_eb005__Start FCD_04071_LCD__Start

/*========================================================================*\
   Use :ButtonCtrl
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/

/*========================================================================*\
   Use :lut
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCVsz_00fb1_lut__FLOATFIXEDLIST 1
#define FCVsz_00fb1_lut__INTLIST 12
#define FCVsz_00fb1_lut__FLOATLIST 1
#define FCVsz_00fb1_lut__INTFIXEDLIST 1
#define FCD_00fb1_lut__INTLIST(ix) FCD_00fb1_lut__INTLIST_LUT[ix]
ROMARRAY_(MX_UINT8) FCD_00fb1_lut__INTLIST_LUT ROMARRAY_E =
{
// Property added elements
  1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0, 11
// Dynamically added elements
 
};


/*========================================================================*\
   Use :keypad_base
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCV_08c31_keypad_base__TRUE (1)

MX_UINT8 FCD_08c31_keypad_base__WaitPressed();
MX_UINT8 FCD_08c31_keypad_base__GetAscii();
void FCD_08c31_keypad_base__GetString(MX_CHAR *FCR_RETVAL, MX_UINT16 FCRsz_RETVAL);
MX_UINT8 FCD_08c31_keypad_base__Prv_GetRow();
MX_UINT8 FCD_08c31_keypad_base__GetNumber();
MX_UINT8 FCD_08c31_keypad_base__GetIndex();
void FCD_08c31_keypad_base__Prv_FloatColumns();
void FCD_08c31_keypad_base__WaitReleased();

/*========================================================================*\
   Use :Inclure la couche d'adaptation de puce
\*========================================================================*/
#include "C:\Program Files (x86)\Flowcode 6\CAL\includes.c"


/*========================================================================*\
   Use :ctrl_lcd
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :LCD
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Clears the entire contents of the display.
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__Clear()
{




	FCD_04071_LCD__RawSend(0x01, 0);

	FCI_DELAYBYTE_MS(2);

	FCD_04071_LCD__RawSend(0x02, 0);

	FCI_DELAYBYTE_MS(2);

}

/*=----------------------------------------------------------------------=*\
   Use :Breaks down a string of text and sends it to the LCD via the private RawSend(byte, mask) macro
       :
       :Param??tres pour la macro PrintString :
       :  Text[20] : Enter the text or variable to print to the LCD
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__PrintString(MX_CHAR *FCL_TEXT, MX_UINT16 FCLsz_TEXT)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_IDX = (0x0);
	MX_UINT8 FCL_COUNT;



	FCL_COUNT = FCI_GETLENGTH(FCL_TEXT, FCLsz_TEXT);

	while (FCL_IDX < FCL_COUNT)
	{

		FCD_04071_LCD__RawSend(FCL_TEXT[FCL_IDX], 0x10);

		FCL_IDX = FCL_IDX + 1;


	}


}

/*=----------------------------------------------------------------------=*\
   Use :Takes the ascii value for a character and prints the character
       :
       :Param??tres pour la macro PrintAscii :
       :  character : Holds an ascii value.
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__PrintAscii(MX_UINT8 FCL_CHARACTER)
{

	FCD_04071_LCD__RawSend(FCL_CHARACTER, 0x10);



}

/*=----------------------------------------------------------------------=*\
   Use :Based on v5 macro, will allow you to print a number. This is limited to a signed-INT, -32768 to 32767
       :
       :Param??tres pour la macro PrintNumber :
       :  Number : Enter the number or variable to print to the LCD
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__PrintNumber(MX_SINT16 FCL_NUMBER)
{
	//Dfinitions des variables locales
	#define FCLsz_S 10
	MX_CHAR FCL_S[FCLsz_S];


	FCI_TOSTRING(FCL_NUMBER, FCL_S,10);

	FCD_04071_LCD__PrintString(FCL_S, FCLsz_S);

	//Dfinitions des variables locales
	#undef FCLsz_S
}

/*=----------------------------------------------------------------------=*\
   Use :Modifies the internal memory of the LCD to allow for up to 8 customised characters to be created and stored in the device memory
       :
       :Param??tres pour la macro RAMWrite :
       :  Index : Values 0 to 7
       :  d0 : MX_UINT8
       :  d1 : MX_UINT8
       :  d2 : MX_UINT8
       :  d3 : MX_UINT8
       :  d4 : MX_UINT8
       :  d5 : MX_UINT8
       :  d6 : MX_UINT8
       :  d7 : MX_UINT8
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__RAMWrite(MX_UINT8 FCL_INDEX, MX_UINT8 FCL_D0, MX_UINT8 FCL_D1, MX_UINT8 FCL_D2, MX_UINT8 FCL_D3, MX_UINT8 FCL_D4, MX_UINT8 FCL_D5, MX_UINT8 FCL_D6, MX_UINT8 FCL_D7)
{

	FCD_04071_LCD__RawSend(64 + (FCL_INDEX << 3), 0);

	FCI_DELAYBYTE_MS(2);

	FCD_04071_LCD__RawSend(FCL_D0, 0x10);

	FCD_04071_LCD__RawSend(FCL_D1, 0x10);

	FCD_04071_LCD__RawSend(FCL_D2, 0x10);

	FCD_04071_LCD__RawSend(FCL_D3, 0x10);

	FCD_04071_LCD__RawSend(FCL_D4, 0x10);

	FCD_04071_LCD__RawSend(FCL_D5, 0x10);

	FCD_04071_LCD__RawSend(FCL_D6, 0x10);

	FCD_04071_LCD__RawSend(FCL_D7, 0x10);

	FCD_04071_LCD__Clear();

}

/*=----------------------------------------------------------------------=*\
   Use :Clears a single line on the display and then moves the cursor to the start of the line to allow you to start populating the line with data.
       :
       :Param??tres pour la macro ClearLine :
       :  Line : The line to clear, zero being the first (top) line of the display
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__ClearLine(MX_UINT8 FCL_LINE)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_X;


	if (FCL_LINE < 2)
	{

		FCD_04071_LCD__Cursor(0, FCL_LINE);

		FCL_X = 0;

		while (FCL_X < 16)
		{


			FCD_04071_LCD__RawSend(' ', 0x10);

			FCL_X = FCL_X + 1;


		}

		FCD_04071_LCD__Cursor(0, FCL_LINE);

	// } else {

	}

}

/*=----------------------------------------------------------------------=*\
   Use :Moves the cursor on the LCD Display
       :
       :Param??tres pour la macro Cursor :
       :  x : Set the cursor position in the X plane, 0 is the left most cell
       :  y : Set the cursor position in the Y plane, 0 is the top most cell
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__Cursor(MX_UINT8 FCL_X, MX_UINT8 FCL_Y)
{



	#if (0) // 2 == 1

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	#if (1) // 2 == 2

		if (FCL_Y == 0)
		{

			FCL_Y = 0x80;

		} else {

			FCL_Y = 0xC0;

		}

	// #else

	//Le code a t optimis par le prprocesseur
	#endif

	#if (0) // 2 == 4

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	FCD_04071_LCD__RawSend(FCL_Y + FCL_X, 0);

	FCI_DELAYBYTE_MS(2);

}

/*=----------------------------------------------------------------------=*\
   Use :Use this method/macro to send a specific command to the LCD. Refer to the Matrix Multimedia EB006 datasheet for a list of supported instructions. For Non-Matrix LCD's refer to the manufacturers datasheet.
       :
       :Param??tres pour la macro Command :
       :  instruction : Send a defined command to the LCD Screen. See datasheet for supported commands.
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__Command(MX_UINT8 FCL_INSTRUCTION)
{

	FCD_04071_LCD__RawSend(FCL_INSTRUCTION, 0);

	FCI_DELAYBYTE_MS(2);

}

/*=----------------------------------------------------------------------=*\
   Use :Will allow you to print a number up to 32-bits with signed or unsigned formatting.

       :Signed = -2147483648 to 2147483647

       :Unsigned = 0 to 4294967295
       :
       :Param??tres pour la macro PrintFormattedNumber :
       :  Number : Enter the number or variable to print to the LCD
       :  Format : 0=Signed, 1=Unsigned
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__PrintFormattedNumber(MX_UINT32 FCL_NUMBER, MX_BOOL FCL_FORMAT)
{
	//Dfinitions des variables locales
	#define FCLsz_S 15
	MX_CHAR FCL_S[FCLsz_S];


	if (FCL_FORMAT == 1)
	{

		FCI_UTOS32(FCL_NUMBER, FCL_S,15);

	} else {

		FCI_ITOS32((MX_SINT32)(FCL_NUMBER), FCL_S,15);

	}

	FCD_04071_LCD__PrintString(FCL_S, FCLsz_S);

	//Dfinitions des variables locales
	#undef FCLsz_S
}

/*=----------------------------------------------------------------------=*\
   Use :Scrolls the display left or right by a number of given positions.
       :
       :Param??tres pour la macro ScrollDisplay :
       :  Position : Holds the number of positions to shift the display
       :  direction : 0 = left, 1 = right
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__ScrollDisplay(MX_UINT8 FCL_POSITION, MX_UINT8 FCL_DIRECTION)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_CMD = (0x0);


	FCL_CMD = 0;

	switch (FCL_DIRECTION)
	{
		case 0:
		{
			FCL_CMD = 0x18;


			break;
		}
		case 'l':
		{
			FCL_CMD = 0x18;


			break;
		}
		case 'L':
		{
			FCL_CMD = 0x18;


			break;
		}
		case 1:
		{
			FCL_CMD = 0x1C;


			break;
		}
		case 'r':
		{
			FCL_CMD = 0x1C;


			break;
		}
		case 'R':
		{
			FCL_CMD = 0x1C;


			break;
		}
		// default:

	}

	if (FCL_CMD != 0 && FCL_POSITION != 0)
	{

		while (FCL_POSITION != 0)
		{

			FCD_04071_LCD__RawSend(FCL_CMD, 0);

			FCL_POSITION = FCL_POSITION - 1;


		}

	// } else {

	}

}

/*=----------------------------------------------------------------------=*\
   Use :Sends data to the LCD display
       :
       :Param??tres pour la macro RawSend :
       :  data : The data byte to send to the LCD
       :  type : A boolean to indicate command type: true to write data, false to write a command
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__RawSend(MX_UINT8 FCL_DATA, MX_BOOL FCL_TYPE)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_NIBBLE;


	//Commentaire:
	//Output upper nibble of the byte

	#if (1) // 0 == 0

		FCP_SET(B, B, 0x1, 0x0, 0);
		FCP_SET(B, B, 0x2, 0x1, 0);
		FCP_SET(B, B, 0x4, 0x2, 0);
		FCP_SET(B, B, 0x8, 0x3, 0);
		FCP_SET(B, B, 0x10, 0x4, 0);
		FCP_SET(B, B, 0x20, 0x5, 0);

		#if (0)

		//Le code a t optimis par le prprocesseur
		// #else

		#endif

		FCL_NIBBLE = (FCL_DATA >> 4);
		FCP_SET(B, B, 0x1, 0x0, (FCL_NIBBLE & 0x01));
		FCL_NIBBLE = FCL_NIBBLE >> 1;
		FCP_SET(B, B, 0x2, 0x1, (FCL_NIBBLE & 0x01));
		FCL_NIBBLE = FCL_NIBBLE >> 1;
		FCP_SET(B, B, 0x4, 0x2, (FCL_NIBBLE & 0x01));
		FCL_NIBBLE = FCL_NIBBLE >> 1;
		FCP_SET(B, B, 0x8, 0x3, (FCL_NIBBLE & 0x01));

	// #else

	//Le code a t optimis par le prprocesseur
	#endif

	//Commentaire:
	//Output byte to pins

	#if (0) // 0 == 1

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	//Commentaire:
	//Output byte to port

	#if (0) // 0 == 2

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	if (FCL_TYPE)
	{

		FCP_SET(B, B, 0x10, 0x4, 1);

	// } else {

	}

	FCI_DELAYBYTE_US(100);

	//Commentaire:
	//Set Enable high, pause then set low

	//to acknowledge the data has been 
	//submitted.

	FCP_SET(B, B, 0x20, 0x5, 1);

	FCI_DELAYBYTE_US(100);

	FCP_SET(B, B, 0x20, 0x5, 0);

	FCI_DELAYBYTE_US(100);

	#if (1) // 0 == 0

		FCP_SET(B, B, 0x1, 0x0, 0);
		FCP_SET(B, B, 0x2, 0x1, 0);
		FCP_SET(B, B, 0x4, 0x2, 0);
		FCP_SET(B, B, 0x8, 0x3, 0);
		FCP_SET(B, B, 0x10, 0x4, 0);

		FCL_NIBBLE = (FCL_DATA & 0xf);
		FCP_SET(B, B, 0x1, 0x0, (FCL_NIBBLE & 0x01));
		FCL_NIBBLE = FCL_NIBBLE >> 1;
		FCP_SET(B, B, 0x2, 0x1, (FCL_NIBBLE & 0x01));
		FCL_NIBBLE = FCL_NIBBLE >> 1;
		FCP_SET(B, B, 0x4, 0x2, (FCL_NIBBLE & 0x01));
		FCL_NIBBLE = FCL_NIBBLE >> 1;
		FCP_SET(B, B, 0x8, 0x3, (FCL_NIBBLE & 0x01));

		if (FCL_TYPE)
		{

			FCP_SET(B, B, 0x10, 0x4, 1);

		// } else {

		}

		FCI_DELAYBYTE_US(100);

		FCP_SET(B, B, 0x20, 0x5, 1);

		FCI_DELAYBYTE_US(100);

		FCP_SET(B, B, 0x20, 0x5, 0);

		FCI_DELAYBYTE_US(100);

	// #else

	//Le code a t optimis par le prprocesseur
	#endif

}

/*=----------------------------------------------------------------------=*\
   Use :Startup routine required by the hardware device.

       :Automatically clears the display after initialising.
\*=----------------------------------------------------------------------=*/
void FCD_04071_LCD__Start()
{



	#if (1) // 0 == 0

		FCP_SET(B, B, 0x1, 0x0, 0);
		FCP_SET(B, B, 0x2, 0x1, 0);
		FCP_SET(B, B, 0x4, 0x2, 0);
		FCP_SET(B, B, 0x8, 0x3, 0);
		FCP_SET(B, B, 0x10, 0x4, 0);
		FCP_SET(B, B, 0x20, 0x5, 0);

	// #else

	//Le code a t optimis par le prprocesseur
	#endif

	#if (0) // 0 == 1

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	#if (0) // 0 == 2

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	#if (0)

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	FCI_DELAYBYTE_MS(12);

	FCD_04071_LCD__RawSend(0x33, 0);

	FCI_DELAYBYTE_MS(2);

	FCD_04071_LCD__RawSend(0x33, 0);

	FCI_DELAYBYTE_MS(2);

	#if (0) // 0 > 0

	//Le code a t optimis par le prprocesseur
	#else

		FCD_04071_LCD__RawSend(0x32, 0);

		FCI_DELAYBYTE_MS(2);

		FCD_04071_LCD__RawSend(0x2c, 0);

	#endif

	FCI_DELAYBYTE_MS(2);

	FCD_04071_LCD__RawSend(0x06, 0);

	FCI_DELAYBYTE_MS(2);

	FCD_04071_LCD__RawSend(0x0c, 0);

	FCI_DELAYBYTE_MS(2);

	FCD_04071_LCD__RawSend(0x01, 0);

	FCI_DELAYBYTE_MS(2);

	FCD_04071_LCD__RawSend(0x02, 0);

	FCI_DELAYBYTE_MS(2);

	FCD_04071_LCD__Clear();

}


/*========================================================================*\
   Use :lcd_eb005
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :ButtonCtrl
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :lut
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :keypad_base
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Blocking call that waits for one of the keys on the keypad to be pressed. The index of the key that was pressed  is passed back to the user.
       :
       :Renvoie : Index of the first key pressed.
\*=----------------------------------------------------------------------=*/
MX_UINT8 FCD_08c31_keypad_base__WaitPressed()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_INDEX;
	MX_UINT8 FCR_RETVAL; // Index of the first key pressed.


	while (1)
	{

		FCL_INDEX = FCD_08c31_keypad_base__GetIndex();


		if ((FCL_INDEX == 255) == 0) break;
	}

	FCR_RETVAL = FCL_INDEX;

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Gets the ASCII value for the current keypress. If no key is pressed then the macro returns the value 255.
       :
       :Renvoie : ASCII code of the pressed switch (or 255 if none pressed)
\*=----------------------------------------------------------------------=*/
MX_UINT8 FCD_08c31_keypad_base__GetAscii()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_INDEX;
	MX_UINT8 FCR_RETVAL; // ASCII code of the pressed switch (or 255 if none pressed)


	FCL_INDEX = FCD_08c31_keypad_base__GetIndex();

	if (FCL_INDEX < 255)
	{

		FCR_RETVAL = FCI_GETCHAR("123456789*0#", 13, FCL_INDEX);

	} else {

		FCR_RETVAL = FCL_INDEX;

	}

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Gets the ASCII value for the current keypress and returns in the form of a string. If no key pressed then the macro returns the value 255.
       :
       :Renvoie : Single character representing the pressed key, or an empty string if none pressed.
\*=----------------------------------------------------------------------=*/
void FCD_08c31_keypad_base__GetString(MX_CHAR *FCR_RETVAL, MX_UINT16 FCRsz_RETVAL)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_INDEX;


	FCL_INDEX = FCD_08c31_keypad_base__GetIndex();

	if (FCL_INDEX < 255)
	{

		FCI_MIDSTRING("123456789*0#", 13, FCL_INDEX, 1, FCR_RETVAL,20);

	} else {

		FCI_SCOPY("",1, FCR_RETVAL,FCRsz_RETVAL);

	}

}

/*=----------------------------------------------------------------------=*\
   Use :Renvoie : MX_UINT8
\*=----------------------------------------------------------------------=*/
MX_UINT8 FCD_08c31_keypad_base__Prv_GetRow()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_INDEX = (0x0);
	MX_BOOL FCL_PIN_STATE = (0);
	MX_UINT8 FCR_RETVAL;


	FCL_INDEX = 0;
	FCR_RETVAL = 255;

	while (FCL_INDEX < 4)
	{

		switch (FCL_INDEX)
		{
			case 0:
			{
				FCL_PIN_STATE = FCP_GET(B, D, 0x10, 0x4);

				break;
			}
			case 1:
			{
				FCL_PIN_STATE = FCP_GET(B, D, 0x20, 0x5);

				break;
			}
			case 2:
			{
				FCL_PIN_STATE = FCP_GET(B, D, 0x40, 0x6);

				break;
			}
			case 3:
			{
				FCL_PIN_STATE = FCP_GET(B, D, 0x80, 0x7);

				break;
			}
			default:
			{
			}
		}

		if (FCL_PIN_STATE == FCV_08c31_keypad_base__TRUE)
		{

			FCR_RETVAL = FCL_INDEX;

			goto FCC_Prv_GetRow_A;

		// } else {

		}

		FCL_INDEX = FCL_INDEX + 1;


	}

FCC_Prv_GetRow_A:
;

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Gets the numeric value for the current keypress. If no key pressed then the macro returns the value 255.
       :
       :Renvoie : Number return value of the pressed key, or 255 if none pressed.
\*=----------------------------------------------------------------------=*/
MX_UINT8 FCD_08c31_keypad_base__GetNumber()
{
	//Dfinitions des variables locales
	MX_UINT8 FCR_RETVAL; // Number return value of the pressed key, or 255 if none pressed.


	FCR_RETVAL = FCD_08c31_keypad_base__GetIndex();

	if (FCR_RETVAL < 255)
	{

		FCR_RETVAL = FCD_00fb1_lut__INTLIST(FCR_RETVAL);

	// } else {

	}

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Gets the index value for the current keypress. If no key pressed then the macro returns the value 255.
       :
       :Renvoie : Index of the pressed switch, or 255 if none pressed.
\*=----------------------------------------------------------------------=*/
MX_UINT8 FCD_08c31_keypad_base__GetIndex()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_INDEX = (0x0);
	MX_UINT8 FCL_ROW_STATE;
	MX_UINT8 FCR_RETVAL; // Index of the pressed switch, or 255 if none pressed.


	FCD_08c31_keypad_base__Prv_FloatColumns();

	FCL_INDEX = 0;
	FCR_RETVAL = 255;

	while (FCL_INDEX < 3)
	{

		switch (FCL_INDEX)
		{
			case 0:
			{
				#if (1) // 3 >= 1

					FCP_SET(B, D, 0x1, 0x0, 1);

				// #else

				//Le code a t optimis par le prprocesseur
				#endif

				break;
			}
			case 1:
			{
				#if (1) // 3 >= 2

					FCP_SET(B, D, 0x2, 0x1, 1);

				// #else

				//Le code a t optimis par le prprocesseur
				#endif

				break;
			}
			case 2:
			{
				#if (1) // 3 >= 3

					FCP_SET(B, D, 0x4, 0x2, 1);

				// #else

				//Le code a t optimis par le prprocesseur
				#endif

				break;
			}
			case 3:
			{
				#if (0) // 3 >= 4

				//Le code a t optimis par le prprocesseur
				// #else

				#endif

				break;
			}
			default:
			{
			}
		}

		FCI_DELAYBYTE_US(20);

		FCL_ROW_STATE = FCD_08c31_keypad_base__Prv_GetRow();

		switch (FCL_INDEX)
		{
			case 0:
			{
				#if (1) // 3 >= 1

					FCP_SET(B, D, 0x1, 0x0, 0);

				// #else

				//Le code a t optimis par le prprocesseur
				#endif

				break;
			}
			case 1:
			{
				#if (1) // 3 >= 2

					FCP_SET(B, D, 0x2, 0x1, 0);

				// #else

				//Le code a t optimis par le prprocesseur
				#endif

				break;
			}
			case 2:
			{
				#if (1) // 3 >= 3

					FCP_SET(B, D, 0x4, 0x2, 0);

				// #else

				//Le code a t optimis par le prprocesseur
				#endif

				break;
			}
			case 3:
			{
				#if (0) // 3 >= 4

				//Le code a t optimis par le prprocesseur
				// #else

				#endif

				break;
			}
			default:
			{
			}
		}

		if (FCL_ROW_STATE < 255)
		{

			FCR_RETVAL = (FCL_ROW_STATE * 3) + FCL_INDEX;

			goto FCC_GetIndex_A;

		// } else {

		}

		FCI_DELAYBYTE_US(50);

		FCL_INDEX = FCL_INDEX + 1;


	}

FCC_GetIndex_A:
;

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :
\*=----------------------------------------------------------------------=*/
void FCD_08c31_keypad_base__Prv_FloatColumns()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_INDEX;


	FCL_INDEX = 0;

	while (FCL_INDEX < 3)
	{

		switch (0)
		{
			case 0:
			{
				#if (1) // 3 >= 1

					FCP_SET(B, D, 0x1, 0x0, 0);

				// #else

				//Le code a t optimis par le prprocesseur
				#endif

				break;
			}
			case 1:
			{
				#if (1) // 3 >= 2

					FCP_SET(B, D, 0x2, 0x1, 0);

				// #else

				//Le code a t optimis par le prprocesseur
				#endif

				break;
			}
			case 2:
			{
				#if (1) // 3 >= 3

					FCP_SET(B, D, 0x4, 0x2, 0);

				// #else

				//Le code a t optimis par le prprocesseur
				#endif

				break;
			}
			case 3:
			{
				#if (0) // 3 >= 4

				//Le code a t optimis par le prprocesseur
				// #else

				#endif

				break;
			}
			default:
			{
			}
		}

		FCL_INDEX = FCL_INDEX + 1;


	}

}

/*=----------------------------------------------------------------------=*\
   Use :Blocking call that waits for the keys on the keypad to be released. If no key is pressed then the function will return immediatley.
\*=----------------------------------------------------------------------=*/
void FCD_08c31_keypad_base__WaitReleased()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_INDEX;


	while (1)
	{

		FCL_INDEX = FCD_08c31_keypad_base__GetIndex();


		if ((FCL_INDEX < 255) == 0) break;
	}

}


/*========================================================================*\
   Use :panel
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :
\*=----------------------------------------------------------------------=*/
void FCM_Initialisation()
{

	// Calcul
	// Calcul:
	//  Colonne = 0
	//  Ligne = 0
	//  touche = 0
	//  i = 0
	//  y = 0
	//  toucheBin[0] = 9
	//  toucheBin[1] = 10
	//  toucheBin[2] = 12
	//  toucheBin[3] = 17
	//  toucheBin[4] = 18
	//  toucheBin[5] = 20
	//  toucheBin[6] = 33
	//  toucheBin[7] = 34
	//  toucheBin[8] = 36
	//  toucheBin[9] = 65
	//  toucheBin[10] = 66
	//  toucheBin[11] = 68
	//  toucheRef[0] = '1'
	//  toucheRef[1] = '2'
	//  toucheRef[2] = '3'
	//  toucheRef[3] = '4'
	//  toucheRef[4] = '5'
	//  toucheRef[5] = '6'
	//  toucheRef[6] = '7'
	//  toucheRef[7] = '8'
	//  toucheRef[8] = '9'
	//  toucheRef[9] = '*'
	//  toucheRef[10] = '0'
	//  toucheRef[11] = '#'
	FCV_COLONNE = 0;
	FCV_LIGNE = 0;
	FCV_TOUCHE = 0;
	FCV_I = 0;
	FCV_Y = 0;
	FCV_TOUCHEBIN[0] = 9;
	FCV_TOUCHEBIN[1] = 10;
	FCV_TOUCHEBIN[2] = 12;
	FCV_TOUCHEBIN[3] = 17;
	FCV_TOUCHEBIN[4] = 18;
	FCV_TOUCHEBIN[5] = 20;
	FCV_TOUCHEBIN[6] = 33;
	FCV_TOUCHEBIN[7] = 34;
	FCV_TOUCHEBIN[8] = 36;
	FCV_TOUCHEBIN[9] = 65;
	FCV_TOUCHEBIN[10] = 66;
	FCV_TOUCHEBIN[11] = 68;
	FCV_TOUCHEREF[0] = '1';
	FCV_TOUCHEREF[1] = '2';
	FCV_TOUCHEREF[2] = '3';
	FCV_TOUCHEREF[3] = '4';
	FCV_TOUCHEREF[4] = '5';
	FCV_TOUCHEREF[5] = '6';
	FCV_TOUCHEREF[6] = '7';
	FCV_TOUCHEREF[7] = '8';
	FCV_TOUCHEREF[8] = '9';
	FCV_TOUCHEREF[9] = '*';
	FCV_TOUCHEREF[10] = '0';
	FCV_TOUCHEREF[11] = '#';

	// Boucle
	// Boucle: Boucle i < 5 times
	for (FCLV_LOOP1=0; (FCLV_LOOP1)<(FCV_I < 5); (FCLV_LOOP1)++)
	{

		// Calcul
		// Calcul:
		//  codeTouche[i] = 0
		FCV_CODETOUCHE[FCV_I] = 0;


	}

	// Calcul
	// Calcul:
	//  i = 0
	FCV_I = 0;

}

/*=----------------------------------------------------------------------=*\
   Use :
\*=----------------------------------------------------------------------=*/
void FCM_AttribuerTouche()
{

	// Boucle
	// Boucle: While i <= 11 && codeTouche[y] == 0
	while (FCV_I <= 11 && FCV_CODETOUCHE[FCV_Y] == 0)
	{

		// Dcision
		// Dcision: touche = toucheBin[i]?
		if (FCV_TOUCHE == FCV_TOUCHEBIN[FCV_I])
		{

			// Calcul
			// Calcul:
			//  codeTouche[y] = toucheRef[i]
			FCV_CODETOUCHE[FCV_Y] = FCV_TOUCHEREF[FCV_I];

			// Appel de la Routine Composant
			// Appel de la Routine Composant: lcd_eb005::PrintAscii(codeTouche[y])
			FCD_0ad31_lcd_eb005__PrintAscii(FCV_CODETOUCHE[FCV_Y]);

		// } else {

		}

		// Calcul
		// Calcul:
		//  i = i + 1
		FCV_I = FCV_I + 1;


	}

	// Calcul
	// Calcul:
	//  y = y + 1
	FCV_Y = FCV_Y + 1;

	// Calcul
	// Calcul:
	//  i = 0
	FCV_I = 0;

}



/*========================================================================*\
   Use :Principale
\*========================================================================*/
void main()
{

ansel = 0;
anselh = 0;


option_reg = 0xC0;



	// Appel d'une Macro
	// Appel d'une Macro: Initialisation()
	FCM_Initialisation();

	// Appel de la Routine Composant
	// Appel de la Routine Composant: lcd_eb005::Start()
	FCD_0ad31_lcd_eb005__Start();

	// Boucle
	// Boucle: While 1
	while (1)
	{

		// Sortie
		// Sortie: 0b00000111 -> PORTD
		FCP_SET(F, D, 0xFF, 0, (7));
		// Entre
		// Entre: PORTD -> Ligne
		FCV_LIGNE = FCP_GET(M, D, 0x78, 0);
		// Dcision
		// Dcision: Ligne != 0?
		if (FCV_LIGNE != 0)
		{

			// Sortie
			// Sortie: 0b01111000 -> PORTD
			FCP_SET(F, D, 0xFF, 0, (120));
			// Entre
			// Entre: PORTD -> Colonne
			FCV_COLONNE = FCP_GET(M, D, 0x07, 0);
			// Dcision
			// Dcision: Colonne != 0?
			if (FCV_COLONNE != 0)
			{

				// Calcul
				// Calcul:
				//  touche = Ligne + Colonne
				FCV_TOUCHE = FCV_LIGNE + FCV_COLONNE;

				// Appel d'une Macro
				// Appel d'une Macro: AttribuerTouche()
				FCM_AttribuerTouche();

			// } else {

			}

			// Pause
			// Pause: 450 ms
			FCI_DELAYINT_MS(450);

		} else {

			// Pause
			// Pause: 100 ms
			FCI_DELAYBYTE_MS(100);

		}


	}

	mainendloop: goto mainendloop;
}




/*========================================================================*\
   Use :Interruption
\*========================================================================*/
void MX_INTERRUPT_MACRO(void)
{


}





