

// config bits via MPLAB
/*
   Address    Value   Field                 Category                                                    Setting                                    

   300003      1E   WDTEN   Watchdog Timer Enable bit              WDT is controlled by SWDTEN bit of the WDTCON register                          
                    WDTPS   Watchdog Timer Postscale Select bits   1:32768                                                                         
   300005      88   HFOFST  HFINTOSC Fast Start-up bit             HFINTOSC starts clocking the CPU without waiting for the oscillator to stablize.
                    MCLRE   MCLR Pin Enable bit                    MCLR pin enabled; RA3 input pin disabled                                        
   300006      85   STVREN  Stack Full/Underflow Reset Enable bit  Stack full/underflow will cause Reset                                           
                    LVP     Single-Supply ICSP Enable bit          Single-Supply ICSP enabled                                                      
                    BBSIZ   Boot Block Size Select bit             512W boot block size                                                            
                    XINST   Extended Instruction Set Enable bit    Instruction set extension and Indexed Addressing mode disabled (Legacy mode)    
   300008      03   CP0     Code Protection bit                    Block 0 not code-protected                                                      
                    CP1     Code Protection bit                    Block 1 not code-protected                                                      
   300009      C0   CPB     Boot Block Code Protection bit         Boot block not code-protected                                                   
                    CPD     Data EEPROM Code Protection bit        Data EEPROM not code-protected                                                  
   30000A      03   WRT0    Table Write Protection bit             Block 0 not write-protected                                                     
                    WRT1    Table Write Protection bit             Block 1 not write-protected                                                     
   30000B      E0   WRTC    Configuration Register Write Protection bitConfiguration registers not write-protected                                     
                    WRTB    Boot Block Write Protection bit        Boot block not write-protected                                                  
                    WRTD    Data EEPROM Write Protection bit       Data EEPROM not write-protected                                                 
   30000C      03   EBTR0   Table Read Protection bit              Block 0 not protected from table reads executed in other blocks                 
                    EBTR1   Table Read Protection bit              Block 1 not protected from table reads executed in other blocks                 
   30000D      40   EBTRB   Boot Block Table Read Protection bit   Boot block not protected from table reads executed in other blocks              
*/


#include "p18f13k50.h"

int i,j,k;
unsigned long L;

void Delay(unsigned long x)
{
	while(x>0)
	{
		x=x-1;
	}	
}

void main()
{  
    ANSEL=0;
	TRISA=0x00;
  while(1)
  {
	LATAbits.LATA4=1;
	Delay(100000);
	LATAbits.LATA4=0;
	Delay(100000);
	}	  	
}	