//************************************************************************************
//**  
//**  File name:     H:\PROJET BAC 2014-2015\PROJET BAC 2014-2015.Seill Lonard\Programme Capteur\HorlogeDCF.c
//**  Title:         
//**  Description:   
//**  
//**  Generated by:  Flowcode v5.5.2.1
//**  Date:          Friday, April 10, 2015 17:11:00
//**  Licence:       50 User
//**  Registered to: LYCEE-BRANLY80
//**  Licence key:   TC8D5B
//**  
//**  
//**     POUR UN USAGE NON COMMERCIAL 
//**  
//**  http://www.matrixmultimedia.com
//**  
//************************************************************************************


#define MX_PIC

#define MX_USES_UINT8 3
#define MX_USES_SINT16 0
#define MX_USES_CHAR 0
#define MX_USES_FLOAT 0
#define MX_USES_SINT32 0
#define MX_USES_BOOL 1
#define MX_USES_UINT16 0
#define MX_USES_UINT32 0
//Dfinir pour microcontrleur
#define P16F877A
#define FC_CAL_PIC
#define MX_ADC
#define MX_ADC_TYPE_1
#define MX_ADC_BITS_10
#define MX_EE
#define MX_EE_TYPE2
#define MX_EE_SIZE 256
#define MX_SPI_1
#define MX_SPI_1_MISO_PORT portc
#define MX_SPI_1_MISO_TRIS trisc
#define MX_SPI_1_MISO_PIN 4
#define MX_SPI_1_MOSI_PORT portc
#define MX_SPI_1_MOSI_TRIS trisc
#define MX_SPI_1_MOSI_PIN 5
#define MX_SPI_1_CLK_PORT portc
#define MX_SPI_1_CLK_TRIS trisc
#define MX_SPI_1_CLK_PIN 3
#define MX_SPI_1_SS_PORT portc
#define MX_SPI_1_SS_TRIS trisc
#define MX_UART_1
#define MX_UART_1_TX_PORT portc
#define MX_UART_1_TX_TRIS trisc
#define MX_UART_1_TX_PIN 6
#define MX_UART_1_RX_PORT portc
#define MX_UART_1_RX_TRIS trisc
#define MX_UART_1_RX_PIN 7
#define MX_I2C
#define MX_MI2C
#define MX_I2C_1
#define MX_I2C_1_SDA_PORT portc
#define MX_I2C_1_SDA_TRIS trisc
#define MX_I2C_1_SDA_PIN 4
#define MX_I2C_1_SCL_PORT portc
#define MX_I2C_1_SCL_TRIS trisc
#define MX_I2C_1_SCL_PIN 3
#define MX_PWM
#define MX_PWM_CNT 2
#define MX_PWM_PSCA1
#define MX_PWM_PSCA4
#define MX_PWM_PSCA16
#define MX_PWM_1_PORT portc
#define MX_PWM_1_TRIS trisc
#define MX_PWM_1_PIN 2
#define MX_PWM_2_PORT portc
#define MX_PWM_2_TRIS trisc
#define MX_PWM_2_PIN 1

//Fonctions
#define MX_CLK_SPEED 19660800
#ifdef _BOOSTC
#include <system.h>
#endif
#ifdef HI_TECH_C
#include <pic.h>
#endif

//Donnes de Configuration
#ifdef _BOOSTC
#pragma DATA 0x2007, 0x3f72
#endif
#ifdef HI_TECH_C
__CONFIG(0x3f72);
#endif

//Fonctions internes
#include "C:\Program Files\Flowcode\v5\FCD\internals.c"

//Dclarations de fonction Macro


//Dclarations de Variable
#define FCV_FALSE (0)
#define FCV_TRUE (1)
MX_UINT8 FCV_COMPTE;
MX_UINT8 FCV_MOIS_T;
MX_UINT8 FCV_MOIS_U;
MX_UINT8 FCV_DCF;
MX_UINT8 FCV_JOUR_SEMAINE;
MX_UINT8 FCV_SECONDE;
MX_UINT8 FCV_MINUTE_T;
MX_UINT8 FCV_ANS_T;
MX_UINT8 FCV_JOUR_T;
MX_UINT8 FCV_HEURE_T;
MX_UINT8 FCV_MINUTE_U;
MX_UINT8 FCV_SIGNAL[59];
MX_UINT8 FCV_ANS_U;
MX_UINT8 FCV_JOUR_U;
MX_UINT8 FCV_HEURE_U;




//LCDDisplay(0): //Defines:

/**** Macro Substitutions ****
a = Unique Component Reference Number
b = D1 Port Letter
c = D2 Port Letter
d = D3 Port Letter
e = D4 Port Letter
f = RS Port Letter
g = E Port Letter
h = Data 1_Pin
i = Data 2 Pin
j = Data 3 Pin
k = Data 4 Pin
l = RS Pin
m = Enable Pin
n = Row Count
o = Column Count
******************************/

	//component connections
	//Port pin lat workaround for 8-bit PIC devices running >= 32MHz
	//seems we need this mod for 19660800 16F1937 so changed to >= 16MHz

  #ifdef FC_CAL_PIC
   #if MX_CLK_SPEED >= 32000000
	#define LCD_1__PORT0    latb
	#define LCD_1__PORT1    latb
	#define LCD_1__PORT2    latb
	#define LCD_1__PORT3    latb
	#define LCD_1__PORT4    latb
	#define LCD_1__PORT5    latb
   #else
    #ifdef MX_LCD_PORT_LAT
	 #define LCD_1__PORT0    latb
	 #define LCD_1__PORT1    latb
	 #define LCD_1__PORT2    latb
	 #define LCD_1__PORT3    latb
	 #define LCD_1__PORT4    latb
	 #define LCD_1__PORT5    latb
    #else
	 #define LCD_1__PORT0    portb
	 #define LCD_1__PORT1    portb
	 #define LCD_1__PORT2    portb
	 #define LCD_1__PORT3    portb
	 #define LCD_1__PORT4    portb
	 #define LCD_1__PORT5    portb
	#endif
   #endif
  #else
	#define LCD_1__PORT0    portb
	#define LCD_1__PORT1    portb
	#define LCD_1__PORT2    portb
	#define LCD_1__PORT3    portb
	#define LCD_1__PORT4    portb
	#define LCD_1__PORT5    portb
  #endif

	#define LCD_1__TRIS0    trisb
	#define LCD_1__TRIS1    trisb
	#define LCD_1__TRIS2    trisb
	#define LCD_1__TRIS3    trisb
	#define LCD_1__TRIS4    trisb
	#define LCD_1__TRIS5    trisb
	#define LCD_1__BIT0    	0
	#define LCD_1__BIT1    	1
	#define LCD_1__BIT2    	2
	#define LCD_1__BIT3    	3
	#define LCD_1__RS      	4
	#define LCD_1__E       	5
	#define LCD_1__ROWCNT	2
	#define LCD_1__COLCNT	16

	#ifdef _BOOSTC
	  #define LCD_1__DELAY   delay_10us(10)
	#endif
	#ifdef _C2C_
	  #define LCD_1__DELAY   delay_us(100)
	#endif
	#ifdef HI_TECH_C
	  #define LCD_1__DELAY   __delay_us(120)
	#endif
	#ifndef LCD_1__DELAY
	  #define LCD_1__DELAY   delay_us(100)
	#endif




//LCDDisplay(0): //Dclarations de fonction Macro

void FCD_LCDDisplay0_RawSend(MX_UINT8 in, MX_UINT8 mask);
void FCD_LCDDisplay0_Start();
void FCD_LCDDisplay0_Clear();
void FCD_LCDDisplay0_PrintASCII(MX_UINT8 Character);
void FCD_LCDDisplay0_Command(MX_UINT8 in);
void FCD_LCDDisplay0_Cursor(MX_UINT8 x, MX_UINT8 y);
void FCD_LCDDisplay0_PrintNumber(MX_SINT16 Number);
void FCD_LCDDisplay0_PrintString(MX_STRING String, MX_UINT8 MSZ_String);
void FCD_LCDDisplay0_ScrollDisplay(MX_UINT8 Direction, MX_UINT8 Num_Positions);
void FCD_LCDDisplay0_ClearLine(MX_UINT8 Line);
void FCD_LCDDisplay0_RAM_Write(MX_UINT8 nIdx, MX_UINT8 d0, MX_UINT8 d1, MX_UINT8 d2, MX_UINT8 d3, MX_UINT8 d4, MX_UINT8 d5, MX_UINT8 d6, MX_UINT8 d7);



//LCDDisplay(0): //Implmentations Macro


void FCD_LCDDisplay0_RawSend(MX_UINT8 in, MX_UINT8 mask)
{
	
		MX_UINT8 pt;

		FC_CAL_Bit_Low(LCD_1__PORT0, LCD_1__BIT0);
		FC_CAL_Bit_Low(LCD_1__PORT1, LCD_1__BIT1);
		FC_CAL_Bit_Low(LCD_1__PORT2, LCD_1__BIT2);
		FC_CAL_Bit_Low(LCD_1__PORT3, LCD_1__BIT3);
		FC_CAL_Bit_Low(LCD_1__PORT4, LCD_1__RS);
		FC_CAL_Bit_Low(LCD_1__PORT5, LCD_1__E);
		pt = ((in >> 4) & 0x0f);
		if (pt & 0x01)
		    FC_CAL_Bit_High(LCD_1__PORT0, LCD_1__BIT0);
		if (pt & 0x02)
		    FC_CAL_Bit_High(LCD_1__PORT1, LCD_1__BIT1);
		if (pt & 0x04)
		    FC_CAL_Bit_High(LCD_1__PORT2, LCD_1__BIT2);
		if (pt & 0x08)
		    FC_CAL_Bit_High(LCD_1__PORT3, LCD_1__BIT3);
		if (mask)
		    FC_CAL_Bit_High(LCD_1__PORT4, LCD_1__RS);
		LCD_1__DELAY;
		FC_CAL_Bit_High (LCD_1__PORT5, LCD_1__E);
		LCD_1__DELAY;
		FC_CAL_Bit_Low (LCD_1__PORT5, LCD_1__E);
		pt = (in & 0x0f);
		LCD_1__DELAY;
		FC_CAL_Bit_Low(LCD_1__PORT0, LCD_1__BIT0);
		FC_CAL_Bit_Low(LCD_1__PORT1, LCD_1__BIT1);
		FC_CAL_Bit_Low(LCD_1__PORT2, LCD_1__BIT2);
		FC_CAL_Bit_Low(LCD_1__PORT3, LCD_1__BIT3);
		FC_CAL_Bit_Low(LCD_1__PORT4, LCD_1__RS);
		FC_CAL_Bit_Low(LCD_1__PORT5, LCD_1__E);
		if (pt & 0x01)
		    FC_CAL_Bit_High(LCD_1__PORT0, LCD_1__BIT0);
		if (pt & 0x02)
		    FC_CAL_Bit_High(LCD_1__PORT1, LCD_1__BIT1);
		if (pt & 0x04)
		    FC_CAL_Bit_High(LCD_1__PORT2, LCD_1__BIT2);
		if (pt & 0x08)
		    FC_CAL_Bit_High(LCD_1__PORT3, LCD_1__BIT3);
		if (mask)
		    FC_CAL_Bit_High(LCD_1__PORT4, LCD_1__RS);
		LCD_1__DELAY;
		FC_CAL_Bit_High (LCD_1__PORT5, LCD_1__E);
		LCD_1__DELAY;
		FC_CAL_Bit_Low (LCD_1__PORT5, LCD_1__E);
		LCD_1__DELAY;

}

void FCD_LCDDisplay0_Start()
{
	
		FC_CAL_Bit_Low_DDR(LCD_1__PORT0, LCD_1__TRIS0, LCD_1__BIT0);
		FC_CAL_Bit_Low_DDR(LCD_1__PORT1, LCD_1__TRIS1, LCD_1__BIT1);
		FC_CAL_Bit_Low_DDR(LCD_1__PORT2, LCD_1__TRIS2, LCD_1__BIT2);
		FC_CAL_Bit_Low_DDR(LCD_1__PORT3, LCD_1__TRIS3, LCD_1__BIT3);
		FC_CAL_Bit_Low_DDR(LCD_1__PORT4, LCD_1__TRIS4, LCD_1__RS);
		FC_CAL_Bit_Low_DDR(LCD_1__PORT5, LCD_1__TRIS5, LCD_1__E);

		Wdt_Delay_Ms(12);

		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x32, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x2c, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x06, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x0c, 0);
		Wdt_Delay_Ms(2);

		//clear the display
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_Clear()
{
	
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_PrintASCII(MX_UINT8 Character)
{
	
		FCD_LCDDisplay0_RawSend(Character, 0x10);

}

void FCD_LCDDisplay0_Command(MX_UINT8 in)
{
	
		FCD_LCDDisplay0_RawSend(in, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_Cursor(MX_UINT8 x, MX_UINT8 y)
{
	
	  #if (LCD_1__ROWCNT == 1)
	    y=0x80;
	  #endif

	  #if (LCD_1__ROWCNT == 2)
		if (y==0)
			y=0x80;
		else
			y=0xc0;
	  #endif

	  #if (LCD_1__ROWCNT == 4)
		if (y==0)
			y=0x80;
		else if (y==1)
			y=0xc0;

		#if (LCD_1__COLCNT == 16)
			else if (y==2)
				y=0x90;
			else
				y=0xd0;
		#endif

		#if (LCD_1__COLCNT == 20)
			else if (y==2)
				y=0x94;
			else
				y=0xd4;
		#endif
	  #endif

		FCD_LCDDisplay0_RawSend(y+x, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_PrintNumber(MX_SINT16 Number)
{
	
		MX_SINT16 tmp_int;
		MX_UINT8 tmp_byte;

		if (Number < 0)
		{
			FCD_LCDDisplay0_RawSend('-', 0x10);
			Number = 0 - Number;
		}

		tmp_int = Number;
		if (Number >= 10000)
		{
			tmp_byte = tmp_int / 10000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10000;
				tmp_byte--;
			}
		}
		if (Number >= 1000)
		{
			tmp_byte = tmp_int / 1000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 1000;
				tmp_byte--;
			}
		}
		if (Number >= 100)
		{
			tmp_byte = tmp_int / 100;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 100;
				tmp_byte--;
			}
		}
		if (Number >= 10)
		{
			tmp_byte = tmp_int / 10;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10;
				tmp_byte--;
			}
		}
		FCD_LCDDisplay0_RawSend('0' + tmp_int, 0x10);

}

void FCD_LCDDisplay0_PrintString(MX_STRING String, MX_UINT8 MSZ_String)
{
	
		MX_UINT8 idx = 0;

		for (idx=0; idx<MSZ_String; idx++)
		{
			if (String[idx] == 0)
			{
				break;
			}
			FCD_LCDDisplay0_RawSend(String[idx], 0x10);
		}

}

void FCD_LCDDisplay0_ScrollDisplay(MX_UINT8 Direction, MX_UINT8 Num_Positions)
{
	
		MX_UINT8 cmd = 0;
		MX_UINT8 count;

		//Choose the direction
		switch (Direction)
		{
			case 0:
			case 'l':
			case 'L':

				cmd = 0x18;
				break;

			case 1:
			case 'r':
			case 'R':

				cmd = 0x1C;
				break;

			default:
				break;
		}

		//If direction accepted then scroll the specified amount
		if (cmd)
		{
			for (count = 0; count < Num_Positions; count++)
				FCD_LCDDisplay0_Command(cmd);
		}

}

void FCD_LCDDisplay0_ClearLine(MX_UINT8 Line)
{
	
		MX_UINT8 count;
		MX_UINT8 rowcount;

		//Define number of columns per line
		#if (LCD_1__ROWCNT == 1)
			rowcount=80;
		#endif

		#if (LCD_1__ROWCNT == 2)
			rowcount=40;
		#endif

		#if (LCD_1__ROWCNT == 4)
			#if (LCD_1__COLCNT == 16)
				rowcount=16;
			#endif
			#if (LCD_1__COLCNT == 20)
				rowcount=20;
			#endif
		#endif

		//Start at beginning of the line
		FCD_LCDDisplay0_Cursor (0, Line);

		//Send out spaces to clear line
		for (count = 0; count < rowcount; count++)
			FCD_LCDDisplay0_RawSend(' ', 0x10);

		//Move back to the beginning of the line.
		FCD_LCDDisplay0_Cursor (0, Line);

}

void FCD_LCDDisplay0_RAM_Write(MX_UINT8 nIdx, MX_UINT8 d0, MX_UINT8 d1, MX_UINT8 d2, MX_UINT8 d3, MX_UINT8 d4, MX_UINT8 d5, MX_UINT8 d6, MX_UINT8 d7)
{
	   //set CGRAM address

	   FCD_LCDDisplay0_RawSend(64 + (nIdx << 3), 0);
	   delay_ms(2);

	   //write CGRAM data
	   FCD_LCDDisplay0_RawSend(d0, 0x10);
	   FCD_LCDDisplay0_RawSend(d1, 0x10);
	   FCD_LCDDisplay0_RawSend(d2, 0x10);
	   FCD_LCDDisplay0_RawSend(d3, 0x10);
	   FCD_LCDDisplay0_RawSend(d4, 0x10);
	   FCD_LCDDisplay0_RawSend(d5, 0x10);
	   FCD_LCDDisplay0_RawSend(d6, 0x10);
	   FCD_LCDDisplay0_RawSend(d7, 0x10);

	   //Clear the display
	   FCD_LCDDisplay0_RawSend(0x01, 0);
	   delay_ms(2);
	   FCD_LCDDisplay0_RawSend(0x02, 0);
	   delay_ms(2);

}

#include "C:\Program Files\Flowcode\v5\CAL\includes.c"

//Implmentations Macro



void main()
{
	//Initialisation
	adcon1 = 0x07;


	//Code Initialisation Interruption
	option_reg = 0xC0;


	//Commentaire:
	//Horloge DCF 77
	//PIC 16F877A
	//LCD 16X2

	//Commentaire:
	//Attente de 1 seconde pour intialisation

	//Pause
	//Pause: 1 s
	delay_s(1);

	//Appel de la Routine Composant
	//Appel de la Routine Composant: Init()
	FCD_LCDDisplay0_Start();

	//Commentaire:
	//Initialisation ou remise  zro
	//des variables

	//Calcul
	//Calcul:
	//  DCF = 0
	//  Compte = 0
	//  Seconde = 0
	FCV_DCF = 0;
	FCV_COMPTE = 0;
	FCV_SECONDE = 0;

	//Boucle
	//Boucle: Tant que 1
	while (1)
	{

		//Commentaire:
		//Premire Boucle:
		//Detection de la 59eme seconde du signal DCF
		//Affichage du signal sur un LED (pin A1)
		//Affiche 'R' sur le LCD pour indiquer qu'il recherche 
		// la 59eme seconde du signal DCF

		//Boucle
		//Boucle: Tant que Compte < 49
		while (1)
		{

			//Appel de la Routine Composant
			//Appel de la Routine Composant: Curseur(15, 1)
			FCD_LCDDisplay0_Cursor(15, 1);

			//Appel de la Routine Composant
			//Appel de la Routine Composant: crit_Caractre("R")
			FCD_LCDDisplay0_PrintASCII('R');

			//Entre
			//Entre: A0 -> DCF
			trisa = trisa | 0x01;
			FCV_DCF = ((porta & 0x01) == 0x01);

			//Sortie
			//Sortie: DCF -> A1
			trisa = trisa & 0xFD;
			if ((FCV_DCF))
				porta = (porta & 0xFD) | 0x02;
			else
				porta = porta & 0xFD;

			//Dcision
			//Dcision: DCF = 0?
			if (FCV_DCF == 0)
			{

				//Calcul
				//Calcul:
				//  Compte = Compte + 1
				FCV_COMPTE = FCV_COMPTE + 1;

			} else {

				//Calcul
				//Calcul:
				//  Compte = 0
				FCV_COMPTE = 0;

			}

			//Pause
			//Pause: 20 ms
			delay_ms(20);


			if ((FCV_COMPTE < 49) == 0) break;
		}

		//Calcul
		//Calcul:
		//  Compte = 0
		FCV_COMPTE = 0;

		//Commentaire:
		//Deuxime boucle:
		//Enregistre le signal DCF reue dans un tableau
		//Impulsion ~200ms = bit 1
		//Impulsion ~100ms = bit 0
		//Affichage du signal sur un LED (pin A1)
		//Affiche 'E' sur le LCD pour indiquer qu'il reoit 
		//et enregistre le signal DCF reue
		//Affiche '1' ou '0' pour indiquer le bit reue

		//Boucle
		//Boucle: Tant que Seconde < 59
		while (1)
		{

			//Appel de la Routine Composant
			//Appel de la Routine Composant: Curseur(15, 1)
			FCD_LCDDisplay0_Cursor(15, 1);

			//Appel de la Routine Composant
			//Appel de la Routine Composant: crit_Caractre("E")
			FCD_LCDDisplay0_PrintASCII('E');

			//Entre
			//Entre: A0 -> DCF
			trisa = trisa | 0x01;
			FCV_DCF = ((porta & 0x01) == 0x01);

			//Sortie
			//Sortie: DCF -> A1
			trisa = trisa & 0xFD;
			if ((FCV_DCF))
				porta = (porta & 0xFD) | 0x02;
			else
				porta = porta & 0xFD;

			//Dcision
			//Dcision: DCF?
			if (FCV_DCF)
			{

			} else {

				//Pause
				//Pause: 150 ms
				delay_ms(150);

				//Entre
				//Entre: A0 -> DCF
				trisa = trisa | 0x01;
				FCV_DCF = ((porta & 0x01) == 0x01);

				//Sortie
				//Sortie: DCF -> A1
				trisa = trisa & 0xFD;
				if ((FCV_DCF))
					porta = (porta & 0xFD) | 0x02;
				else
					porta = porta & 0xFD;

				//Dcision
				//Dcision: DCF = 0?
				if (FCV_DCF == 0)
				{

					//Calcul
					//Calcul:
					//  Signal[Seconde] = 1
					FCV_SIGNAL[FCV_SECONDE] = 1;

				} else {

					//Calcul
					//Calcul:
					//  Signal[Seconde] = 0
					FCV_SIGNAL[FCV_SECONDE] = 0;

				}

				//Appel de la Routine Composant
				//Appel de la Routine Composant: Curseur(15, 0)
				FCD_LCDDisplay0_Cursor(15, 0);

				//Appel de la Routine Composant
				//Appel de la Routine Composant: crit_Nombre(Signal[Seconde])
				FCD_LCDDisplay0_PrintNumber(FCV_SIGNAL[FCV_SECONDE]);

				//Calcul
				//Calcul:
				//  Seconde = Seconde + 1
				FCV_SECONDE = FCV_SECONDE + 1;

				//Boucle
				//Boucle: Tant que DCF = 0
				while (FCV_DCF == 0)
				{

					//Entre
					//Entre: A0 -> DCF
					trisa = trisa | 0x01;
					FCV_DCF = ((porta & 0x01) == 0x01);


				}

			}


			if ((FCV_SECONDE < 59) == 0) break;
		}

		//Calcul
		//Calcul:
		//  Seconde = 0
		FCV_SECONDE = 0;

		//Commentaire:
		//Decoder les bit enregistrer
		//Convertir les bit en valeur

		//
		//Calcul:
		//  Minute_u = Signal[21] + (Signal[22] * 2) + (Signal[23] * 4) + (Signal[24] * 8)
		//  Minute_t = (Signal[25]) + (Signal[26] * 2) + (Signal[27] * 4)
		FCV_MINUTE_U = FCV_SIGNAL[21] + (FCV_SIGNAL[22] * 2) + (FCV_SIGNAL[23] * 4) + (FCV_SIGNAL[24] * 8);
		FCV_MINUTE_T = (FCV_SIGNAL[25]) + (FCV_SIGNAL[26] * 2) + (FCV_SIGNAL[27] * 4);

		//Calcul
		//Calcul:
		//  Heure_u = Signal[29] + (Signal[30] * 2) + (Signal[31] * 4) + (Signal[32] * 8)
		//  Heure_t = (Signal[33]) + (Signal[34] * 2)
		FCV_HEURE_U = FCV_SIGNAL[29] + (FCV_SIGNAL[30] * 2) + (FCV_SIGNAL[31] * 4) + (FCV_SIGNAL[32] * 8);
		FCV_HEURE_T = (FCV_SIGNAL[33]) + (FCV_SIGNAL[34] * 2);

		//Calcul
		//Calcul:
		//  Jour_u = Signal[36] + (Signal[37] * 2) + (Signal[38] * 4) + (Signal[39] * 8)
		//  Jour_t = (Signal[40]) + (Signal[41] * 2)
		FCV_JOUR_U = FCV_SIGNAL[36] + (FCV_SIGNAL[37] * 2) + (FCV_SIGNAL[38] * 4) + (FCV_SIGNAL[39] * 8);
		FCV_JOUR_T = (FCV_SIGNAL[40]) + (FCV_SIGNAL[41] * 2);

		//Calcul
		//Calcul:
		//  Jour_semaine = Signal[42] + (Signal[43] * 2) + (Signal[44] * 4)
		FCV_JOUR_SEMAINE = FCV_SIGNAL[42] + (FCV_SIGNAL[43] * 2) + (FCV_SIGNAL[44] * 4);

		//Calcul
		//Calcul:
		//  Mois_u = Signal[45] + (Signal[46] * 2) + (Signal[47] * 4) + (Signal[48] * 8)
		//  Mois_t = Signal[49]
		FCV_MOIS_U = FCV_SIGNAL[45] + (FCV_SIGNAL[46] * 2) + (FCV_SIGNAL[47] * 4) + (FCV_SIGNAL[48] * 8);
		FCV_MOIS_T = FCV_SIGNAL[49];

		//Calcul
		//Calcul:
		//  Ans_u = Signal[50] + (Signal[51] * 2) + (Signal[52] * 4) + (Signal[53] * 8)
		//  Ans_t = (Signal[54]) + (Signal[55] * 2) + (Signal[56] * 4) + (Signal[57] * 8)
		FCV_ANS_U = FCV_SIGNAL[50] + (FCV_SIGNAL[51] * 2) + (FCV_SIGNAL[52] * 4) + (FCV_SIGNAL[53] * 8);
		FCV_ANS_T = (FCV_SIGNAL[54]) + (FCV_SIGNAL[55] * 2) + (FCV_SIGNAL[56] * 4) + (FCV_SIGNAL[57] * 8);

		//Appel de la Routine Composant
		//Appel de la Routine Composant: Curseur(0, 0)
		FCD_LCDDisplay0_Cursor(0, 0);

		//Commentaire:
		//Verification des donnes reue :
		//Si elles sont fausses:
		//Affiche "Erreur code reu" 
		//Si elle sont correctes:
		//Affichage du temps et de la date sur le LCD

		//Dcision
		//Dcision: ((Minute_t * 10) + Minute_u) > 59?
		if (((FCV_MINUTE_T * 10) + FCV_MINUTE_U) > 59)
		{

			//Appel de la Routine Composant
			//Appel de la Routine Composant: Effacer()
			FCD_LCDDisplay0_Clear();

			//Appel de la Routine Composant
			//Appel de la Routine Composant: crit_Chane("Erreur Code reu")
			FCD_LCDDisplay0_PrintString("Erreur Code reu", 16);

		} else {

			//Dcision
			//Dcision: ((Jour_t * 10) + Jour_u) > 31?
			if (((FCV_JOUR_T * 10) + FCV_JOUR_U) > 31)
			{

				//Appel de la Routine Composant
				//Appel de la Routine Composant: Effacer()
				FCD_LCDDisplay0_Clear();

				//Appel de la Routine Composant
				//Appel de la Routine Composant: crit_Chane("Erreur code reu")
				FCD_LCDDisplay0_PrintString("Erreur code reu", 16);

			} else {

				//Dcision
				//Dcision: ((Mois_t * 10) + Mois_u) > 12?
				if (((FCV_MOIS_T * 10) + FCV_MOIS_U) > 12)
				{

					//Appel de la Routine Composant
					//Appel de la Routine Composant: Effacer()
					FCD_LCDDisplay0_Clear();

					//Appel de la Routine Composant
					//Appel de la Routine Composant: crit_Chane("Erreur code reu")
					FCD_LCDDisplay0_PrintString("Erreur code reu", 16);

				} else {

					//Dcision
					//Dcision: ((Ans_t * 10) + Ans_u) > 99?
					if (((FCV_ANS_T * 10) + FCV_ANS_U) > 99)
					{

						//Appel de la Routine Composant
						//Appel de la Routine Composant: Effacer()
						FCD_LCDDisplay0_Clear();

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Chane("Erreur code reu")
						FCD_LCDDisplay0_PrintString("Erreur code reu", 16);

					} else {

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Chane("T:   :          ")
						FCD_LCDDisplay0_PrintString("T:   :          ", 16);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: Curseur(3, 0)
						FCD_LCDDisplay0_Cursor(3, 0);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Nombre(Heure_t)
						FCD_LCDDisplay0_PrintNumber(FCV_HEURE_T);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Nombre(Heure_u)
						FCD_LCDDisplay0_PrintNumber(FCV_HEURE_U);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: Curseur(6, 0)
						FCD_LCDDisplay0_Cursor(6, 0);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Nombre(Minute_t)
						FCD_LCDDisplay0_PrintNumber(FCV_MINUTE_T);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Nombre(Minute_u)
						FCD_LCDDisplay0_PrintNumber(FCV_MINUTE_U);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: Curseur(0, 1)
						FCD_LCDDisplay0_Cursor(0, 1);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Chane("D:   /  /20     ")
						FCD_LCDDisplay0_PrintString("D:   /  /20     ", 16);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: Curseur(3, 1)
						FCD_LCDDisplay0_Cursor(3, 1);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Nombre(Jour_t)
						FCD_LCDDisplay0_PrintNumber(FCV_JOUR_T);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Nombre(Jour_u)
						FCD_LCDDisplay0_PrintNumber(FCV_JOUR_U);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Nombre(Mois_t)
						FCD_LCDDisplay0_PrintNumber(FCV_MOIS_T);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Nombre(Mois_u)
						FCD_LCDDisplay0_PrintNumber(FCV_MOIS_U);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: Curseur(11, 1)
						FCD_LCDDisplay0_Cursor(11, 1);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Nombre(Ans_t)
						FCD_LCDDisplay0_PrintNumber(FCV_ANS_T);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: crit_Nombre(Ans_u)
						FCD_LCDDisplay0_PrintNumber(FCV_ANS_U);

						//Appel de la Routine Composant
						//Appel de la Routine Composant: Curseur(11, 0)
						FCD_LCDDisplay0_Cursor(11, 0);

						//Dcision
						//Dcision: Jour_semaine = 1?
						if (FCV_JOUR_SEMAINE == 1)
						{

							//Appel de la Routine Composant
							//Appel de la Routine Composant: crit_Chane("Lu")
							FCD_LCDDisplay0_PrintString("Lu", 2);

						} else {

							//Dcision
							//Dcision: Jour_semaine = 2?
							if (FCV_JOUR_SEMAINE == 2)
							{

								//Appel de la Routine Composant
								//Appel de la Routine Composant: crit_Chane("Ma")
								FCD_LCDDisplay0_PrintString("Ma", 2);

							} else {

								//Dcision
								//Dcision: Jour_semaine = 3?
								if (FCV_JOUR_SEMAINE == 3)
								{

									//Appel de la Routine Composant
									//Appel de la Routine Composant: crit_Chane("Me")
									FCD_LCDDisplay0_PrintString("Me", 2);

								} else {

									//Dcision
									//Dcision: Jour_semaine = 4?
									if (FCV_JOUR_SEMAINE == 4)
									{

										//Appel de la Routine Composant
										//Appel de la Routine Composant: crit_Chane("Je")
										FCD_LCDDisplay0_PrintString("Je", 2);

									} else {

										//Dcision
										//Dcision: Jour_semaine = 5?
										if (FCV_JOUR_SEMAINE == 5)
										{

											//Appel de la Routine Composant
											//Appel de la Routine Composant: crit_Chane("Ve")
											FCD_LCDDisplay0_PrintString("Ve", 2);

										} else {

											//Dcision
											//Dcision: Jour_semaine = 6?
											if (FCV_JOUR_SEMAINE == 6)
											{

												//Appel de la Routine Composant
												//Appel de la Routine Composant: crit_Chane("Sa")
												FCD_LCDDisplay0_PrintString("Sa", 2);

											} else {

												//Dcision
												//Dcision: Jour_semaine = 7?
												if (FCV_JOUR_SEMAINE == 7)
												{

													//Appel de la Routine Composant
													//Appel de la Routine Composant: crit_Chane("Di")
													FCD_LCDDisplay0_PrintString("Di", 2);

												} else {

													//Commentaire:
													//Si erreur :
													//Affiche '//'

													//Appel de la Routine Composant
													//Appel de la Routine Composant: crit_Chane("//")
													FCD_LCDDisplay0_PrintString("//", 2);

												}

											}

										}

									}

								}

							}

						}

					}

				}

			}

		}


	}

	mainendloop: goto mainendloop;
}

void MX_INTERRUPT_MACRO(void)
{
}



