//quick auto configure for different tcp/ip demo boards
#define STACK_USE_CCS_PICNET        0  //PICNET rev 0-2 board sold by CCS.  Has a 56K modem and a 10BaseT Network IC and 18F6620
#define STACK_USE_CCS_PICNET3       0  //PICNET rv 3 and up board sold by CCS.  Has a 56K modem and a 10BaseT Network IC and 18F8622
#define STACK_USE_CCS_PICENS        1  //CCS PICENS (Embedded Ethernet) development kit.  18F4620 + ENC28J60
#define STACK_USE_CCS_PICEEC        0  //CCS PICEEC (Embedded Ethernet) development kit.  18F67J60
#define STACK_USE_CCS_EWL5V         0  //CCS 5V EZ Web Lynx Device
#define STACK_USE_CCS_EWL5V_REV2    0  //CCS 5V EZ Web Lynx Device (REV2, PCB is marked REV3)
#define STACK_USE_CCS_EWL3V         0  //CCS 3.3V EZ Web Lynx Device

/////////////// end user configuration

//You must set one (and only) one of these to TRUE to tell the stack what hardware layer you are using
#define STACK_USE_MAC   1      //use the nic card
#define STACK_USE_PPP   0     //use PPP on modem
#define STACK_USE_SLIP  0    //use slip (NOT TESTED)


/// *** END USER CONFIGURABLE DEFINITIONS

#if STACK_USE_CCS_EWL5V || STACK_USE_CCS_EWL3V || STACK_USE_CCS_EWL5V_REV2
   #define STACK_USE_CCS_EWL  1
#else
   #define STACK_USE_CCS_EWL  0
#endif

#if ((STACK_USE_CCS_PICENS+STACK_USE_CCS_PICNET3+STACK_USE_CCS_PICNET+STACK_USE_CCS_PICEEC+STACK_USE_CCS_EWL5V+STACK_USE_CCS_EWL3V+STACK_USE_CCS_EWL5V_REV2) > 1)
 #error You can only use one hardware definition
#endif

#if ((STACK_USE_CCS_PICENS+STACK_USE_CCS_PICNET3+STACK_USE_CCS_PICNET+STACK_USE_CCS_PICEEC+STACK_USE_CCS_EWL5V+STACK_USE_CCS_EWL3V+STACK_USE_CCS_EWL5V_REV2) == 0)
 #error You must define one hardware definition
#endif

#if STACK_USE_CCS_PICNET3
 #undef STACK_USE_CCS_PICNET
 #define STACK_USE_CCS_PICNET 1
#endif


#if STACK_USE_CCS_PICNET3
 #include <18f6722.h>
 #use delay(clock=40000000)
 #fuses H4
 #fuses CCP2C1
 #fuses MCLR

 #define LCD_ENABLE_PIN  PIN_D0
 #define LCD_RS_PIN      PIN_D1
 #define LCD_RW_PIN      PIN_D2
 #define LCD_DATA4       PIN_D4
 #define LCD_DATA5       PIN_D5
 #define LCD_DATA6       PIN_D6
 #define LCD_DATA7       PIN_D7
#endif

#if STACK_USE_CCS_PICNET && !STACK_USE_CCS_PICNET3
 #include <18f6720.h>
 #use delay(clock=20000000) //CCS picnet is 20Mhz
 #fuses HS
 #fuses CCP2C1

 #define LCD_ENABLE_PIN  PIN_D0
 #define LCD_RS_PIN      PIN_D1
 #define LCD_RW_PIN      PIN_D2
 #define LCD_DATA4       PIN_D4
 #define LCD_DATA5       PIN_D5
 #define LCD_DATA6       PIN_D6
 #define LCD_DATA7       PIN_D7
#endif

#if STACK_USE_CCS_PICENS
 #include <18f4620.h>
 #use delay(clock=40000000)
 #fuses H4
 #fuses NOFCMEN
 #fuses NOXINST
 #fuses NOIESO
 #fuses NOPBADEN
 #fuses MCLR

 #define LCD_ENABLE_PIN  PIN_E2
 #define LCD_RS_PIN      PIN_E0
 #define LCD_RW_PIN      PIN_E1
 #define LCD_DATA4       PIN_D4
 #define LCD_DATA5       PIN_D5
 #define LCD_DATA6       PIN_D6
 #define LCD_DATA7       PIN_D7
#endif

#if STACK_USE_CCS_PICEEC
 #include <18F67J60.H>
 #use delay(clock=25M)
 #fuses HS
 #fuses NOIESO
 #fuses NOFCMEN
 #fuses PRIMARY
 #fuses ETHLED

 #define LCD_ENABLE_PIN  PIN_F3
 #define LCD_RS_PIN      PIN_F1
 #define LCD_RW_PIN      PIN_F2
 #define LCD_DATA4       PIN_F4
 #define LCD_DATA5       PIN_F5
 #define LCD_DATA6       PIN_F6
 #define LCD_DATA7       PIN_F7
#endif

#if STACK_USE_CCS_EWL3V
 #include <18F67J60.H>
 #use delay(clock=25M)
 #fuses HS
 #fuses NOIESO
 #fuses NOFCMEN
 #fuses PRIMARY
 #fuses ETHLED
#endif

#if STACK_USE_CCS_EWL5V
 #include <18F2685.H>
 #use delay(clock=25M)
 #fuses HS
 #fuses NOPBADEN
 #fuses MCLR
#endif

#if STACK_USE_CCS_EWL5V_REV2
 #include <18f6722.H>
 #use delay(clock=25M)
 #fuses HS
 #fuses MCLR
 #fuses NOPROTECT
#endif

#fuses NOWDT
#fuses NOPROTECT
#fuses NODEBUG
#fuses NOSTVREN

#if !(STACK_USE_CCS_PICEEC||STACK_USE_CCS_EWL3V)
 #fuses PUT
 #fuses NOLVP
 #fuses NOBROWNOUT
 #fuses NOCPD
 #fuses WRT
 #fuses NOWRTD
 #fuses NOEBTR
 #fuses NOCPB
 #fuses NOEBTRB
 #fuses WRTB
#endif

//set to true to put out information on the LCD screen
#if STACK_USE_CCS_EWL
 //due to limited IO space on the ezweblynx, we will not use LCD
 #define STACK_USE_PICDEM_LCD     FALSE     
#else
 #define STACK_USE_PICDEM_LCD     TRUE
#endif


#if STACK_USE_MAC
 #define STACK_USE_DHCP  TRUE  //for auto resolution of IP address
 #define STACK_USE_ARP   TRUE  //needed to resolve MAC addresses of IP addresses
#endif

#if (STACK_USE_CCS_PICENS||STACK_USE_CCS_EWL5V||STACK_USE_CCS_EWL5V_REV2) && STACK_USE_MAC
 #define STACK_USE_MCPENC  TRUE     //tell the stack to use the ENC28J60 driver
#else
 #define STACK_USE_MCPENC  FALSE    //tell the stack to use the Realtek driver
#endif

#if (STACK_USE_CCS_PICEEC||STACK_USE_CCS_EWL3V) && STACK_USE_MAC
 #define STACK_USE_MCPINC  TRUE
#else
 #define STACK_USE_MCPINC  FALSE
#endif

#if STACK_USE_PPP
   #if STACK_USE_HTTP2
      #define MAC_TX_BUFFER_SIZE 512
   #endif

   #undef STACK_USE_ARP
   #define STACK_USE_ARP FALSE
#endif

#define STACK_USE_IP_GLEANING FALSE

#ifndef STACK_USE_SERIAL
   #define STACK_USE_SERIAL TRUE
#endif

#if STACK_USE_SERIAL
 #use rs232(baud=9600, UART1, STREAM=STREAM_UI, errors)

void putc_ui(char c)
{
   fputc(c, STREAM_UI);
}

int1 g_DeepDebug = FALSE;
void DebugPutc(char c)
{
   if (g_DeepDebug)
      fputc(c, STREAM_UI);
} 
#endif

#if STACK_USE_CCS_PICEEC
 #define EXT_FLASH_PIN_SCL     PIN_C3 //o
 #define EXT_FLASH_PIN_SDI     PIN_C4 //i
 #define EXT_FLASH_PIN_SDA     PIN_C5 //o
 #define EXT_FLASH_PIN_SELECT  PIN_C2 //o
#endif

//#use rs232(baud=9600, xmit=PIN_C6,rcv=PIN_C7, STREAM=USER)

//include Microchip's TCP/IP stack
#include "tcpip/stacktsk.c"

//include CCS's PICDEM.net/PICNET helper functions
#include "ccshelper.c"
#include "ccshelperui.c"
