///////////////////////////////////////////////////////////////////////////
////                                                                   ////
////                      EX_ST_WESERVER.C                             ////
////                                                                   ////
//// An example program demonstrating using Microchip's TCP/IP stack   ////
//// with CCS's PCH C Compiler.                                        ////
////                                                                   ////
///////////////////////////////////////////////////////////////////////////
////                                                                   ////
//// ABOUT CCS TCP/IP EXAMPLES:                                        ////
////                                                                   ////
//// Connect your prototype board to serial cable, and open a serial   ////
//// connection at 9600bps.  With this link you can change all the     ////
//// ethernet and PPP settings.  You can also see the current status   ////
//// of the TCP/IP link.  Pressing any key will bring up the menu.     ////
////                                                                   ////
//// If you are using PPP, you will need to initiate and disconnect a  ////
//// PPP connection using this serial link.  Until PPP is connected    ////
//// the board will not be connected to TCP/IP.                        ////
////                                                                   ////
//// If the LCD is enabled in the code (it is enabled by default), the ////
//// last line displayed will be IP address of the unit.  If your      ////
//// ISP / Network doesn't filter ICMP/PING you can use the PING       ////
//// utility to test your connection.  If the last line doesn't        ////
//// display the IP address then the unit is connected (PPP not        ////
//// connected, ethernet cable not connected, a problem with ethernet  ////
//// DHCP, etc).                                                       ////
////                                                                   ////
//// CAUTION: All settings are saved to the external EEPROM.  If you   ////
//// are using the Microchip PICDEM.net board that has an example      ////
//// file-system with webpages it will be deleted/corrupted by these   ////
//// examples.                                                         ////
////                                                                   ////
///////////////////////////////////////////////////////////////////////////
////                                                                   ////
//// RELEASE HISTORY:                                                  ////
////                                                                   ////
//// Sep 20, 2006 -                                                    ////
////     Updated and tested with Microchip's 3.02 stack.               ////
////                                                                   ////
//// Apr 28, 2006 -                                                    ////
////     Tested on PCH 3.249                                           ////
////     Fixed broken link for CCS logo                                ////
////     Added test routine                                            ////
////     Changed to 18F4620                                            ////
////                                                                   ////
//// Mar 06, 2006 -                                                    ////
////     Updated for CCS PICENS Board                                  ////
////                                                                   ////
///////////////////////////////////////////////////////////////////////////
////        (C) Copyright 1996,2006 Custom Computer Services           ////
//// This source code may only be used by licensed users of the CCS C  ////
//// compiler.  This source code may only be distributed to other      ////
//// licensed users of the CCS C compiler.  No other use, reproduction ////
//// or distribution is permitted without written permission.          ////
//// Derivative programs created using this software in object code    ////
//// form are not restricted in any way.                               ////
///////////////////////////////////////////////////////////////////////////

#define STACK_USE_ICMP        1   //Enabled for ping support
#define STACK_USE_TCP         1   //To send TCP packets (talk to HTTP clients)
#define STACK_USE_HTTP        1   //Enable the CCS webserver

#include "ex_st_common.h"

//#include "tcpip/stacktsk.c"

#define MY_HTTP_SOCKET  80

//int8 HTTPSocket=INVALID_SOCKET;

// Microchip VendorID, MAC: 00-04-A3-XX-XX-XX
void MACAddrInit(void)
{
   MY_MAC_BYTE1=0xA1;
   MY_MAC_BYTE2=0xB4;
   MY_MAC_BYTE3=0xA3;
   MY_MAC_BYTE4=0xC7;
   MY_MAC_BYTE5=0xD8;
   MY_MAC_BYTE6=0xE1;
}


void IPAddrInit(void)
{
   //IP Direto
   MY_IP_BYTE1=192;
   MY_IP_BYTE2=168;
   MY_IP_BYTE3=1;
   MY_IP_BYTE4=100;

   //Porta de Enlace
   MY_GATE_BYTE1=192;
   MY_GATE_BYTE2=168;
   MY_GATE_BYTE3=1;
   MY_GATE_BYTE4=1;

   //Mascara de Subred
   MY_MASK_BYTE1=255;
   MY_MASK_BYTE2=255;
   MY_MASK_BYTE3=255;
   MY_MASK_BYTE4=0;
}

/////***** WEB PAGES STORED INTO PROGRAM MEMORY *****/////

//The following escape characters are used:
//  %0 - AN0
//  %1 - AN1
//  %2 - BUTTON0
//  %3 - BUTTON1
//  %4 - Current LCD Message
//  %5 - CHECKED if LED1 is ON
//  %6 - CHECKED if LED1 is OFF
//  %7 - CHECKED if LED2 is ON
//  %8 - CHECKED if LED2 is OFF
//  %9 - Temperature (EWL ONLY)
//  %F - Message stack

//here is this examples / page
const char  HTML_INDEX_PAGE[]=
"<html><body bgcolor=#FFFFFF text=#000000>
<img src=\"http://www.ccsinfo.com/images/CCSlogotiny.gif\">
<br/>
<h1>CCS HTTP/CGI EXAMPLE</h1>
<p><b><i>%F</i></b></p>
<form method=post>
<table border=0>
<tr><th>LCD:</th><td colspan=4><input type=\"text\" name=\"lcd\" size=20 maxlength=16 value=\"%4\"></td></tr>
<tr><th>LED1:</th><td><input type=\"radio\" name=\"led1\" value=1 %5></td><td>ON</td>
   <td><input type=\"radio\" name=\"led1\" value=0 %6></td><td>OFF</td></tr>
<tr><th>LED2:</th><td><input type=\"radio\" name=\"led2\" value=1 %7></td><td>ON</td>
   <td><input type=\"radio\" name=\"led2\" value=0 %8></td><td>OFF</td></tr>
</table>
<input type=\"hidden\" name=\"msgStack\" value=\"LCD/LEDs changed!\">
<br/><input type=\"submit\"></form>
<p><a href=\"/analog\">Analog Readings</a></p>
</body></html>";

const char  HTML_ANALOG_PAGE[]=
"<html><body bgcolor=#ffffff text=#000000>
<img src=\"http://www.ccsinfo.com/images/CCSlogotiny.gif\">
<h1>PICNET ADC READINGS</h1>
<p>%0</p>
<br/>%1
<p>%2</p>
<br/>%3
<p>%9</p>
<p><a href=\"/\">Change LCD/LEDs</a></p>
</body></html>";

/////***** END OF WEB PAGES STORED INTO PROGRAM MEMORY *****/////

char g_HTTPMessageStack[20]="";
char g_HTTPLCDMessage[20]="CCS Webserver";
int8 g_LEDState[2]={0,0};

//this is a callback function to the HTTP stack.  see http.c
//this demo provides to web "pages", an index (/) and an about page (/about)
int32 http_get_page(char *file_str)
{
   int32 file_loc=0;
   static char index[]="/";
   static char about[]="/analog";

   if (stricmp(file_str,index)==0)
      file_loc=label_address(HTML_INDEX_PAGE);

   else if (stricmp(file_str,about)==0)
      file_loc=label_address(HTML_ANALOG_PAGE);

   return(file_loc);
}

//this isn't a required callback, this is an application function being
//used by http_format_char.
int http_format_char_checked(int8 flag, char *str)
{
   int len=0;

   if (flag)
   {
      sprintf(str,"checked=\"checked\"");
      len = 7;
   }

   return(len);
}

//this is a callback function to the HTTP stack. see http.c
//The following escape characters are used:
//  %0 - AN0
//  %1 - AN1
//  %2 - BUTTON0
//  %3 - BUTTON1
//  %4 - Current LCD Message
//  %5 - CHECKED if LED1 is ON
//  %6 - CHECKED if LED1 is OFF
//  %7 - CHECKED if LED2 is ON
//  %8 - CHECKED if LED2 is OFF
//  %F - Message stack
int8 http_format_char(int32 file, char id, char *str, int8 max_ret) {
   char new_str[25];
   int8 len=0;
   int8 i;

  switch(id) {
#if defined(ADC_CHAN_0)
      case '0':
         set_adc_channel(ADC_CHAN_0);
         delay_us(100);
         i=read_adc();
         sprintf(new_str,"<B>AN%U = </B>0x%X",ADC_CHAN_0,i);
         len=strlen(new_str);
         break;
#endif
#if defined(ADC_CHAN_1)
      case '1':
         set_adc_channel(ADC_CHAN_1);
         delay_us(100);
         i=read_adc();
         sprintf(new_str,"<B>AN%U = </B>0x%X",ADC_CHAN_1,i);
         len=strlen(new_str);
         break;
#endif
#if defined(USER_BUTTON1)
      case '2':
         sprintf(new_str,"<B>BTN1 = </B>");
         if (!BUTTON_PRESSED(USER_BUTTON1))
            sprintf(&new_str[14], "UP");
         else
            sprintf(&new_str[14], "DOWN");
         len=strlen(new_str);
         break;
#endif
#if defined(USER_BUTTON2)
      case '3':
         sprintf(new_str,"<B>BTN2 = </B>");
         if (!BUTTON_PRESSED(USER_BUTTON2))
            sprintf(&new_str[14], "UP");
         else
            sprintf(&new_str[14], "DOWN");
         len=strlen(new_str);
         break;
#endif

      case '4':
         strncpy(new_str, g_HTTPLCDMessage, sizeof(new_str));
         new_str[sizeof(new_str)-1] = 0;
         len = strlen(new_str);
         break;

      case '5':
         len = http_format_char_checked(g_LEDState[0], new_str);
         break;

      case '6':
         len = http_format_char_checked(!g_LEDState[0], new_str);
         break;

      case '7':
         len = http_format_char_checked(g_LEDState[1], new_str);
         break;

      case '8':
         len = http_format_char_checked(!g_LEDState[1], new_str);
         break;

#if STACK_USE_CCS_EWL
      case '9':
       #if STACK_USE_TEMP
         sprintf(new_str, "Temp: %6.2w&ordm F", read_full_temp());
       #else
         sprintf(new_str, "Temp: DISABLED");
       #endif
         len=strlen(new_str);
         new_str[len]=0;
         break;
#endif
      case 'F':
         strncpy(new_str, g_HTTPMessageStack, sizeof(new_str));
         new_str[sizeof(new_str)-1] = 0;
         len = strlen(new_str);
         g_HTTPMessageStack[0] = 0;
         break;
   }

   if (len){
      strncpy(str, new_str, max_ret);
   }else
      *str=0;

   return(len);
}

//this is a callback function to the HTTP stack. see http.c
//in this example it verifies that "pwd" is "master", if it is
//then it sets led1 and led2 ("led1" and "led2") based on their value
//and changes the lcd screen ("lcd").
void http_exec_cgi(int32 file, char *key, char *val) {
   static char led1_key[]="led1";
   static char led2_key[]="led2";
   static char lcd_key[]="lcd";
   static char msgStack_key[]="msgStack";
   int8 v;

// #if defined(USER_LED1)
   if (stricmp(key,led1_key)==0) {
      v=atoi(val);
      g_LEDState[0]=v;
   }
// #endif

// #if defined(USER_LED2)
   if (stricmp(key,led2_key)==0) {
      v=atoi(val);
      g_LEDState[1]=v;
   }
// #endif

   if (stricmp(key, msgStack_key)==0)
   {
      strncpy(g_HTTPMessageStack, val, sizeof(g_HTTPMessageStack));
      g_HTTPMessageStack[sizeof(g_HTTPMessageStack)-1] = 0;
   }

   if (stricmp(key,lcd_key)==0) {
      strncpy(g_HTTPLCDMessage, val, sizeof(g_HTTPLCDMessage));
      g_HTTPLCDMessage[sizeof(g_HTTPLCDMessage)-1] = 0;
#if STACK_USE_PICDEM_LCD
      printf(lcd_putc,"\f%s",val);
#endif
   }
}

void splash(void)
{
  #if STACK_USE_PICDEM_LCD
   printf(lcd_putc,"\fCCS Webserver");
  #ENDIF
 #if STACK_USE_ANNOUNCE
   InitAnnounce(" - EX_ST_WEBSERVER");
 #endif
 #if STACK_USE_SERIAL
   fprintf(STREAM_UI,"\r\n\r\nCCS ex_st_webserver\r\n");
   ui_settings();
   ui_menu();
 #endif
}

void MAIN()
{
   init();
   splash();

  #if STACK_USE_WLAN
   if (MACInitError())
   {
      fprintf(STREAM_UI, "\r\n\nMAC INIT: ERROR!!!\r\n\n");
   }
  #endif

   while (TRUE)
   {
      restart_wdt();

     #if STACK_USE_SERIAL
      if (kbhit(STREAM_UI)) {
         ui_handle();
      }
     #endif

      //every second: refresh current IP, blink LED
      if (second_counter>=1) {
         display_ip_lcd();
        #if defined(USER_LED3)
         output_toggle(USER_LED3);
        #endif
         second_counter=0;
      }

      if (g_LEDState[0])
         output_low(USER_LED1);
      else
         output_high(USER_LED1);
      if (g_LEDState[1])
         output_low(USER_LED2);
      else
         output_high(USER_LED2);

     #if (defined(USER_BUTTON1) && defined(USER_LED1))
      if (BUTTON_PRESSED(USER_BUTTON1)) output_low(USER_LED1);
     #endif

     #if (defined(USER_BUTTON2) && defined(USER_LED2))
      if (BUTTON_PRESSED(USER_BUTTON2)) output_low(USER_LED2);
     #endif


      #if STACK_USE_PPP
      if (ppp_is_connected())
      #endif
      StackTask();            //Microchip's TCP/IP stack handler.  Must be called routinely.
   }
}

