/*********************************************************************
 *
 *                  Helper Function Defs for Microchip TCP/IP Stack
 *                 (Modified to work with CCS PCH, by CCS)
 *
 *********************************************************************
 * FileName:        Helpers.h
 * Dependencies:    stacktsk.h
 * Processor:       PIC18
 * Complier:        CCS PCH 3.181 or higher
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the Company) for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * Author               Date     Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Nilesh Rajbharti     5/17/01  Original        (Rev 1.0)
 * Nilesh Rajbharti     2/9/02   Cleanup
 * Darren Rook (CCS)    01/09/04 Initial CCS Public Release
 * Darren Rook (CCS)    05/24/04 swaps() and swapl() optimized
 * Darren Rook (CCS)    07/13/06 In synch with Microchip's V3.02 stack [no changes]
 * Darren Rook (CCS)    10/24/06 In synch with Microchip's V3.75 stack
 ********************************************************************/

#ifndef HELPERS_H
#define HELPERS_H

#include "tcpip/stacktsk.h"

#if defined(__C30__) || defined(HI_TECH_C)
void    itoa(unsigned int Value, char* Buffer);
char *strupr(char *s);
#endif

BYTE    ReadStringUART(BYTE *Dest, BYTE BufferLen);
BYTE   hexatob(WORD_VAL AsciiChars);
BYTE   btohexa_high(BYTE b);
BYTE   btohexa_low(BYTE b);

WORD    swaps(WORD_VAL v);
DWORD   swapl(DWORD_VAL v);

WORD    CalcIPChecksum(BYTE *buffer, WORD len);
WORD    CalcIPBufferChecksum(WORD len);

// convert a value to little endian from compiler's native format
#define  TO_LITTLE_ENDIAN16(x)   x

// convert a value to compiler's native format from little endian
#define  FROM_LITTLE_ENDIAN16(x)   x

// convert a value to big endian from compiler's native format
#define TO_BIG_ENDIAN16(x) swaps(x)

// convert a value to compiler's native format from big endian
#define FROM_BIG_ENDIAN16(x) swaps(x)

// Macro for finding the LSB or MSB of a 16bit value.
#define LSB(x) make8(x,0)
#define MSB(x) make8(x,1)

#define MIN(x,y) ((x<y)?x:y)
#define MAX(x,y) ((x>y)?x:y)

#define BIT(x) (1<<x)

#endif
