;*******************************************
;* PICBASIC.EXE version 3.18 (Win32 Console)  du 12/02/2006
;*         Compatible Basic Stamp
;* Auteur: Deaubonne Patrick 
;* Email:  Pat.Deaubonne@wanadoo.fr
;* url:
;*   http://perso.wanadoo.fr/pat.deaubonne
;*        ' '              /pic/index.htm
;*******************************************
;* C:\PIC\PICBASIC\bartelec.ASM
;*******************************************

W	equ	00
F	equ	01

CY	equ	00
Z	equ	02
;' v * * * * * * * * * * * * * * debut d'entte * * * * * * * * * * * * * * v
;' nom           : bartelec.bas
;' Alias                 : 
;' crer   le    : 21 / 08 / 2007
;' Modifier le   : 21 / 08 / 2007
;' Cr Par      : Deaubonne Patrick
;' 
;' commentaire: 
;'
;'
;' ^ * * * * * * * * * * * * * * * fin d'entte * * * * * * * * * * * * * * ^
;-------- define PORTB 6 --------
PORTB	EQU	6
;-------- define FSR 4 --------
FSR	EQU	4
;-------- asm { --------
w_temp          EQU 04CH ; svg registre W
status_temp     EQU 04DH ; svg status swapp
FSR_temp        EQU 04EH ; svg FSR
PCLATH_temp     EQU 04FH ; svg PCLATH
;}
;-------- device  16f84 --------

	List	p=16F84 ,r=DEC

#include <P16F84.INC>

bnk0	macro
	bcf	STATUS,RP0
	bcf	STATUS,RP1
	endm

bnk1	macro
	bsf	STATUS,RP0
	bcf	STATUS,RP1
	endm

bnk2	macro
	bcf	STATUS,RP0
	bsf	STATUS,RP1
	endm

bnk3	macro
	bsf	STATUS,RP0
	bsf	STATUS,RP1
	endm

w_temp  	EQU 071H ; svg registre W
status_temp	EQU 072H ; svg status swapp
FSR_temp	EQU 073H ; svg FSR
PCLATH_temp	EQU 074H ; svg PCLATH

	goto _START_PIC
	nop
	nop
	nop
	GOTO _INT_PIC
_START_PIC
;-------- ASM { __CONFIG  03FF9H } --------
 __CONFIG  03FF9H 
;-------- Dim ATMP,itmp,nb,l,Pulse --------
ATMP	equ	23
ITMP	equ	24
NB	equ	25
LTMP	equ	26
PULSE	equ	27
;' = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = 
;-------- Init portA = 11100000 --------
	bsf	STATUS,RP0
	movlw	224
	movwf	TRISA
	bcf	STATUS,RP0
;-------- Init portb = 00000001 --------
	bsf	STATUS,RP0
	movlw	1
	movwf	TRISB
	bcf	STATUS,RP0
;-------- asm { --------
        bsf STATUS,rp0
        movlw   3
        movwf OPTION_REG ; prescaler / 8
        bsf OPTION_REG,INTEDG ; front montant
        bcf STATUS,rp0
      bsf   INTCON,INTE
      bsf   INTCON,T0IE
      bsf   INTCON,GIE
;}
;-------- portA = 0 --------
	clrw
	movwf	PORTA
;-------- portB = 0 --------
	clrw
	movwf	PORTB
;-------- pulse = 0x40 --------
	movlw	64
	movwf	PULSE
;-------- A = 2 --------
	movlw	2
	movwf	ATMP
;-------- FOR i = 0 to 7 --------
	clrf	ITMP
pb_lab1
;-------- portb = A --------
	movf	ATMP,W
	movwf	PORTB
;-------- delayms( 50 ) --------
	movlw	50
	call	_DELAYMS
;-------- A = a + A --------
	movf	ATMP,W
	addwf	ATMP,W
	movwf	ATMP
;-------- next i --------
	incf	ITMP,F
	movlw	7
	movwf	12
	movf	ITMP,W
	subwf	12,W
	btfss	STATUS,Z
	goto	pb_lab1
;-------- portb = 0 --------
	clrw
	movwf	PORTB
;-------- A = 1 --------
	movlw	1
	movwf	ATMP
;-------- portA = A --------
	movf	ATMP,W
	movwf	PORTA
;-------- delayms( 50 ) --------
	movlw	50
	call	_DELAYMS
;-------- A = 2 --------
	movlw	2
	movwf	ATMP
;-------- portA = A --------
	movf	ATMP,W
	movwf	PORTA
;-------- delayms( 50 ) --------
	movlw	50
	call	_DELAYMS
;-------- A = 4 --------
	movlw	4
	movwf	ATMP
;-------- portA = A --------
	movf	ATMP,W
	movwf	PORTA
;-------- delayms( 50 ) --------
	movlw	50
	call	_DELAYMS
;-------- portA = 0 --------
	clrw
	movwf	PORTA
;-------- loop:  --------
LOOP
;-------- i = 1 --------
	movlw	1
	movwf	ITMP
;-------- if pulse< 66 then --------
	movlw	66
	subwf	PULSE,W
	btfsc	STATUS,CY
	goto	pb_lab6
;-------- pulse = 66 --------
	movlw	66
	movwf	PULSE
;-------- endif --------
pb_lab6
;-------- if pulse> 120 then --------
	movlw	120
	subwf	PULSE,W
	btfss	STATUS,CY
	goto	pb_lab7
;-------- pulse = 120 --------
	movlw	120
	movwf	PULSE
;-------- endif --------
pb_lab7
;-------- l = pulse -66 --------
	movlw	66
	movwf	12
	Subwf	PULSE,W
	movwf	LTMP
;-------- Div6:  --------
DIV6
;-------- if l> 6 then --------
	movlw	6
	subwf	LTMP,W
	btfss	STATUS,CY
	goto	pb_lab8
;-------- l = l -6 --------
	movlw	6
	movwf	12
	Subwf	LTMP,W
	movwf	LTMP
;-------- i = i + 1 --------
	incf	ITMP,F
;-------- goto Div6 --------
	goto	DIV6
;-------- endif --------
pb_lab8
;-------- l = i --------
	movf	ITMP,W
	movwf	LTMP
;-------- if l> 8 then --------
	movlw	8
	subwf	LTMP,W
	btfss	STATUS,CY
	goto	pb_lab9
;-------- l = l -7 --------
	movlw	7
	movwf	12
	Subwf	LTMP,W
	movwf	LTMP
;-------- i = 1 --------
	movlw	1
	movwf	ITMP
;-------- SetPorta:  --------
SETPORTA
;-------- l = l -1 --------
	decf	LTMP,F
;-------- if l<> 0 then --------
	movlw	0
	subwf	LTMP,W
	btfsc	STATUS,Z
	goto	pb_lab10
;-------- i = i<< 1 --------
	bcf 	STATUS,CY
	rlf 	ITMP,F
;-------- goto setPorta --------
	goto	SETPORTA
;-------- endif --------
pb_lab10
;-------- portb = 0 --------
	clrw
	movwf	PORTB
;-------- portA = i --------
	movf	ITMP,W
	movwf	PORTA
;-------- else --------
	goto	pb_lab11
pb_lab9
;-------- i = 2 --------
	movlw	2
	movwf	ITMP
;-------- SetPortb:  --------
SETPORTB
;-------- l = l -1 --------
	decf	LTMP,F
;-------- if l<> 0 then --------
	movlw	0
	subwf	LTMP,W
	btfsc	STATUS,Z
	goto	pb_lab12
;-------- i = i<< 1 --------
	bcf 	STATUS,CY
	rlf 	ITMP,F
;-------- goto setPortb --------
	goto	SETPORTB
;-------- endif --------
pb_lab12
;-------- portb = i --------
	movf	ITMP,W
	movwf	PORTB
;-------- portA = 0 --------
	clrw
	movwf	PORTA
;-------- endif --------
pb_lab11
;--------  --------
;-------- goto loop --------
	goto	LOOP
;'goto loop
;-------- INTERRUPT:  --------
_INT_PIC
;-------- asm { --------
        movwf   w_temp          ; sauver registre W
        swapf   STATUS,w        ; swap status avec rsultat dans w
        movwf   status_temp     ; sauver status swapp
        movf    FSR , w                 ; charger FSR
        movwf   FSR_temp        ; sauvegarder FSR
        movf    PCLATH, w       ; charger PCLATH
        movwf   PCLATH_temp     ; sauvegarder PCLATH
        clrf    PCLATH          ; passer en Page 0


      btfss   INTCON,T0IF
      GOTO    intsw0
      movlw   0
      movwf   TMR0
      bcf     INTCON,T0IF
        
                        ; Interruption rception USART
                        ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

intsw0
      btfss   INTCON,INTF
      GOTO    restorereg
      bcf     INTCON,INTF

        bsf STATUS,rp0
        btfsc OPTION_REG,INTEDG ; front montant
        goto UPFront
        bsf OPTION_REG,INTEDG ; front montant
        bcf STATUS,rp0
        Movf    TMR0,w
        Movwf Pulse     
        goto NextFront
UPFront
        bcf OPTION_REG,INTEDG ; front descendant
        bcf STATUS,rp0
NextFront
        Movlw 0
        movwf TMR0

restorereg
        movf    PCLATH_temp, w  ; charger PCLATH sauv
        movwf   PCLATH          ; restaurer PCLATH 
        movf    FSR_temp , w    ; charger FSR sauv
        movwf   FSR             ; restaurer FSR
        swapf   status_temp,w   ; swap ancien status, rsultat dans w
        movwf   STATUS          ; restaurer status
        swapf   w_temp,f        ; Inversion L et H de l'ancien W
                                        ; sans modifier Z
        swapf   w_temp,w        ; Rinversion de L et H dans W
                                ; W restaur sans modifier status
        retfie                  ; return from interrupt
;}
;'end
	sleep
	goto	_START_PIC
;
;**************************
;****** Library Area ******
_RAM equ 12
_RAM1 equ 13
_RAM2 equ 14
_RAM3 equ 15
_RAM4 equ 16
_RAM5 equ 17
_RAM6 equ 18
_RAM7 equ 19
_FLAGS equ 20
_PIN equ 21
_DELAYMS
	movwf	_RAM1
	clrf	_RAM
pb_lab13
	nop
	nop
	decfsz	_RAM,F
	goto	pb_lab13
	decfsz	_RAM1,F
	goto	pb_lab13
	retlw	0
;****** Library Area ******
;**************************
;

;
;***************************
;******* PRINT AREA *******
;******* PRINT AREA *******
;******* STRING AREA *******
;=======  No String  =======
;******* STRING AREA *******
;***************************
;
	end
