 /* 3-wire Serial LCD using 74HC595
Rajendra Bhatt, Sep 6, 2010
Initialize_LCD() : Initializes the 162 character LCD module to operate into 4-bit mode, 2 lines display, 57 size character, display ON, with cursor OFF.
Write_LCD_Data() : Sends a character byte to display at current cursor position.
Write_LCD_Cmd() : Writes a command byte to the LCD module.
Write_LCD_Nibble() : Used by Write_LCD_Data() and Write_LCD_Cmd() functions to send LCD data and command as two nibbles.
Write_LCD_Text() : Writes a character string at the current cursor position. Uses Write_LCD_Data() within a for loop.
Position_LCD() : Changes the current cursor position.
*/
sbit Data_Pin at GP5_bit;
sbit Clk_Pin at GP1_bit;
sbit Enable_Pin at GP2_bit;

// Always mention this definition statement
unsigned short Low_Nibble, High_Nibble, p, q,  Mask, N,t, RS, Flag, temp;
unsigned char ADC_Mesure;
unsigned char Beaufort;  // pour simuler la mesure vitesse du vent
unsigned char dummy;

void Delay_50ms(){
 Delay_ms(50);
}

void Write_LCD_Nibble(unsigned short N){
 Enable_Pin = 0;
 // ****** Write RS *********
 Clk_Pin = 0;
 Data_Pin = RS;
 Clk_Pin = 1;
 Clk_Pin = 0;
 // ****** End RS Write

 // Shift in 4 bits
 Mask = 8;
  for (t=0; t<4; t++){
   Flag = N & Mask;
   if(Flag==0) Data_Pin = 0;
   else Data_Pin = 1;
   Clk_Pin = 1;
   Clk_Pin = 0;
   Mask = Mask >> 1;
  }
  // One more clock because SC and ST clks are tied
  Clk_Pin = 1;
  Clk_Pin = 0;
  Data_Pin = 0;
  Enable_Pin = 1;
  Enable_Pin = 0;
}
// ******* Write Nibble Ends

 void Write_LCD_Data(unsigned short D){
 RS = 1; // It is Data, not command
 Low_Nibble = D & 15;
 High_Nibble = D/16;
 Write_LCD_Nibble(High_Nibble);
 Write_LCD_Nibble(Low_Nibble);
 }

void Write_LCD_Cmd(unsigned short C){
 RS = 0; // It is command, not data
 Low_Nibble = C & 15;
 High_Nibble = C/16;
 Write_LCD_Nibble(High_Nibble);
 Write_LCD_Nibble(Low_Nibble);
}

void Initialize_LCD(){
 Delay_50ms();
 Write_LCD_Cmd(0x20); // Wake-Up Sequence
 Delay_50ms();
 Write_LCD_Cmd(0x20);
 Delay_50ms();
 Write_LCD_Cmd(0x20);
 Delay_50ms();
 Write_LCD_Cmd(0x28); // 4-bits, 2 lines, 5x7 font
 Delay_50ms();
 Write_LCD_Cmd(0x0C); // Display ON, No cursors
 Delay_50ms();
 Write_LCD_Cmd(0x06); // Entry mode- Auto-increment, No Display shifting
 Delay_50ms();
 Write_LCD_Cmd(0x01);
 Delay_50ms();
}

void Position_LCD(unsigned short x, unsigned short y){
 temp = 127 + y;
 if (x == 2) temp = temp + 64;
 Write_LCD_Cmd(temp);
}

/*
void Write_LCD_Text(char *StrData){
 q = strlen(StrData);
 for (p = 0; p<q; p++){
  temp = StrData[p];
  Write_LCD_Data(temp);
 }
}
*/
//char Message1[] = "3-Wire LCD";
//char Message2[] = "using 74HC595";

void main() {
CMCON0 = 7;  // Disable Comparators
TRISIO = 0b00001000;  // All Outputs except GP3
ANSEL = 0x00; // No analog i/p
Beaufort=0;
Initialize_LCD();

do {
 Position_LCD(1,4);
 Write_LCD_Data(Beaufort+0x30);
 //Write_LCD_Text(Message1);
// Position_LCD(2,2);
// Write_LCD_Text(Message2);
 Delay_ms(1500);
// Write_LCD_Cmd(0x01);  // Clear LCD
// Delay_ms(1000);
  Beaufort++;
  if (Beaufort>9) Beaufort=0;
} while(1);

}

    /*
0 1 mikroCPIC1618.exe -MSF -DBG -pP12F683 -RA -C -O00000004 -fo4 -N"
C\_MikroC\_MesProjets_MikroC\_12F683_LCD_74HC595_SPI\SerialLcdTestforELab.mcppi" -SP"
124 123 Compiled Successfully 12F683_Minimal_Serial_Lcd_Test.c
Used RAM (bytes): 14
Used ROM (program words): 177 
0 103 Finished successfully: 20 juin 2015, 17:52:28 SerialLcdTestforELab.mcppi
*/