/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.hex.HexModel;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.gui.hex.HexFile;
import com.cburch.logisim.gui.hex.HexFrame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.MenuExtender;
import edu.cornell.cs3410.Mem;
import edu.cornell.cs3410.MemState;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

class MemMenu
implements ActionListener,
MenuExtender {
    private Mem factory;
    private Instance instance;
    private Project proj;
    private Frame frame;
    private CircuitState circState;
    private JMenuItem edit;
    private JMenuItem clear;
    private JMenuItem load;
    private JMenuItem save;

    MemMenu(Mem factory, Instance instance) {
        this.factory = factory;
        this.instance = instance;
    }

    public void configureMenu(JPopupMenu menu, Project proj) {
        this.proj = proj;
        this.frame = proj.getFrame();
        this.circState = proj.getCircuitState();
        AttributeSet attrs = this.instance.getAttributeSet();
        boolean enabled = this.circState != null;
        this.edit = this.createItem(enabled, "Edit Contents...");
        this.clear = this.createItem(enabled, "Clear Contents");
        this.load = this.createItem(enabled, "Load Image...");
        this.save = this.createItem(enabled, "Save Image...");
        menu.addSeparator();
        menu.add(this.edit);
        menu.add(this.clear);
        menu.add(this.load);
        menu.add(this.save);
    }

    private JMenuItem createItem(boolean enabled, String label) {
        JMenuItem ret = new JMenuItem(label);
        ret.setEnabled(enabled);
        ret.addActionListener(this);
        return ret;
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.edit) {
            this.doEdit();
        } else if (src == this.clear) {
            this.doClear();
        } else if (src == this.load) {
            this.doLoad();
        } else if (src == this.save) {
            this.doSave();
        }
    }

    private void doEdit() {
        MemState s = this.factory.getState(this.instance, this.circState);
        if (s == null) {
            return;
        }
        HexFrame frame = this.factory.getHexFrame(this.proj, this.instance, this.circState);
        frame.setVisible(true);
        frame.toFront();
    }

    private void doClear() {
        MemState s = this.factory.getState(this.instance, this.circState);
        boolean isAllZero = s.getContents().isClear();
        if (isAllZero) {
            return;
        }
        int choice = JOptionPane.showConfirmDialog(this.frame, "Are you sure you wish to zero out the memory?", "Confirm Clear", 0);
        if (choice == 0) {
            s.getContents().clear();
        }
    }

    private void doLoad() {
        MemState s = this.factory.getState(this.instance, this.circState);
        JFileChooser chooser = this.proj.createChooser();
        File oldSelected = this.factory.getCurrentImage(this.instance);
        if (oldSelected != null) {
            chooser.setSelectedFile(oldSelected);
        }
        chooser.setDialogTitle("Load RAM Image");
        int choice = chooser.showOpenDialog(this.frame);
        if (choice == 0) {
            File f = chooser.getSelectedFile();
            try {
                HexFile.open((HexModel)s.getContents(), (File)f);
                this.factory.setCurrentImage(this.instance, f);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Load Error", 0);
            }
        }
    }

    private void doSave() {
        MemState s = this.factory.getState(this.instance, this.circState);
        JFileChooser chooser = this.proj.createChooser();
        File oldSelected = this.factory.getCurrentImage(this.instance);
        if (oldSelected != null) {
            chooser.setSelectedFile(oldSelected);
        }
        chooser.setDialogTitle("Save RAM Image");
        int choice = chooser.showSaveDialog(this.frame);
        if (choice == 0) {
            File f = chooser.getSelectedFile();
            try {
                HexFile.save((File)f, (HexModel)s.getContents());
                this.factory.setCurrentImage(this.instance, f);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Save Error", 0);
            }
        }
    }
}

