/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import edu.cornell.cs3410.ProgramAssembler;
import edu.cornell.cs3410.ProgramAttributes;
import edu.cornell.cs3410.ProgramFrame32;
import edu.cornell.cs3410.ProgramState;
import edu.cornell.cs3410.SimpleStringGetter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

class Program32
extends InstanceFactory {
    static final int NUM_ROWS = 5;
    static final int CHIP_WIDTH = 240;
    static final int CHIP_DEPTH = 120;
    static final int PC_WIDTH = 32;
    static final int INST_WIDTH = 32;
    static final int BOX_WIDTH = 196;
    static final int ACOL_WIDTH = 54;
    static final int ARROW_WIDTH = 20;
    static final int P_PC = 0;
    static final int P_OP = 1;
    static final int NUM_PINS = 2;
    public static final Attribute<ProgramAssembler.Listing> CONTENTS_ATTR = new ContentsAttribute();

    public Program32() {
        super("MIPSProgramROM", (StringGetter)new SimpleStringGetter("MIPS Program ROM"));
        this.setAttributes(new Attribute[]{CONTENTS_ATTR}, new Object[]{new ProgramAssembler.Listing()});
        this.setOffsetBounds(Bounds.create((int)-240, (int)-60, (int)240, (int)120));
        this.setPorts(new Port[]{new Port(-230, 60, "input", 32), new Port(0, 0, "output", 32)});
        this.setInstancePoker(ProgramPoker.class);
    }

    private ProgramAssembler.Listing getCode(InstanceState state) {
        return (ProgramAssembler.Listing)state.getAttributeValue(CONTENTS_ATTR);
    }

    private Value val(InstanceState s, int pin) {
        return s.getPort(pin);
    }

    private int addr(InstanceState s, int pin) {
        return this.val(s, pin).toIntValue();
    }

    public void propagate(InstanceState state) {
        ProgramState programState = ProgramState.get(state, this.getCode(state));
        programState.update(this.val(state, 0));
        state.setPort(1, programState.instr(), 9);
    }

    private void drawBox(Graphics g, Bounds bds, Color color) {
        g.setColor(Color.WHITE);
        g.fillRect(bds.getX() + 20, bds.getY() + 5, 54, 110);
        g.fillRect(bds.getX() + 20, bds.getY() + 5, 196, 110);
        g.setColor(color);
        g.drawRect(bds.getX() + 20, bds.getY() + 5, 54, 110);
        g.drawRect(bds.getX() + 20, bds.getY() + 5, 196, 110);
        g.setColor(Color.BLACK);
    }

    private void drawArrow(Graphics g, Bounds bds, Color color) {
        int left = bds.getX() + 20 - 13;
        int c = bds.getY() + 50 + 10;
        int[] xs = new int[]{left, left + 8, left, left};
        int[] ys = new int[]{c - 5, c, c + 5, c - 5};
        g.setColor(color);
        g.fillPolygon(xs, ys, 4);
        g.setColor(Color.BLACK);
        g.drawPolyline(xs, ys, 4);
    }

    public void paintInstance(InstancePainter painter) {
        Bounds bds = painter.getBounds();
        painter.drawRectangle(bds, "");
        Graphics g = painter.getGraphics();
        GraphicsUtil.drawText((Graphics)g, (String)"PC", (int)(bds.getX() + 2), (int)(bds.getY() + 120 - 12), (int)-1, (int)0);
        GraphicsUtil.drawText((Graphics)g, (String)"Op", (int)(bds.getX() + 240 - 2), (int)(bds.getY() + 60), (int)1, (int)0);
        painter.drawPort(0);
        painter.drawPort(1);
        this.drawBox(g, bds, Color.GRAY);
        if (painter.getShowState()) {
            this.drawState(painter);
        }
    }

    public void paintIcon(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Font old = g.getFont();
        g.setFont(old.deriveFont(9.0f));
        GraphicsUtil.drawCenteredText((Graphics)g, (String)"ASM", (int)10, (int)9);
        g.setFont(old);
        g.drawRect(0, 4, 19, 12);
        for (int dx = 2; dx < 20; dx += 5) {
            g.drawLine(dx, 2, dx, 4);
            g.drawLine(dx, 16, dx, 18);
        }
    }

    private void drawState(InstancePainter painter) {
        Font font = new Font("Monospaced", 0, 10);
        ProgramState state = ProgramState.get((InstanceState)painter, this.getCode((InstanceState)painter));
        if (state.code == null || state.code.isEmpty()) {
            return;
        }
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        Color arrowcolor = state.isErrorPC() ? Color.RED : (state.isUndefinedPC() ? Color.GRAY : (state.haveCodeFor(state.pc) ? Color.BLUE : Color.BLUE));
        this.drawArrow(g, bds, arrowcolor);
        int j = -1;
        int pc = state.isValidPC() ? state.pc : -1;
        for (int i = pc - 2; i <= pc + 2; ++i) {
            ++j;
            if (i < 0 || i > 0x3FFFFFFF) continue;
            if (i == state.pc) {
                g.setColor(Color.BLUE);
            } else if (!state.haveCodeFor(i)) {
                g.setColor(Color.GRAY);
            }
            GraphicsUtil.drawText((Graphics)g, (Font)font, (String)StringUtil.toHexString((int)32, (int)(i * 4)), (int)(bds.getX() + 20 + 2), (int)(bds.getY() + 20 * j + 10 + 10), (int)-1, (int)0);
            GraphicsUtil.drawText((Graphics)g, (Font)font, (String)state.decode(i), (int)(bds.getX() + 20 + 54 + 1), (int)(bds.getY() + 20 * j + 10 + 10), (int)-1, (int)0);
            g.setColor(Color.BLACK);
        }
    }

    public static class ProgramPoker
    extends InstancePoker {
        public boolean init(InstanceState state, MouseEvent e) {
            return state.getInstance().getBounds().contains(e.getX(), e.getY());
        }
    }

    private static class ContentsCell
    extends JLabel
    implements MouseListener {
        private static final long serialVersionUID = -2005158851998108994L;
        private Window source;
        private ProgramAssembler.Listing code;

        ContentsCell(Window source, ProgramAssembler.Listing code) {
            super("(click here to edit)");
            this.source = source;
            this.code = code;
            this.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent e) {
            if (this.code == null) {
                return;
            }
            Project proj = this.source instanceof Frame ? ((Frame)this.source).getProject() : null;
            ProgramFrame32 frame = ProgramAttributes.getProgramFrame(this.code, proj);
            frame.setVisible(true);
            frame.toFront();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContentsAttribute
    extends Attribute<ProgramAssembler.Listing> {
        public ContentsAttribute() {
            super("contents", (StringGetter)new SimpleStringGetter("MIPS Program Listing"));
        }

        public Component getCellEditor(Window source, ProgramAssembler.Listing value) {
            if (source instanceof Frame) {
                Project proj = ((Frame)source).getProject();
                ProgramAssembler.Listing code = value;
                ProgramState state = code.getState();
                if (state != null) {
                    state.setProject(proj);
                }
            }
            ContentsCell cell = new ContentsCell(source, value);
            cell.mouseClicked(null);
            return cell;
        }

        public String toDisplayString(ProgramAssembler.Listing value) {
            return "(click to edit)";
        }

        public String toStandardString(ProgramAssembler.Listing value) {
            return value.getSource();
        }

        public ProgramAssembler.Listing parse(String value) {
            try {
                return new ProgramAssembler.Listing(value);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "The contents of the Program chip could not be read: " + e.getMessage(), "Error loading MIPS program.", 0);
                return new ProgramAssembler.Listing();
            }
        }
    }
}

