/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import edu.cornell.cs3410.RegisterData;
import edu.cornell.cs3410.RegisterUtils;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class RegisterPoker
extends InstancePoker {
    private int idx;
    private int idx2;

    public boolean init(InstanceState state, MouseEvent e) {
        return state.getInstance().getBounds().contains(e.getX(), e.getY());
    }

    public void paint(InstancePainter painter) {
        if (this.idx < 1) {
            return;
        }
        Bounds bounds = painter.getInstance().getBounds();
        RegisterUtils.drawBox(painter.getGraphics(), bounds, Color.RED, this.idx);
    }

    public void keyTyped(InstanceState state, KeyEvent e) {
        int a2;
        Value val;
        RegisterData data = RegisterData.get(state);
        if (this.idx < 1) {
            return;
        }
        int nue = Character.digit(e.getKeyChar(), 16);
        if (nue < 0) {
            return;
        }
        int old = data.regs[this.idx].isFullyDefined() ? data.regs[this.idx].toIntValue() : 0;
        data.regs[this.idx] = val = Value.createKnown((BitWidth)RegisterUtils.WIDTH, (int)(old << 4 | nue));
        int a1 = RegisterUtils.addr(state, 6);
        if (a1 == this.idx) {
            state.setPort(1, val, 1);
        }
        if ((a2 = RegisterUtils.addr(state, 7)) == this.idx) {
            state.setPort(2, val, 1);
        }
    }

    public void mousePressed(InstanceState state, MouseEvent e) {
        Bounds bounds = state.getInstance().getBounds();
        this.idx2 = this.getRIndex(bounds, e.getX(), e.getY());
    }

    public void mouseReleased(InstanceState state, MouseEvent e) {
        Bounds bounds = state.getInstance().getBounds();
        int idx3 = this.getRIndex(bounds, e.getX(), e.getY());
        if (idx3 < 1 || this.idx2 != idx3) {
            this.idx = 0;
            return;
        }
        this.idx = idx3;
    }

    public void keyPressed(InstanceState state, KeyEvent e) {
        if (this.idx < 0) {
            return;
        }
        switch (e.getKeyCode()) {
            case 40: 
            case 225: {
                if (this.idx >= 31) break;
                ++this.idx;
                break;
            }
            case 39: 
            case 227: {
                if (0 >= this.idx || this.idx >= 16) break;
                this.idx += 16;
                break;
            }
            case 38: 
            case 224: {
                if (this.idx <= 1) break;
                --this.idx;
                break;
            }
            case 37: 
            case 226: {
                if (this.idx <= 16) break;
                this.idx -= 16;
            }
        }
    }

    private int getRIndex(Bounds bounds, int x, int y) {
        y -= bounds.getY();
        if ((x -= bounds.getX()) < RegisterUtils.boxX(0) - 1 || x > RegisterUtils.boxX(31) + 50 + 1) {
            return -1;
        }
        if (x > RegisterUtils.boxX(0) + 50 + 1 && x < RegisterUtils.boxX(31) - 1) {
            return -1;
        }
        if (y < RegisterUtils.boxY(0) || y > RegisterUtils.boxY(31) + 10) {
            return -1;
        }
        int i = y / 10;
        if (x > 80) {
            i += 16;
        }
        if (i < 0 || i >= 32) {
            return -1;
        }
        return i;
    }
}

