* -----------------------------------------------------------------
* By Erdemal                                        April  9, 2015
* Special thanks to Bordodynov, Helmut and analogspiceman
* -----------------------------------------------------------------
* Computes transformer parameters from Ns, Np, Core Hc Br Bs, K coupling factor
* source theory http://info.ee.surrey.ac.uk/Workshop/advice/coils/terms.html#example
* source coupling http://en.wikipedia.org/wiki/Leakage_inductance
.param u0ur=Br/Hc                 ; small signal linear permeabilty
.param Rm=(Lm/A)/u0ur             ; reluctance (Lg=0)
.param Al=1/Rm                    ; inductance factor
.param Lp=(Np**2)*Al              ; primamy inductance no secondary
.param Ls=(Ns**2)*Al              ; secondary inductance no primary
.param M=mFactor*sqrt(Ls*Lp)      ; mutual inductance
.param Lleakp=Lp*(1-mFactor)      ; primary leakage inductance
.param Lleaks=Ls*(1-mFactor)      ; secondary leakage inductance
.param Nmagn=Np*sqrt(mFactor)     ; magnetising inductance seen from primary
* -----------------------------------------------------------------
* Displays values in Spice Error log   =   debug help
* -----------------------------------------------------------------
.meas t_Hc param Hc
.meas t_bs param Bs
.meas t_br param Br
.meas t_np param Np
.meas t_ns param Ns
.meas t_Ratio param Ratio
.meas t_mFactor param mFactor
* -----------------------------------------------------------------
* CORE
.meas core_permeability param u0ur 
.meas core_reluctance param Rm 
.meas core_inductance_factor param Al 
.meas mutual_inductance param M  
* -----------------------------------------------------------------
* PRIMARY
.meas prim_Wind_Resistance param Rlp
.meas prim_resistance param Rp
.meas prim_magn_induc param Lmagnp
.meas prim_leak_induc param Lleakp
.meas prim_Lp_Induc param Lp
* -----------------------------------------------------------------
* SECONDARY
.meas sec_wind_resistance param rls
.meas sec_resistor param Rs
.meas sec_leak_induc param Lleaks
.meas sec_Ls_induc param Ls
* -----------------------------------------------------------------
