#include <avr/io.h>

void init_USART(unsigned char speed,unsigned char parity)
	{
			UCSR1C |= (1 << UCSZ11) | (1 << UCSZ10); // data sur 8bits
			UCSR1A |= (1 << U2X1); //double la vitesse de transfer
			UCSR1B |= (1 << RXEN1) | (1 << TXEN1);	// activation de RX et TX

			//UBRRH = (speed >> 8);
			UBRR1L = speed;    //baud rate (voir la datasheet pour le calcul P189)

			if (parity == 0)  UCSR1C &= ~((1<< UPM11) | (1 << UPM10));        //pas de parit
			if (parity == 1)  UCSR1C |= (1 << UPM11);                       //parit even
			if (parity == 2)  UCSR1C |= (1 << UPM11) | (1 << UPM10);        //parit odd (Data p 190)
	};