#ifndef USART_INCLUDED
#define USART_INCLUDED

//BaudValue = (((F_CPU / (USART_BAUDRATE * 16))) - 1)
#define BAUD_RATE_9600 103
#define BAUD_RATE_19200 51
#define BAUD_RATE_115200 8

#define ODD        2
#define EVEN       1
#define NO_PARITY  0

#define USART1_IRQ_RX_on   UCSR1B |= (1 << RXCIE1) // active l'IRQ lorsque le registre de receive est charg flag (RXC1)
#define USART1_IRQ_RX_off  UCSR1B &= ~(1 << RXCIE1)

#define USART1_IRQ_TX_on   UCSR1B |= (1 << TXCIE1) // active l'IRQ sur lorsque le registre de transmitting est charg flag (TXC1)
#define USART1_IRQ_TX_off  UCSR1B &= ~(1 << TXCIE1)

#define VT100_retour_ligne  send_char(0x0D);\
send_char('\n');

#define send_char(caractere)         \
while (!(UCSR1A & (1 << UDRE1)));    \
UDR1 = caractere

#define get_char()         \
while (!(UCSR1A & (1 << RXC1)));    \
caractere = UDR1

void init_USART(unsigned char speed,unsigned char parity);

#endif